/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.authorization.fluent.models.DirectoryObjectInner;
import com.azure.resourcemanager.authorization.fluent.models.KeyCredentialInner;
import com.azure.resourcemanager.authorization.fluent.models.PasswordCredentialInner;
import com.azure.resourcemanager.authorization.models.AppRole;
import com.azure.resourcemanager.authorization.models.OAuth2Permission;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.List;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="objectType")
@JsonTypeName(value="ServicePrincipal")
public final class ServicePrincipalInner
extends DirectoryObjectInner {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(ServicePrincipalInner.class);
    @JsonProperty(value="accountEnabled")
    private Boolean accountEnabled;
    @JsonProperty(value="alternativeNames")
    private List<String> alternativeNames;
    @JsonProperty(value="appDisplayName", access=JsonProperty.Access.WRITE_ONLY)
    private String appDisplayName;
    @JsonProperty(value="appId")
    private String appId;
    @JsonProperty(value="appOwnerTenantId", access=JsonProperty.Access.WRITE_ONLY)
    private String appOwnerTenantId;
    @JsonProperty(value="appRoleAssignmentRequired")
    private Boolean appRoleAssignmentRequired;
    @JsonProperty(value="appRoles")
    private List<AppRole> appRoles;
    @JsonProperty(value="displayName")
    private String displayName;
    @JsonProperty(value="errorUrl")
    private String errorUrl;
    @JsonProperty(value="homepage")
    private String homepage;
    @JsonProperty(value="keyCredentials")
    private List<KeyCredentialInner> keyCredentials;
    @JsonProperty(value="logoutUrl")
    private String logoutUrl;
    @JsonProperty(value="oauth2Permissions", access=JsonProperty.Access.WRITE_ONLY)
    private List<OAuth2Permission> oauth2Permissions;
    @JsonProperty(value="passwordCredentials")
    private List<PasswordCredentialInner> passwordCredentials;
    @JsonProperty(value="preferredTokenSigningKeyThumbprint")
    private String preferredTokenSigningKeyThumbprint;
    @JsonProperty(value="publisherName")
    private String publisherName;
    @JsonProperty(value="replyUrls")
    private List<String> replyUrls;
    @JsonProperty(value="samlMetadataUrl")
    private String samlMetadataUrl;
    @JsonProperty(value="servicePrincipalNames")
    private List<String> servicePrincipalNames;
    @JsonProperty(value="servicePrincipalType")
    private String servicePrincipalType;
    @JsonProperty(value="tags")
    private List<String> tags;

    public Boolean accountEnabled() {
        return this.accountEnabled;
    }

    public ServicePrincipalInner withAccountEnabled(Boolean accountEnabled) {
        this.accountEnabled = accountEnabled;
        return this;
    }

    public List<String> alternativeNames() {
        return this.alternativeNames;
    }

    public ServicePrincipalInner withAlternativeNames(List<String> alternativeNames) {
        this.alternativeNames = alternativeNames;
        return this;
    }

    public String appDisplayName() {
        return this.appDisplayName;
    }

    public String appId() {
        return this.appId;
    }

    public ServicePrincipalInner withAppId(String appId) {
        this.appId = appId;
        return this;
    }

    public String appOwnerTenantId() {
        return this.appOwnerTenantId;
    }

    public Boolean appRoleAssignmentRequired() {
        return this.appRoleAssignmentRequired;
    }

    public ServicePrincipalInner withAppRoleAssignmentRequired(Boolean appRoleAssignmentRequired) {
        this.appRoleAssignmentRequired = appRoleAssignmentRequired;
        return this;
    }

    public List<AppRole> appRoles() {
        return this.appRoles;
    }

    public ServicePrincipalInner withAppRoles(List<AppRole> appRoles) {
        this.appRoles = appRoles;
        return this;
    }

    public String displayName() {
        return this.displayName;
    }

    public ServicePrincipalInner withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    public String errorUrl() {
        return this.errorUrl;
    }

    public ServicePrincipalInner withErrorUrl(String errorUrl) {
        this.errorUrl = errorUrl;
        return this;
    }

    public String homepage() {
        return this.homepage;
    }

    public ServicePrincipalInner withHomepage(String homepage) {
        this.homepage = homepage;
        return this;
    }

    public List<KeyCredentialInner> keyCredentials() {
        return this.keyCredentials;
    }

    public ServicePrincipalInner withKeyCredentials(List<KeyCredentialInner> keyCredentials) {
        this.keyCredentials = keyCredentials;
        return this;
    }

    public String logoutUrl() {
        return this.logoutUrl;
    }

    public ServicePrincipalInner withLogoutUrl(String logoutUrl) {
        this.logoutUrl = logoutUrl;
        return this;
    }

    public List<OAuth2Permission> oauth2Permissions() {
        return this.oauth2Permissions;
    }

    public List<PasswordCredentialInner> passwordCredentials() {
        return this.passwordCredentials;
    }

    public ServicePrincipalInner withPasswordCredentials(List<PasswordCredentialInner> passwordCredentials) {
        this.passwordCredentials = passwordCredentials;
        return this;
    }

    public String preferredTokenSigningKeyThumbprint() {
        return this.preferredTokenSigningKeyThumbprint;
    }

    public ServicePrincipalInner withPreferredTokenSigningKeyThumbprint(String preferredTokenSigningKeyThumbprint) {
        this.preferredTokenSigningKeyThumbprint = preferredTokenSigningKeyThumbprint;
        return this;
    }

    public String publisherName() {
        return this.publisherName;
    }

    public ServicePrincipalInner withPublisherName(String publisherName) {
        this.publisherName = publisherName;
        return this;
    }

    public List<String> replyUrls() {
        return this.replyUrls;
    }

    public ServicePrincipalInner withReplyUrls(List<String> replyUrls) {
        this.replyUrls = replyUrls;
        return this;
    }

    public String samlMetadataUrl() {
        return this.samlMetadataUrl;
    }

    public ServicePrincipalInner withSamlMetadataUrl(String samlMetadataUrl) {
        this.samlMetadataUrl = samlMetadataUrl;
        return this;
    }

    public List<String> servicePrincipalNames() {
        return this.servicePrincipalNames;
    }

    public ServicePrincipalInner withServicePrincipalNames(List<String> servicePrincipalNames) {
        this.servicePrincipalNames = servicePrincipalNames;
        return this;
    }

    public String servicePrincipalType() {
        return this.servicePrincipalType;
    }

    public ServicePrincipalInner withServicePrincipalType(String servicePrincipalType) {
        this.servicePrincipalType = servicePrincipalType;
        return this;
    }

    public List<String> tags() {
        return this.tags;
    }

    public ServicePrincipalInner withTags(List<String> tags) {
        this.tags = tags;
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.appRoles() != null) {
            this.appRoles().forEach(e -> e.validate());
        }
        if (this.keyCredentials() != null) {
            this.keyCredentials().forEach(e -> e.validate());
        }
        if (this.oauth2Permissions() != null) {
            this.oauth2Permissions().forEach(e -> e.validate());
        }
        if (this.passwordCredentials() != null) {
            this.passwordCredentials().forEach(e -> e.validate());
        }
    }
}

