/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.authorization.implementation;

import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.authorization.fluent.DeletedApplicationsClient;
import com.azure.resourcemanager.authorization.fluent.models.ApplicationInner;
import com.azure.resourcemanager.authorization.implementation.GraphRbacManagementClientImpl;
import com.azure.resourcemanager.authorization.models.ApplicationListResult;
import com.azure.resourcemanager.authorization.models.GraphErrorException;
import reactor.core.publisher.Mono;

public final class DeletedApplicationsClientImpl
implements DeletedApplicationsClient {
    private final ClientLogger logger = new ClientLogger(DeletedApplicationsClientImpl.class);
    private final DeletedApplicationsService service;
    private final GraphRbacManagementClientImpl client;

    DeletedApplicationsClientImpl(GraphRbacManagementClientImpl client) {
        this.service = (DeletedApplicationsService)RestProxy.create(DeletedApplicationsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @Override
    public Mono<Response<ApplicationInner>> restoreWithResponseAsync(String objectId) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (objectId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter objectId is required and cannot be null."));
        }
        if (this.client.getTenantId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getTenantId() is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.restore(this.client.getEndpoint(), objectId, this.client.getApiVersion(), this.client.getTenantId(), (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<ApplicationInner>> restoreWithResponseAsync(String objectId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (objectId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter objectId is required and cannot be null."));
        }
        if (this.client.getTenantId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getTenantId() is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.restore(this.client.getEndpoint(), objectId, this.client.getApiVersion(), this.client.getTenantId(), context);
    }

    @Override
    public Mono<ApplicationInner> restoreAsync(String objectId) {
        return this.restoreWithResponseAsync(objectId).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((ApplicationInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    public ApplicationInner restore(String objectId) {
        return (ApplicationInner)this.restoreAsync(objectId).block();
    }

    @Override
    public Response<ApplicationInner> restoreWithResponse(String objectId, Context context) {
        return (Response)this.restoreWithResponseAsync(objectId, context).block();
    }

    private Mono<PagedResponse<ApplicationInner>> listSinglePageAsync(String filter) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getTenantId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getTenantId() is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.list(this.client.getEndpoint(), filter, this.client.getApiVersion(), this.client.getTenantId(), (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ApplicationListResult)res.getValue()).value(), ((ApplicationListResult)res.getValue()).odataNextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<ApplicationInner>> listSinglePageAsync(String filter, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getTenantId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getTenantId() is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.list(this.client.getEndpoint(), filter, this.client.getApiVersion(), this.client.getTenantId(), context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ApplicationListResult)res.getValue()).value(), ((ApplicationListResult)res.getValue()).odataNextLink(), null));
    }

    @Override
    public PagedFlux<ApplicationInner> listAsync(String filter) {
        return new PagedFlux(() -> this.listSinglePageAsync(filter), nextLink -> this.listNextSinglePageAsync((String)nextLink));
    }

    @Override
    public PagedFlux<ApplicationInner> listAsync() {
        String filter = null;
        return new PagedFlux(() -> this.listSinglePageAsync(filter), nextLink -> this.listNextSinglePageAsync((String)nextLink));
    }

    private PagedFlux<ApplicationInner> listAsync(String filter, Context context) {
        return new PagedFlux(() -> this.listSinglePageAsync(filter, context), nextLink -> this.listNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    public PagedIterable<ApplicationInner> list(String filter, Context context) {
        return new PagedIterable(this.listAsync(filter, context));
    }

    @Override
    public PagedIterable<ApplicationInner> list() {
        String filter = null;
        return new PagedIterable(this.listAsync(filter));
    }

    @Override
    public Mono<Response<Void>> hardDeleteWithResponseAsync(String applicationObjectId) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (applicationObjectId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter applicationObjectId is required and cannot be null."));
        }
        if (this.client.getTenantId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getTenantId() is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.hardDelete(this.client.getEndpoint(), applicationObjectId, this.client.getApiVersion(), this.client.getTenantId(), (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<Void>> hardDeleteWithResponseAsync(String applicationObjectId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (applicationObjectId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter applicationObjectId is required and cannot be null."));
        }
        if (this.client.getTenantId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getTenantId() is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.hardDelete(this.client.getEndpoint(), applicationObjectId, this.client.getApiVersion(), this.client.getTenantId(), context);
    }

    @Override
    public Mono<Void> hardDeleteAsync(String applicationObjectId) {
        return this.hardDeleteWithResponseAsync(applicationObjectId).flatMap(res -> Mono.empty());
    }

    @Override
    public void hardDelete(String applicationObjectId) {
        this.hardDeleteAsync(applicationObjectId).block();
    }

    @Override
    public Response<Void> hardDeleteWithResponse(String applicationObjectId, Context context) {
        return (Response)this.hardDeleteWithResponseAsync(applicationObjectId, context).block();
    }

    private Mono<PagedResponse<ApplicationInner>> listNextSinglePageAsync(String nextLink) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getTenantId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getTenantId() is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.listNext(this.client.getEndpoint(), nextLink, this.client.getApiVersion(), this.client.getTenantId(), (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ApplicationListResult)res.getValue()).value(), ((ApplicationListResult)res.getValue()).odataNextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<ApplicationInner>> listNextSinglePageAsync(String nextLink, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getTenantId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getTenantId() is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.listNext(this.client.getEndpoint(), nextLink, this.client.getApiVersion(), this.client.getTenantId(), context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ApplicationListResult)res.getValue()).value(), ((ApplicationListResult)res.getValue()).odataNextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="GraphRbacManagementC")
    private static interface DeletedApplicationsService {
        @Headers(value={"Accept: application/json,text/json", "Content-Type: application/json"})
        @Post(value="/{tenantID}/deletedApplications/{objectId}/restore")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=GraphErrorException.class)
        public Mono<Response<ApplicationInner>> restore(@HostParam(value="$host") String var1, @PathParam(value="objectId") String var2, @QueryParam(value="api-version") String var3, @PathParam(value="tenantID") String var4, Context var5);

        @Headers(value={"Accept: application/json,text/json", "Content-Type: application/json"})
        @Get(value="/{tenantID}/deletedApplications")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=GraphErrorException.class)
        public Mono<Response<ApplicationListResult>> list(@HostParam(value="$host") String var1, @QueryParam(value="$filter") String var2, @QueryParam(value="api-version") String var3, @PathParam(value="tenantID") String var4, Context var5);

        @Headers(value={"Accept: application/json;q=0.9", "Content-Type: application/json"})
        @Delete(value="/{tenantID}/deletedApplications/{applicationObjectId}")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=GraphErrorException.class)
        public Mono<Response<Void>> hardDelete(@HostParam(value="$host") String var1, @PathParam(value="applicationObjectId") String var2, @QueryParam(value="api-version") String var3, @PathParam(value="tenantID") String var4, Context var5);

        @Headers(value={"Accept: application/json,text/json", "Content-Type: application/json"})
        @Get(value="/{tenantID}/{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=GraphErrorException.class)
        public Mono<Response<ApplicationListResult>> listNext(@HostParam(value="$host") String var1, @PathParam(value="nextLink", encoded=true) String var2, @QueryParam(value="api-version") String var3, @PathParam(value="tenantID") String var4, Context var5);
    }
}

