/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.authorization.implementation;

import com.azure.core.annotation.ServiceClientBuilder;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpPipelineBuilder;
import com.azure.core.http.policy.CookiePolicy;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.http.policy.RetryPolicy;
import com.azure.core.http.policy.UserAgentPolicy;
import com.azure.core.management.AzureEnvironment;
import com.azure.core.management.serializer.SerializerFactory;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.authorization.implementation.GraphRbacManagementClientImpl;
import java.time.Duration;

@ServiceClientBuilder(serviceClients={GraphRbacManagementClientImpl.class})
public final class GraphRbacManagementClientBuilder {
    private String tenantId;
    private String endpoint;
    private AzureEnvironment environment;
    private Duration defaultPollInterval;
    private HttpPipeline pipeline;
    private SerializerAdapter serializerAdapter;

    public GraphRbacManagementClientBuilder tenantId(String tenantId) {
        this.tenantId = tenantId;
        return this;
    }

    public GraphRbacManagementClientBuilder endpoint(String endpoint) {
        this.endpoint = endpoint;
        return this;
    }

    public GraphRbacManagementClientBuilder environment(AzureEnvironment environment) {
        this.environment = environment;
        return this;
    }

    public GraphRbacManagementClientBuilder defaultPollInterval(Duration defaultPollInterval) {
        this.defaultPollInterval = defaultPollInterval;
        return this;
    }

    public GraphRbacManagementClientBuilder pipeline(HttpPipeline pipeline) {
        this.pipeline = pipeline;
        return this;
    }

    public GraphRbacManagementClientBuilder serializerAdapter(SerializerAdapter serializerAdapter) {
        this.serializerAdapter = serializerAdapter;
        return this;
    }

    public GraphRbacManagementClientImpl buildClient() {
        if (this.endpoint == null) {
            this.endpoint = "https://graph.windows.net";
        }
        if (this.environment == null) {
            this.environment = AzureEnvironment.AZURE;
        }
        if (this.defaultPollInterval == null) {
            this.defaultPollInterval = Duration.ofSeconds(30L);
        }
        if (this.pipeline == null) {
            this.pipeline = new HttpPipelineBuilder().policies(new HttpPipelinePolicy[]{new UserAgentPolicy(), new RetryPolicy(), new CookiePolicy()}).build();
        }
        if (this.serializerAdapter == null) {
            this.serializerAdapter = SerializerFactory.createDefaultManagementSerializerAdapter();
        }
        GraphRbacManagementClientImpl client = new GraphRbacManagementClientImpl(this.pipeline, this.serializerAdapter, this.defaultPollInterval, this.environment, this.tenantId, this.endpoint);
        return client;
    }
}

