/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.authorization.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.authorization.fluent.UsersClient;
import com.azure.resourcemanager.authorization.fluent.models.UserInner;
import com.azure.resourcemanager.authorization.implementation.GraphRbacManagementClientImpl;
import com.azure.resourcemanager.authorization.models.GraphErrorException;
import com.azure.resourcemanager.authorization.models.UserCreateParameters;
import com.azure.resourcemanager.authorization.models.UserGetMemberGroupsParameters;
import com.azure.resourcemanager.authorization.models.UserGetMemberGroupsResult;
import com.azure.resourcemanager.authorization.models.UserListResult;
import com.azure.resourcemanager.authorization.models.UserUpdateParameters;
import reactor.core.publisher.Mono;

public final class UsersClientImpl
implements UsersClient {
    private final ClientLogger logger = new ClientLogger(UsersClientImpl.class);
    private final UsersService service;
    private final GraphRbacManagementClientImpl client;

    UsersClientImpl(GraphRbacManagementClientImpl client) {
        this.service = (UsersService)RestProxy.create(UsersService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @Override
    public Mono<Response<UserInner>> createWithResponseAsync(UserCreateParameters parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getTenantId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getTenantId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        return FluxUtil.withContext(context -> this.service.create(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getTenantId(), parameters, (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<UserInner>> createWithResponseAsync(UserCreateParameters parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getTenantId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getTenantId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        context = this.client.mergeContext(context);
        return this.service.create(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getTenantId(), parameters, context);
    }

    @Override
    public Mono<UserInner> createAsync(UserCreateParameters parameters) {
        return this.createWithResponseAsync(parameters).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((UserInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    public UserInner create(UserCreateParameters parameters) {
        return (UserInner)this.createAsync(parameters).block();
    }

    @Override
    public Response<UserInner> createWithResponse(UserCreateParameters parameters, Context context) {
        return (Response)this.createWithResponseAsync(parameters, context).block();
    }

    private Mono<PagedResponse<UserInner>> listSinglePageAsync(String filter, String expand) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getTenantId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getTenantId() is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.list(this.client.getEndpoint(), filter, expand, this.client.getApiVersion(), this.client.getTenantId(), (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((UserListResult)res.getValue()).value(), ((UserListResult)res.getValue()).odataNextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<UserInner>> listSinglePageAsync(String filter, String expand, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getTenantId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getTenantId() is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.list(this.client.getEndpoint(), filter, expand, this.client.getApiVersion(), this.client.getTenantId(), context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((UserListResult)res.getValue()).value(), ((UserListResult)res.getValue()).odataNextLink(), null));
    }

    @Override
    public PagedFlux<UserInner> listAsync(String filter, String expand) {
        return new PagedFlux(() -> this.listSinglePageAsync(filter, expand), nextLink -> this.listNextSinglePageAsync((String)nextLink));
    }

    @Override
    public PagedFlux<UserInner> listAsync() {
        String filter = null;
        String expand = null;
        return new PagedFlux(() -> this.listSinglePageAsync(filter, expand), nextLink -> this.listNextSinglePageAsync((String)nextLink));
    }

    private PagedFlux<UserInner> listAsync(String filter, String expand, Context context) {
        return new PagedFlux(() -> this.listSinglePageAsync(filter, expand, context), nextLink -> this.listNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    public PagedIterable<UserInner> list(String filter, String expand, Context context) {
        return new PagedIterable(this.listAsync(filter, expand, context));
    }

    @Override
    public PagedIterable<UserInner> list() {
        String filter = null;
        String expand = null;
        return new PagedIterable(this.listAsync(filter, expand));
    }

    @Override
    public Mono<Response<UserInner>> getWithResponseAsync(String upnOrObjectId) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (upnOrObjectId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter upnOrObjectId is required and cannot be null."));
        }
        if (this.client.getTenantId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getTenantId() is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), upnOrObjectId, this.client.getApiVersion(), this.client.getTenantId(), (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<UserInner>> getWithResponseAsync(String upnOrObjectId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (upnOrObjectId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter upnOrObjectId is required and cannot be null."));
        }
        if (this.client.getTenantId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getTenantId() is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), upnOrObjectId, this.client.getApiVersion(), this.client.getTenantId(), context);
    }

    @Override
    public Mono<UserInner> getAsync(String upnOrObjectId) {
        return this.getWithResponseAsync(upnOrObjectId).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((UserInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    public UserInner get(String upnOrObjectId) {
        return (UserInner)this.getAsync(upnOrObjectId).block();
    }

    @Override
    public Response<UserInner> getWithResponse(String upnOrObjectId, Context context) {
        return (Response)this.getWithResponseAsync(upnOrObjectId, context).block();
    }

    @Override
    public Mono<Response<Void>> updateWithResponseAsync(String upnOrObjectId, UserUpdateParameters parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (upnOrObjectId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter upnOrObjectId is required and cannot be null."));
        }
        if (this.client.getTenantId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getTenantId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        return FluxUtil.withContext(context -> this.service.update(this.client.getEndpoint(), upnOrObjectId, this.client.getApiVersion(), this.client.getTenantId(), parameters, (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<Void>> updateWithResponseAsync(String upnOrObjectId, UserUpdateParameters parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (upnOrObjectId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter upnOrObjectId is required and cannot be null."));
        }
        if (this.client.getTenantId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getTenantId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        context = this.client.mergeContext(context);
        return this.service.update(this.client.getEndpoint(), upnOrObjectId, this.client.getApiVersion(), this.client.getTenantId(), parameters, context);
    }

    @Override
    public Mono<Void> updateAsync(String upnOrObjectId, UserUpdateParameters parameters) {
        return this.updateWithResponseAsync(upnOrObjectId, parameters).flatMap(res -> Mono.empty());
    }

    @Override
    public void update(String upnOrObjectId, UserUpdateParameters parameters) {
        this.updateAsync(upnOrObjectId, parameters).block();
    }

    @Override
    public Response<Void> updateWithResponse(String upnOrObjectId, UserUpdateParameters parameters, Context context) {
        return (Response)this.updateWithResponseAsync(upnOrObjectId, parameters, context).block();
    }

    @Override
    public Mono<Response<Void>> deleteWithResponseAsync(String upnOrObjectId) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (upnOrObjectId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter upnOrObjectId is required and cannot be null."));
        }
        if (this.client.getTenantId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getTenantId() is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), upnOrObjectId, this.client.getApiVersion(), this.client.getTenantId(), (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<Void>> deleteWithResponseAsync(String upnOrObjectId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (upnOrObjectId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter upnOrObjectId is required and cannot be null."));
        }
        if (this.client.getTenantId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getTenantId() is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.delete(this.client.getEndpoint(), upnOrObjectId, this.client.getApiVersion(), this.client.getTenantId(), context);
    }

    @Override
    public Mono<Void> deleteAsync(String upnOrObjectId) {
        return this.deleteWithResponseAsync(upnOrObjectId).flatMap(res -> Mono.empty());
    }

    @Override
    public void delete(String upnOrObjectId) {
        this.deleteAsync(upnOrObjectId).block();
    }

    @Override
    public Response<Void> deleteWithResponse(String upnOrObjectId, Context context) {
        return (Response)this.deleteWithResponseAsync(upnOrObjectId, context).block();
    }

    private Mono<PagedResponse<String>> getMemberGroupsSinglePageAsync(String objectId, boolean securityEnabledOnly) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (objectId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter objectId is required and cannot be null."));
        }
        if (this.client.getTenantId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getTenantId() is required and cannot be null."));
        }
        UserGetMemberGroupsParameters parameters = new UserGetMemberGroupsParameters();
        parameters.withSecurityEnabledOnly(securityEnabledOnly);
        return FluxUtil.withContext(context -> this.service.getMemberGroups(this.client.getEndpoint(), objectId, this.client.getApiVersion(), this.client.getTenantId(), parameters, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((UserGetMemberGroupsResult)res.getValue()).value(), null, null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<String>> getMemberGroupsSinglePageAsync(String objectId, boolean securityEnabledOnly, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (objectId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter objectId is required and cannot be null."));
        }
        if (this.client.getTenantId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getTenantId() is required and cannot be null."));
        }
        UserGetMemberGroupsParameters parameters = new UserGetMemberGroupsParameters();
        parameters.withSecurityEnabledOnly(securityEnabledOnly);
        context = this.client.mergeContext(context);
        return this.service.getMemberGroups(this.client.getEndpoint(), objectId, this.client.getApiVersion(), this.client.getTenantId(), parameters, context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((UserGetMemberGroupsResult)res.getValue()).value(), null, null));
    }

    @Override
    public PagedFlux<String> getMemberGroupsAsync(String objectId, boolean securityEnabledOnly) {
        return new PagedFlux(() -> this.getMemberGroupsSinglePageAsync(objectId, securityEnabledOnly));
    }

    private PagedFlux<String> getMemberGroupsAsync(String objectId, boolean securityEnabledOnly, Context context) {
        return new PagedFlux(() -> this.getMemberGroupsSinglePageAsync(objectId, securityEnabledOnly, context));
    }

    @Override
    public PagedIterable<String> getMemberGroups(String objectId, boolean securityEnabledOnly) {
        return new PagedIterable(this.getMemberGroupsAsync(objectId, securityEnabledOnly));
    }

    @Override
    public PagedIterable<String> getMemberGroups(String objectId, boolean securityEnabledOnly, Context context) {
        return new PagedIterable(this.getMemberGroupsAsync(objectId, securityEnabledOnly, context));
    }

    private Mono<PagedResponse<UserInner>> listNextSinglePageAsync(String nextLink) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getTenantId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getTenantId() is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.listNext(this.client.getEndpoint(), nextLink, this.client.getApiVersion(), this.client.getTenantId(), (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((UserListResult)res.getValue()).value(), ((UserListResult)res.getValue()).odataNextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<UserInner>> listNextSinglePageAsync(String nextLink, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getTenantId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getTenantId() is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.listNext(this.client.getEndpoint(), nextLink, this.client.getApiVersion(), this.client.getTenantId(), context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((UserListResult)res.getValue()).value(), ((UserListResult)res.getValue()).odataNextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="GraphRbacManagementC")
    private static interface UsersService {
        @Headers(value={"Accept: application/json,text/json", "Content-Type: application/json"})
        @Post(value="/{tenantID}/users")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=GraphErrorException.class)
        public Mono<Response<UserInner>> create(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="tenantID") String var3, @BodyParam(value="application/json") UserCreateParameters var4, Context var5);

        @Headers(value={"Accept: application/json,text/json", "Content-Type: application/json"})
        @Get(value="/{tenantID}/users")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=GraphErrorException.class)
        public Mono<Response<UserListResult>> list(@HostParam(value="$host") String var1, @QueryParam(value="$filter") String var2, @QueryParam(value="$expand") String var3, @QueryParam(value="api-version") String var4, @PathParam(value="tenantID") String var5, Context var6);

        @Headers(value={"Accept: application/json,text/json", "Content-Type: application/json"})
        @Get(value="/{tenantID}/users/{upnOrObjectId}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=GraphErrorException.class)
        public Mono<Response<UserInner>> get(@HostParam(value="$host") String var1, @PathParam(value="upnOrObjectId") String var2, @QueryParam(value="api-version") String var3, @PathParam(value="tenantID") String var4, Context var5);

        @Headers(value={"Accept: application/json;q=0.9", "Content-Type: application/json"})
        @Patch(value="/{tenantID}/users/{upnOrObjectId}")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=GraphErrorException.class)
        public Mono<Response<Void>> update(@HostParam(value="$host") String var1, @PathParam(value="upnOrObjectId") String var2, @QueryParam(value="api-version") String var3, @PathParam(value="tenantID") String var4, @BodyParam(value="application/json") UserUpdateParameters var5, Context var6);

        @Headers(value={"Accept: application/json;q=0.9", "Content-Type: application/json"})
        @Delete(value="/{tenantID}/users/{upnOrObjectId}")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=GraphErrorException.class)
        public Mono<Response<Void>> delete(@HostParam(value="$host") String var1, @PathParam(value="upnOrObjectId") String var2, @QueryParam(value="api-version") String var3, @PathParam(value="tenantID") String var4, Context var5);

        @Headers(value={"Accept: application/json,text/json", "Content-Type: application/json"})
        @Post(value="/{tenantID}/users/{objectId}/getMemberGroups")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=GraphErrorException.class)
        public Mono<Response<UserGetMemberGroupsResult>> getMemberGroups(@HostParam(value="$host") String var1, @PathParam(value="objectId") String var2, @QueryParam(value="api-version") String var3, @PathParam(value="tenantID") String var4, @BodyParam(value="application/json") UserGetMemberGroupsParameters var5, Context var6);

        @Headers(value={"Accept: application/json,text/json", "Content-Type: application/json"})
        @Get(value="/{tenantID}/{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=GraphErrorException.class)
        public Mono<Response<UserListResult>> listNext(@HostParam(value="$host") String var1, @PathParam(value="nextLink", encoded=true) String var2, @QueryParam(value="api-version") String var3, @PathParam(value="tenantID") String var4, Context var5);
    }
}

