/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.authorization.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.authorization.fluent.models.KeyCredentialInner;
import com.azure.resourcemanager.authorization.fluent.models.PasswordCredentialInner;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public class ServicePrincipalBase {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(ServicePrincipalBase.class);
    @JsonProperty(value="accountEnabled")
    private Boolean accountEnabled;
    @JsonProperty(value="appRoleAssignmentRequired")
    private Boolean appRoleAssignmentRequired;
    @JsonProperty(value="keyCredentials")
    private List<KeyCredentialInner> keyCredentials;
    @JsonProperty(value="passwordCredentials")
    private List<PasswordCredentialInner> passwordCredentials;
    @JsonProperty(value="servicePrincipalType")
    private String servicePrincipalType;
    @JsonProperty(value="tags")
    private List<String> tags;

    public Boolean accountEnabled() {
        return this.accountEnabled;
    }

    public ServicePrincipalBase withAccountEnabled(Boolean accountEnabled) {
        this.accountEnabled = accountEnabled;
        return this;
    }

    public Boolean appRoleAssignmentRequired() {
        return this.appRoleAssignmentRequired;
    }

    public ServicePrincipalBase withAppRoleAssignmentRequired(Boolean appRoleAssignmentRequired) {
        this.appRoleAssignmentRequired = appRoleAssignmentRequired;
        return this;
    }

    public List<KeyCredentialInner> keyCredentials() {
        return this.keyCredentials;
    }

    public ServicePrincipalBase withKeyCredentials(List<KeyCredentialInner> keyCredentials) {
        this.keyCredentials = keyCredentials;
        return this;
    }

    public List<PasswordCredentialInner> passwordCredentials() {
        return this.passwordCredentials;
    }

    public ServicePrincipalBase withPasswordCredentials(List<PasswordCredentialInner> passwordCredentials) {
        this.passwordCredentials = passwordCredentials;
        return this;
    }

    public String servicePrincipalType() {
        return this.servicePrincipalType;
    }

    public ServicePrincipalBase withServicePrincipalType(String servicePrincipalType) {
        this.servicePrincipalType = servicePrincipalType;
        return this;
    }

    public List<String> tags() {
        return this.tags;
    }

    public ServicePrincipalBase withTags(List<String> tags) {
        this.tags = tags;
        return this;
    }

    public void validate() {
        if (this.keyCredentials() != null) {
            this.keyCredentials().forEach(e -> e.validate());
        }
        if (this.passwordCredentials() != null) {
            this.passwordCredentials().forEach(e -> e.validate());
        }
    }
}

