/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.authorization.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.CollectionFormat;
import com.azure.core.util.serializer.JacksonAdapter;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.authorization.fluent.OrganizationOrganizationsClient;
import com.azure.resourcemanager.authorization.fluent.models.CollectionOfOrganization;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphOrganizationInner;
import com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException;
import com.azure.resourcemanager.authorization.fluent.models.OrganizationOrganizationExpand;
import com.azure.resourcemanager.authorization.fluent.models.OrganizationOrganizationOrderby;
import com.azure.resourcemanager.authorization.fluent.models.OrganizationOrganizationSelect;
import com.azure.resourcemanager.authorization.implementation.MicrosoftGraphClientImpl;
import java.util.List;
import reactor.core.publisher.Mono;

public final class OrganizationOrganizationsClientImpl
implements OrganizationOrganizationsClient {
    private final ClientLogger logger = new ClientLogger(OrganizationOrganizationsClientImpl.class);
    private final OrganizationOrganizationsService service;
    private final MicrosoftGraphClientImpl client;

    OrganizationOrganizationsClientImpl(MicrosoftGraphClientImpl client) {
        this.service = (OrganizationOrganizationsService)RestProxy.create(OrganizationOrganizationsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphOrganizationInner>> listOrganizationSinglePageAsync(Integer top, Integer skip, String search, String filter, Boolean count, List<OrganizationOrganizationOrderby> orderby, List<OrganizationOrganizationSelect> select, List<OrganizationOrganizationExpand> expand) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        String orderbyConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        String selectConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        return FluxUtil.withContext(context -> this.service.listOrganization(this.client.getEndpoint(), top, skip, search, filter, count, orderbyConverted, selectConverted, expandConverted, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfOrganization)res.getValue()).value(), ((CollectionOfOrganization)res.getValue()).odataNextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphOrganizationInner>> listOrganizationSinglePageAsync(Integer top, Integer skip, String search, String filter, Boolean count, List<OrganizationOrganizationOrderby> orderby, List<OrganizationOrganizationSelect> select, List<OrganizationOrganizationExpand> expand, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        String orderbyConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        String selectConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        context = this.client.mergeContext(context);
        return this.service.listOrganization(this.client.getEndpoint(), top, skip, search, filter, count, orderbyConverted, selectConverted, expandConverted, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfOrganization)res.getValue()).value(), ((CollectionOfOrganization)res.getValue()).odataNextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<MicrosoftGraphOrganizationInner> listOrganizationAsync(Integer top, Integer skip, String search, String filter, Boolean count, List<OrganizationOrganizationOrderby> orderby, List<OrganizationOrganizationSelect> select, List<OrganizationOrganizationExpand> expand) {
        return new PagedFlux(() -> this.listOrganizationSinglePageAsync(top, skip, search, filter, count, orderby, select, expand), nextLink -> this.listMoreSinglePageAsync((String)nextLink));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<MicrosoftGraphOrganizationInner> listOrganizationAsync() {
        Integer top = null;
        Integer skip = null;
        String search = null;
        String filter = null;
        Boolean count = null;
        List orderby = null;
        List select = null;
        List expand = null;
        return new PagedFlux(() -> this.listOrganizationSinglePageAsync(top, skip, search, filter, count, orderby, select, expand), nextLink -> this.listMoreSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<MicrosoftGraphOrganizationInner> listOrganizationAsync(Integer top, Integer skip, String search, String filter, Boolean count, List<OrganizationOrganizationOrderby> orderby, List<OrganizationOrganizationSelect> select, List<OrganizationOrganizationExpand> expand, Context context) {
        return new PagedFlux(() -> this.listOrganizationSinglePageAsync(top, skip, search, filter, count, orderby, select, expand, context), nextLink -> this.listMoreSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<MicrosoftGraphOrganizationInner> listOrganization() {
        Integer top = null;
        Integer skip = null;
        String search = null;
        String filter = null;
        Boolean count = null;
        List<OrganizationOrganizationOrderby> orderby = null;
        List<OrganizationOrganizationSelect> select = null;
        List<OrganizationOrganizationExpand> expand = null;
        return new PagedIterable(this.listOrganizationAsync(top, skip, search, filter, count, orderby, select, expand));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<MicrosoftGraphOrganizationInner> listOrganization(Integer top, Integer skip, String search, String filter, Boolean count, List<OrganizationOrganizationOrderby> orderby, List<OrganizationOrganizationSelect> select, List<OrganizationOrganizationExpand> expand, Context context) {
        return new PagedIterable(this.listOrganizationAsync(top, skip, search, filter, count, orderby, select, expand, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<MicrosoftGraphOrganizationInner>> createOrganizationWithResponseAsync(MicrosoftGraphOrganizationInner body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createOrganization(this.client.getEndpoint(), body, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<MicrosoftGraphOrganizationInner>> createOrganizationWithResponseAsync(MicrosoftGraphOrganizationInner body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.createOrganization(this.client.getEndpoint(), body, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<MicrosoftGraphOrganizationInner> createOrganizationAsync(MicrosoftGraphOrganizationInner body) {
        return this.createOrganizationWithResponseAsync(body).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((MicrosoftGraphOrganizationInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public MicrosoftGraphOrganizationInner createOrganization(MicrosoftGraphOrganizationInner body) {
        return (MicrosoftGraphOrganizationInner)this.createOrganizationAsync(body).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<MicrosoftGraphOrganizationInner> createOrganizationWithResponse(MicrosoftGraphOrganizationInner body, Context context) {
        return (Response)this.createOrganizationWithResponseAsync(body, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<MicrosoftGraphOrganizationInner>> getOrganizationWithResponseAsync(String organizationId, List<OrganizationOrganizationSelect> select, List<OrganizationOrganizationExpand> expand) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (organizationId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter organizationId is required and cannot be null."));
        }
        String accept = "application/json";
        String selectConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        return FluxUtil.withContext(context -> this.service.getOrganization(this.client.getEndpoint(), organizationId, selectConverted, expandConverted, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<MicrosoftGraphOrganizationInner>> getOrganizationWithResponseAsync(String organizationId, List<OrganizationOrganizationSelect> select, List<OrganizationOrganizationExpand> expand, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (organizationId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter organizationId is required and cannot be null."));
        }
        String accept = "application/json";
        String selectConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        context = this.client.mergeContext(context);
        return this.service.getOrganization(this.client.getEndpoint(), organizationId, selectConverted, expandConverted, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<MicrosoftGraphOrganizationInner> getOrganizationAsync(String organizationId, List<OrganizationOrganizationSelect> select, List<OrganizationOrganizationExpand> expand) {
        return this.getOrganizationWithResponseAsync(organizationId, select, expand).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((MicrosoftGraphOrganizationInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<MicrosoftGraphOrganizationInner> getOrganizationAsync(String organizationId) {
        List<OrganizationOrganizationSelect> select = null;
        List<OrganizationOrganizationExpand> expand = null;
        return this.getOrganizationWithResponseAsync(organizationId, select, expand).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((MicrosoftGraphOrganizationInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public MicrosoftGraphOrganizationInner getOrganization(String organizationId) {
        List<OrganizationOrganizationSelect> select = null;
        List<OrganizationOrganizationExpand> expand = null;
        return (MicrosoftGraphOrganizationInner)this.getOrganizationAsync(organizationId, select, expand).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<MicrosoftGraphOrganizationInner> getOrganizationWithResponse(String organizationId, List<OrganizationOrganizationSelect> select, List<OrganizationOrganizationExpand> expand, Context context) {
        return (Response)this.getOrganizationWithResponseAsync(organizationId, select, expand, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> updateOrganizationWithResponseAsync(String organizationId, MicrosoftGraphOrganizationInner body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (organizationId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter organizationId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.updateOrganization(this.client.getEndpoint(), organizationId, body, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> updateOrganizationWithResponseAsync(String organizationId, MicrosoftGraphOrganizationInner body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (organizationId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter organizationId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.updateOrganization(this.client.getEndpoint(), organizationId, body, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> updateOrganizationAsync(String organizationId, MicrosoftGraphOrganizationInner body) {
        return this.updateOrganizationWithResponseAsync(organizationId, body).flatMap(res -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void updateOrganization(String organizationId, MicrosoftGraphOrganizationInner body) {
        this.updateOrganizationAsync(organizationId, body).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> updateOrganizationWithResponse(String organizationId, MicrosoftGraphOrganizationInner body, Context context) {
        return (Response)this.updateOrganizationWithResponseAsync(organizationId, body, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteOrganizationWithResponseAsync(String organizationId, String ifMatch) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (organizationId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter organizationId is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.deleteOrganization(this.client.getEndpoint(), organizationId, ifMatch, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> deleteOrganizationWithResponseAsync(String organizationId, String ifMatch, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (organizationId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter organizationId is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.deleteOrganization(this.client.getEndpoint(), organizationId, ifMatch, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteOrganizationAsync(String organizationId, String ifMatch) {
        return this.deleteOrganizationWithResponseAsync(organizationId, ifMatch).flatMap(res -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteOrganizationAsync(String organizationId) {
        String ifMatch = null;
        return this.deleteOrganizationWithResponseAsync(organizationId, ifMatch).flatMap(res -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deleteOrganization(String organizationId) {
        String ifMatch = null;
        this.deleteOrganizationAsync(organizationId, ifMatch).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteOrganizationWithResponse(String organizationId, String ifMatch, Context context) {
        return (Response)this.deleteOrganizationWithResponseAsync(organizationId, ifMatch, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphOrganizationInner>> listMoreSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.listMore(nextLink, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfOrganization)res.getValue()).value(), ((CollectionOfOrganization)res.getValue()).odataNextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphOrganizationInner>> listMoreSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.listMore(nextLink, context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfOrganization)res.getValue()).value(), ((CollectionOfOrganization)res.getValue()).odataNextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="MicrosoftGraphClient")
    private static interface OrganizationOrganizationsService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/organization")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<CollectionOfOrganization>> listOrganization(@HostParam(value="$host") String var1, @QueryParam(value="$top") Integer var2, @QueryParam(value="$skip") Integer var3, @QueryParam(value="$search") String var4, @QueryParam(value="$filter") String var5, @QueryParam(value="$count") Boolean var6, @QueryParam(value="$orderby") String var7, @QueryParam(value="$select") String var8, @QueryParam(value="$expand") String var9, @HeaderParam(value="Accept") String var10, Context var11);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/organization")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<MicrosoftGraphOrganizationInner>> createOrganization(@HostParam(value="$host") String var1, @BodyParam(value="application/json") MicrosoftGraphOrganizationInner var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/organization/{organization-id}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<MicrosoftGraphOrganizationInner>> getOrganization(@HostParam(value="$host") String var1, @PathParam(value="organization-id") String var2, @QueryParam(value="$select") String var3, @QueryParam(value="$expand") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Patch(value="/organization/{organization-id}")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<Void>> updateOrganization(@HostParam(value="$host") String var1, @PathParam(value="organization-id") String var2, @BodyParam(value="application/json") MicrosoftGraphOrganizationInner var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/organization/{organization-id}")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<Void>> deleteOrganization(@HostParam(value="$host") String var1, @PathParam(value="organization-id") String var2, @HeaderParam(value="If-Match") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<CollectionOfOrganization>> listMore(@PathParam(value="nextLink", encoded=true) String var1, Context var2);
    }
}

