/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.authorization.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.authorization.fluent.GroupLifecyclePoliciesClient;
import com.azure.resourcemanager.authorization.fluent.models.GroupLifecyclePoliciesAddGroupRequestBody;
import com.azure.resourcemanager.authorization.fluent.models.GroupLifecyclePoliciesRemoveGroupRequestBody;
import com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException;
import com.azure.resourcemanager.authorization.implementation.MicrosoftGraphClientImpl;
import reactor.core.publisher.Mono;

public final class GroupLifecyclePoliciesClientImpl
implements GroupLifecyclePoliciesClient {
    private final ClientLogger logger = new ClientLogger(GroupLifecyclePoliciesClientImpl.class);
    private final GroupLifecyclePoliciesService service;
    private final MicrosoftGraphClientImpl client;

    GroupLifecyclePoliciesClientImpl(MicrosoftGraphClientImpl client) {
        this.service = (GroupLifecyclePoliciesService)RestProxy.create(GroupLifecyclePoliciesService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Boolean>> addGroupWithResponseAsync(String groupLifecyclePolicyId, GroupLifecyclePoliciesAddGroupRequestBody body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupLifecyclePolicyId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter groupLifecyclePolicyId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.addGroup(this.client.getEndpoint(), groupLifecyclePolicyId, body, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Boolean>> addGroupWithResponseAsync(String groupLifecyclePolicyId, GroupLifecyclePoliciesAddGroupRequestBody body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupLifecyclePolicyId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter groupLifecyclePolicyId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.addGroup(this.client.getEndpoint(), groupLifecyclePolicyId, body, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Boolean> addGroupAsync(String groupLifecyclePolicyId, GroupLifecyclePoliciesAddGroupRequestBody body) {
        return this.addGroupWithResponseAsync(groupLifecyclePolicyId, body).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Boolean)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public boolean addGroup(String groupLifecyclePolicyId, GroupLifecyclePoliciesAddGroupRequestBody body) {
        Boolean value = (Boolean)this.addGroupAsync(groupLifecyclePolicyId, body).block();
        if (value != null) {
            return value;
        }
        throw this.logger.logExceptionAsError((RuntimeException)new NullPointerException());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Boolean> addGroupWithResponse(String groupLifecyclePolicyId, GroupLifecyclePoliciesAddGroupRequestBody body, Context context) {
        return (Response)this.addGroupWithResponseAsync(groupLifecyclePolicyId, body, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Boolean>> removeGroupWithResponseAsync(String groupLifecyclePolicyId, GroupLifecyclePoliciesRemoveGroupRequestBody body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupLifecyclePolicyId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter groupLifecyclePolicyId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.removeGroup(this.client.getEndpoint(), groupLifecyclePolicyId, body, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Boolean>> removeGroupWithResponseAsync(String groupLifecyclePolicyId, GroupLifecyclePoliciesRemoveGroupRequestBody body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupLifecyclePolicyId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter groupLifecyclePolicyId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.removeGroup(this.client.getEndpoint(), groupLifecyclePolicyId, body, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Boolean> removeGroupAsync(String groupLifecyclePolicyId, GroupLifecyclePoliciesRemoveGroupRequestBody body) {
        return this.removeGroupWithResponseAsync(groupLifecyclePolicyId, body).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Boolean)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public boolean removeGroup(String groupLifecyclePolicyId, GroupLifecyclePoliciesRemoveGroupRequestBody body) {
        Boolean value = (Boolean)this.removeGroupAsync(groupLifecyclePolicyId, body).block();
        if (value != null) {
            return value;
        }
        throw this.logger.logExceptionAsError((RuntimeException)new NullPointerException());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Boolean> removeGroupWithResponse(String groupLifecyclePolicyId, GroupLifecyclePoliciesRemoveGroupRequestBody body, Context context) {
        return (Response)this.removeGroupWithResponseAsync(groupLifecyclePolicyId, body, context).block();
    }

    @Host(value="{$host}")
    @ServiceInterface(name="MicrosoftGraphClient")
    private static interface GroupLifecyclePoliciesService {
        @Headers(value={"Content-Type: application/json"})
        @Post(value="/groupLifecyclePolicies/{groupLifecyclePolicy-id}/microsoft.graph.addGroup")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<Boolean>> addGroup(@HostParam(value="$host") String var1, @PathParam(value="groupLifecyclePolicy-id") String var2, @BodyParam(value="application/json") GroupLifecyclePoliciesAddGroupRequestBody var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/groupLifecyclePolicies/{groupLifecyclePolicy-id}/microsoft.graph.removeGroup")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<Boolean>> removeGroup(@HostParam(value="$host") String var1, @PathParam(value="groupLifecyclePolicy-id") String var2, @BodyParam(value="application/json") GroupLifecyclePoliciesRemoveGroupRequestBody var3, @HeaderParam(value="Accept") String var4, Context var5);
    }
}

