/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.authorization.implementation;

import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.authorization.fluent.RoleAssignmentMetricsClient;
import com.azure.resourcemanager.authorization.fluent.models.RoleAssignmentMetricsResultInner;
import com.azure.resourcemanager.authorization.implementation.AuthorizationManagementClientImpl;
import reactor.core.publisher.Mono;

public final class RoleAssignmentMetricsClientImpl
implements RoleAssignmentMetricsClient {
    private final ClientLogger logger = new ClientLogger(RoleAssignmentMetricsClientImpl.class);
    private final RoleAssignmentMetricsService service;
    private final AuthorizationManagementClientImpl client;

    RoleAssignmentMetricsClientImpl(AuthorizationManagementClientImpl client) {
        this.service = (RoleAssignmentMetricsService)RestProxy.create(RoleAssignmentMetricsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<RoleAssignmentMetricsResultInner>> getMetricsForSubscriptionWithResponseAsync() {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2019-08-01-preview";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getMetricsForSubscription(this.client.getEndpoint(), this.client.getSubscriptionId(), "2019-08-01-preview", "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<RoleAssignmentMetricsResultInner>> getMetricsForSubscriptionWithResponseAsync(Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2019-08-01-preview";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getMetricsForSubscription(this.client.getEndpoint(), this.client.getSubscriptionId(), "2019-08-01-preview", "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<RoleAssignmentMetricsResultInner> getMetricsForSubscriptionAsync() {
        return this.getMetricsForSubscriptionWithResponseAsync().flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((RoleAssignmentMetricsResultInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public RoleAssignmentMetricsResultInner getMetricsForSubscription() {
        return (RoleAssignmentMetricsResultInner)this.getMetricsForSubscriptionAsync().block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<RoleAssignmentMetricsResultInner> getMetricsForSubscriptionWithResponse(Context context) {
        return (Response)this.getMetricsForSubscriptionWithResponseAsync(context).block();
    }

    @Host(value="{$host}")
    @ServiceInterface(name="AuthorizationManagem")
    private static interface RoleAssignmentMetricsService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/providers/Microsoft.Authorization/roleAssignmentsUsageMetrics")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<RoleAssignmentMetricsResultInner>> getMetricsForSubscription(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="Accept") String var4, Context var5);
    }
}

