/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.authorization.implementation;

import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.authorization.fluent.EligibleChildResourcesClient;
import com.azure.resourcemanager.authorization.fluent.models.EligibleChildResourceInner;
import com.azure.resourcemanager.authorization.implementation.AuthorizationManagementClientImpl;
import com.azure.resourcemanager.authorization.models.EligibleChildResourcesListResult;
import reactor.core.publisher.Mono;

public final class EligibleChildResourcesClientImpl
implements EligibleChildResourcesClient {
    private final EligibleChildResourcesService service;
    private final AuthorizationManagementClientImpl client;

    EligibleChildResourcesClientImpl(AuthorizationManagementClientImpl client) {
        this.service = (EligibleChildResourcesService)RestProxy.create(EligibleChildResourcesService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<EligibleChildResourceInner>> getSinglePageAsync(String scope, String filter) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (scope == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter scope is required and cannot be null."));
        }
        String apiVersion = "2020-10-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), scope, filter, "2020-10-01", "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((EligibleChildResourcesListResult)res.getValue()).value(), ((EligibleChildResourcesListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<EligibleChildResourceInner>> getSinglePageAsync(String scope, String filter, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (scope == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter scope is required and cannot be null."));
        }
        String apiVersion = "2020-10-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), scope, filter, "2020-10-01", "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((EligibleChildResourcesListResult)res.getValue()).value(), ((EligibleChildResourcesListResult)res.getValue()).nextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<EligibleChildResourceInner> getAsync(String scope, String filter) {
        return new PagedFlux(() -> this.getSinglePageAsync(scope, filter), nextLink -> this.getNextSinglePageAsync((String)nextLink));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<EligibleChildResourceInner> getAsync(String scope) {
        String filter = null;
        return new PagedFlux(() -> this.getSinglePageAsync(scope, filter), nextLink -> this.getNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<EligibleChildResourceInner> getAsync(String scope, String filter, Context context) {
        return new PagedFlux(() -> this.getSinglePageAsync(scope, filter, context), nextLink -> this.getNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<EligibleChildResourceInner> get(String scope) {
        String filter = null;
        return new PagedIterable(this.getAsync(scope, filter));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<EligibleChildResourceInner> get(String scope, String filter, Context context) {
        return new PagedIterable(this.getAsync(scope, filter, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<EligibleChildResourceInner>> getNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((EligibleChildResourcesListResult)res.getValue()).value(), ((EligibleChildResourcesListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<EligibleChildResourceInner>> getNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((EligibleChildResourcesListResult)res.getValue()).value(), ((EligibleChildResourcesListResult)res.getValue()).nextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="AuthorizationManagem")
    private static interface EligibleChildResourcesService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/{scope}/providers/Microsoft.Authorization/eligibleChildResources")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<EligibleChildResourcesListResult>> get(@HostParam(value="$host") String var1, @PathParam(value="scope", encoded=true) String var2, @QueryParam(value="$filter") String var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<EligibleChildResourcesListResult>> getNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

