// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.Base64Url;
import com.azure.core.util.CoreUtils;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

/**
 * application Represents an Azure Active Directory object. The directoryObject type is the base type for many other
 * directory entity types.
 */
@Fluent
public final class MicrosoftGraphApplicationInner extends MicrosoftGraphDirectoryObjectInner {
    /*
     * Defines custom behavior that a consuming service can use to call an app
     * in specific contexts. For example, applications that can render file
     * streams may set the addIns property for its 'FileHandler' functionality.
     * This will let services like Microsoft 365 call the application in the
     * context of a document the user is working on.
     */
    @JsonProperty(value = "addIns")
    private List<MicrosoftGraphAddIn> addIns;

    /*
     * apiApplication
     */
    @JsonProperty(value = "api")
    private MicrosoftGraphApiApplication api;

    /*
     * The unique identifier for the application that is assigned to an
     * application by Azure AD. Not nullable. Read-only.
     */
    @JsonProperty(value = "appId")
    private String appId;

    /*
     * The applicationTemplateId property.
     */
    @JsonProperty(value = "applicationTemplateId")
    private String applicationTemplateId;

    /*
     * The collection of roles the application declares. With app role
     * assignments, these roles can be assigned to users, groups, or other
     * applications' service principals. Not nullable.
     */
    @JsonProperty(value = "appRoles")
    private List<MicrosoftGraphAppRole> appRoles;

    /*
     * The date and time the application was registered. Read-only.
     */
    @JsonProperty(value = "createdDateTime")
    private OffsetDateTime createdDateTime;

    /*
     * The description property.
     */
    @JsonProperty(value = "description")
    private String description;

    /*
     * The display name for the application.
     */
    @JsonProperty(value = "displayName")
    private String displayName;

    /*
     * Configures the groups claim issued in a user or OAuth 2.0 access token
     * that the application expects. To set this attribute, use one of the
     * following valid string values:NoneSecurityGroup: For security groups and
     * Azure AD rolesAll: This will get all of the security groups,
     * distribution groups, and Azure AD directory roles that the signed-in
     * user is a member of
     */
    @JsonProperty(value = "groupMembershipClaims")
    private String groupMembershipClaims;

    /*
     * The URIs that identify the application within its Azure AD tenant, or
     * within a verified custom domain if the application is multi-tenant. For
     * more information see Application Objects and Service Principal Objects.
     * The any operator is required for filter expressions on multi-valued
     * properties. Not nullable.
     */
    @JsonProperty(value = "identifierUris")
    private List<String> identifierUris;

    /*
     * informationalUrl
     */
    @JsonProperty(value = "info")
    private MicrosoftGraphInformationalUrl info;

    /*
     * The isDeviceOnlyAuthSupported property.
     */
    @JsonProperty(value = "isDeviceOnlyAuthSupported")
    private Boolean isDeviceOnlyAuthSupported;

    /*
     * Specifies the fallback application type as public client, such as an
     * installed application running on a mobile device. The default value is
     * false which means the fallback application type is confidential client
     * such as web app. There are certain scenarios where Azure AD cannot
     * determine the client application type (e.g. ROPC flow where it is
     * configured without specifying a redirect URI). In those cases Azure AD
     * will interpret the application type based on the value of this property.
     */
    @JsonProperty(value = "isFallbackPublicClient")
    private Boolean isFallbackPublicClient;

    /*
     * The collection of key credentials associated with the application Not
     * nullable.
     */
    @JsonProperty(value = "keyCredentials")
    private List<MicrosoftGraphKeyCredentialInner> keyCredentials;

    /*
     * The main logo for the application. Not nullable.
     */
    @JsonProperty(value = "logo")
    private Base64Url logo;

    /*
     * The notes property.
     */
    @JsonProperty(value = "notes")
    private String notes;

    /*
     * The oauth2RequirePostResponse property.
     */
    @JsonProperty(value = "oauth2RequirePostResponse")
    private Boolean oauth2RequirePostResponse;

    /*
     * optionalClaims
     */
    @JsonProperty(value = "optionalClaims")
    private MicrosoftGraphOptionalClaims optionalClaims;

    /*
     * parentalControlSettings
     */
    @JsonProperty(value = "parentalControlSettings")
    private MicrosoftGraphParentalControlSettings parentalControlSettings;

    /*
     * The collection of password credentials associated with the application.
     * Not nullable.
     */
    @JsonProperty(value = "passwordCredentials")
    private List<MicrosoftGraphPasswordCredentialInner> passwordCredentials;

    /*
     * publicClientApplication
     */
    @JsonProperty(value = "publicClient")
    private MicrosoftGraphPublicClientApplication publicClient;

    /*
     * The verified publisher domain for the application. Read-only.
     */
    @JsonProperty(value = "publisherDomain")
    private String publisherDomain;

    /*
     * Specifies resources that this application requires access to and the set
     * of OAuth permission scopes and application roles that it needs under
     * each of those resources. This pre-configuration of required resource
     * access drives the consent experience. Not nullable.
     */
    @JsonProperty(value = "requiredResourceAccess")
    private List<MicrosoftGraphRequiredResourceAccess> requiredResourceAccess;

    /*
     * Specifies the Microsoft accounts that are supported for the current
     * application. Supported values are:AzureADMyOrg: Users with a Microsoft
     * work or school account in my organization’s Azure AD tenant (single
     * tenant)AzureADMultipleOrgs: Users with a Microsoft work or school
     * account in any organization’s Azure AD tenant
     * (multi-tenant).AzureADandPersonalMicrosoftAccount: Users with a personal
     * Microsoft account, or a work or school account in any organization’s
     * Azure AD tenant.PersonalMicrosoftAccount: Users with a personal
     * Microsoft account only.For authenticating users with Azure AD B2C user
     * flows, use AzureADandPersonalMicrosoftAccount. This value allows for the
     * widest set of user identities including local accounts and user
     * identities from Microsoft, Facebook, Google, Twitter, or any OpenID
     * Connect provider.
     */
    @JsonProperty(value = "signInAudience")
    private String signInAudience;

    /*
     * Custom strings that can be used to categorize and identify the
     * application. Not nullable.
     */
    @JsonProperty(value = "tags")
    private List<String> tags;

    /*
     * Specifies the keyId of a public key from the keyCredentials collection.
     * When configured, Azure AD encrypts all the tokens it emits by using the
     * key this property points to. The application code that receives the
     * encrypted token must use the matching private key to decrypt the token
     * before it can be used for the signed-in user.
     */
    @JsonProperty(value = "tokenEncryptionKeyId")
    private UUID tokenEncryptionKeyId;

    /*
     * webApplication
     */
    @JsonProperty(value = "web")
    private MicrosoftGraphWebApplication web;

    /*
     * directoryObject Represents an Azure Active Directory object. The
     * directoryObject type is the base type for many other directory entity
     * types.
     */
    @JsonProperty(value = "createdOnBehalfOf")
    private MicrosoftGraphDirectoryObjectInner createdOnBehalfOf;

    /*
     * Read-only. Nullable.
     */
    @JsonProperty(value = "extensionProperties")
    private List<MicrosoftGraphExtensionPropertyInner> extensionProperties;

    /*
     * The homeRealmDiscoveryPolicies property.
     */
    @JsonProperty(value = "homeRealmDiscoveryPolicies")
    private List<MicrosoftGraphHomeRealmDiscoveryPolicyInner> homeRealmDiscoveryPolicies;

    /*
     * Directory objects that are owners of the application. The owners are a
     * set of non-admin users who are allowed to modify this object. Requires
     * version 2013-11-08 or newer. Read-only. Nullable.
     */
    @JsonProperty(value = "owners")
    private List<MicrosoftGraphDirectoryObjectInner> owners;

    /*
     * The tokenIssuancePolicies property.
     */
    @JsonProperty(value = "tokenIssuancePolicies")
    private List<MicrosoftGraphTokenIssuancePolicy> tokenIssuancePolicies;

    /*
     * The tokenLifetimePolicies property.
     */
    @JsonProperty(value = "tokenLifetimePolicies")
    private List<MicrosoftGraphTokenLifetimePolicy> tokenLifetimePolicies;

    /*
     * Represents an Azure Active Directory object. The directoryObject type is
     * the base type for many other directory entity types.
     */
    @JsonIgnore private Map<String, Object> additionalProperties;

    /**
     * Get the addIns property: Defines custom behavior that a consuming service can use to call an app in specific
     * contexts. For example, applications that can render file streams may set the addIns property for its
     * 'FileHandler' functionality. This will let services like Microsoft 365 call the application in the context of a
     * document the user is working on.
     *
     * @return the addIns value.
     */
    public List<MicrosoftGraphAddIn> addIns() {
        return this.addIns;
    }

    /**
     * Set the addIns property: Defines custom behavior that a consuming service can use to call an app in specific
     * contexts. For example, applications that can render file streams may set the addIns property for its
     * 'FileHandler' functionality. This will let services like Microsoft 365 call the application in the context of a
     * document the user is working on.
     *
     * @param addIns the addIns value to set.
     * @return the MicrosoftGraphApplicationInner object itself.
     */
    public MicrosoftGraphApplicationInner withAddIns(List<MicrosoftGraphAddIn> addIns) {
        this.addIns = addIns;
        return this;
    }

    /**
     * Get the api property: apiApplication.
     *
     * @return the api value.
     */
    public MicrosoftGraphApiApplication api() {
        return this.api;
    }

    /**
     * Set the api property: apiApplication.
     *
     * @param api the api value to set.
     * @return the MicrosoftGraphApplicationInner object itself.
     */
    public MicrosoftGraphApplicationInner withApi(MicrosoftGraphApiApplication api) {
        this.api = api;
        return this;
    }

    /**
     * Get the appId property: The unique identifier for the application that is assigned to an application by Azure AD.
     * Not nullable. Read-only.
     *
     * @return the appId value.
     */
    public String appId() {
        return this.appId;
    }

    /**
     * Set the appId property: The unique identifier for the application that is assigned to an application by Azure AD.
     * Not nullable. Read-only.
     *
     * @param appId the appId value to set.
     * @return the MicrosoftGraphApplicationInner object itself.
     */
    public MicrosoftGraphApplicationInner withAppId(String appId) {
        this.appId = appId;
        return this;
    }

    /**
     * Get the applicationTemplateId property: The applicationTemplateId property.
     *
     * @return the applicationTemplateId value.
     */
    public String applicationTemplateId() {
        return this.applicationTemplateId;
    }

    /**
     * Set the applicationTemplateId property: The applicationTemplateId property.
     *
     * @param applicationTemplateId the applicationTemplateId value to set.
     * @return the MicrosoftGraphApplicationInner object itself.
     */
    public MicrosoftGraphApplicationInner withApplicationTemplateId(String applicationTemplateId) {
        this.applicationTemplateId = applicationTemplateId;
        return this;
    }

    /**
     * Get the appRoles property: The collection of roles the application declares. With app role assignments, these
     * roles can be assigned to users, groups, or other applications' service principals. Not nullable.
     *
     * @return the appRoles value.
     */
    public List<MicrosoftGraphAppRole> appRoles() {
        return this.appRoles;
    }

    /**
     * Set the appRoles property: The collection of roles the application declares. With app role assignments, these
     * roles can be assigned to users, groups, or other applications' service principals. Not nullable.
     *
     * @param appRoles the appRoles value to set.
     * @return the MicrosoftGraphApplicationInner object itself.
     */
    public MicrosoftGraphApplicationInner withAppRoles(List<MicrosoftGraphAppRole> appRoles) {
        this.appRoles = appRoles;
        return this;
    }

    /**
     * Get the createdDateTime property: The date and time the application was registered. Read-only.
     *
     * @return the createdDateTime value.
     */
    public OffsetDateTime createdDateTime() {
        return this.createdDateTime;
    }

    /**
     * Set the createdDateTime property: The date and time the application was registered. Read-only.
     *
     * @param createdDateTime the createdDateTime value to set.
     * @return the MicrosoftGraphApplicationInner object itself.
     */
    public MicrosoftGraphApplicationInner withCreatedDateTime(OffsetDateTime createdDateTime) {
        this.createdDateTime = createdDateTime;
        return this;
    }

    /**
     * Get the description property: The description property.
     *
     * @return the description value.
     */
    public String description() {
        return this.description;
    }

    /**
     * Set the description property: The description property.
     *
     * @param description the description value to set.
     * @return the MicrosoftGraphApplicationInner object itself.
     */
    public MicrosoftGraphApplicationInner withDescription(String description) {
        this.description = description;
        return this;
    }

    /**
     * Get the displayName property: The display name for the application.
     *
     * @return the displayName value.
     */
    public String displayName() {
        return this.displayName;
    }

    /**
     * Set the displayName property: The display name for the application.
     *
     * @param displayName the displayName value to set.
     * @return the MicrosoftGraphApplicationInner object itself.
     */
    public MicrosoftGraphApplicationInner withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    /**
     * Get the groupMembershipClaims property: Configures the groups claim issued in a user or OAuth 2.0 access token
     * that the application expects. To set this attribute, use one of the following valid string
     * values:NoneSecurityGroup: For security groups and Azure AD rolesAll: This will get all of the security groups,
     * distribution groups, and Azure AD directory roles that the signed-in user is a member of.
     *
     * @return the groupMembershipClaims value.
     */
    public String groupMembershipClaims() {
        return this.groupMembershipClaims;
    }

    /**
     * Set the groupMembershipClaims property: Configures the groups claim issued in a user or OAuth 2.0 access token
     * that the application expects. To set this attribute, use one of the following valid string
     * values:NoneSecurityGroup: For security groups and Azure AD rolesAll: This will get all of the security groups,
     * distribution groups, and Azure AD directory roles that the signed-in user is a member of.
     *
     * @param groupMembershipClaims the groupMembershipClaims value to set.
     * @return the MicrosoftGraphApplicationInner object itself.
     */
    public MicrosoftGraphApplicationInner withGroupMembershipClaims(String groupMembershipClaims) {
        this.groupMembershipClaims = groupMembershipClaims;
        return this;
    }

    /**
     * Get the identifierUris property: The URIs that identify the application within its Azure AD tenant, or within a
     * verified custom domain if the application is multi-tenant. For more information see Application Objects and
     * Service Principal Objects. The any operator is required for filter expressions on multi-valued properties. Not
     * nullable.
     *
     * @return the identifierUris value.
     */
    public List<String> identifierUris() {
        return this.identifierUris;
    }

    /**
     * Set the identifierUris property: The URIs that identify the application within its Azure AD tenant, or within a
     * verified custom domain if the application is multi-tenant. For more information see Application Objects and
     * Service Principal Objects. The any operator is required for filter expressions on multi-valued properties. Not
     * nullable.
     *
     * @param identifierUris the identifierUris value to set.
     * @return the MicrosoftGraphApplicationInner object itself.
     */
    public MicrosoftGraphApplicationInner withIdentifierUris(List<String> identifierUris) {
        this.identifierUris = identifierUris;
        return this;
    }

    /**
     * Get the info property: informationalUrl.
     *
     * @return the info value.
     */
    public MicrosoftGraphInformationalUrl info() {
        return this.info;
    }

    /**
     * Set the info property: informationalUrl.
     *
     * @param info the info value to set.
     * @return the MicrosoftGraphApplicationInner object itself.
     */
    public MicrosoftGraphApplicationInner withInfo(MicrosoftGraphInformationalUrl info) {
        this.info = info;
        return this;
    }

    /**
     * Get the isDeviceOnlyAuthSupported property: The isDeviceOnlyAuthSupported property.
     *
     * @return the isDeviceOnlyAuthSupported value.
     */
    public Boolean isDeviceOnlyAuthSupported() {
        return this.isDeviceOnlyAuthSupported;
    }

    /**
     * Set the isDeviceOnlyAuthSupported property: The isDeviceOnlyAuthSupported property.
     *
     * @param isDeviceOnlyAuthSupported the isDeviceOnlyAuthSupported value to set.
     * @return the MicrosoftGraphApplicationInner object itself.
     */
    public MicrosoftGraphApplicationInner withIsDeviceOnlyAuthSupported(Boolean isDeviceOnlyAuthSupported) {
        this.isDeviceOnlyAuthSupported = isDeviceOnlyAuthSupported;
        return this;
    }

    /**
     * Get the isFallbackPublicClient property: Specifies the fallback application type as public client, such as an
     * installed application running on a mobile device. The default value is false which means the fallback application
     * type is confidential client such as web app. There are certain scenarios where Azure AD cannot determine the
     * client application type (e.g. ROPC flow where it is configured without specifying a redirect URI). In those cases
     * Azure AD will interpret the application type based on the value of this property.
     *
     * @return the isFallbackPublicClient value.
     */
    public Boolean isFallbackPublicClient() {
        return this.isFallbackPublicClient;
    }

    /**
     * Set the isFallbackPublicClient property: Specifies the fallback application type as public client, such as an
     * installed application running on a mobile device. The default value is false which means the fallback application
     * type is confidential client such as web app. There are certain scenarios where Azure AD cannot determine the
     * client application type (e.g. ROPC flow where it is configured without specifying a redirect URI). In those cases
     * Azure AD will interpret the application type based on the value of this property.
     *
     * @param isFallbackPublicClient the isFallbackPublicClient value to set.
     * @return the MicrosoftGraphApplicationInner object itself.
     */
    public MicrosoftGraphApplicationInner withIsFallbackPublicClient(Boolean isFallbackPublicClient) {
        this.isFallbackPublicClient = isFallbackPublicClient;
        return this;
    }

    /**
     * Get the keyCredentials property: The collection of key credentials associated with the application Not nullable.
     *
     * @return the keyCredentials value.
     */
    public List<MicrosoftGraphKeyCredentialInner> keyCredentials() {
        return this.keyCredentials;
    }

    /**
     * Set the keyCredentials property: The collection of key credentials associated with the application Not nullable.
     *
     * @param keyCredentials the keyCredentials value to set.
     * @return the MicrosoftGraphApplicationInner object itself.
     */
    public MicrosoftGraphApplicationInner withKeyCredentials(List<MicrosoftGraphKeyCredentialInner> keyCredentials) {
        this.keyCredentials = keyCredentials;
        return this;
    }

    /**
     * Get the logo property: The main logo for the application. Not nullable.
     *
     * @return the logo value.
     */
    public byte[] logo() {
        if (this.logo == null) {
            return new byte[0];
        }
        return this.logo.decodedBytes();
    }

    /**
     * Set the logo property: The main logo for the application. Not nullable.
     *
     * @param logo the logo value to set.
     * @return the MicrosoftGraphApplicationInner object itself.
     */
    public MicrosoftGraphApplicationInner withLogo(byte[] logo) {
        if (logo == null) {
            this.logo = null;
        } else {
            this.logo = Base64Url.encode(CoreUtils.clone(logo));
        }
        return this;
    }

    /**
     * Get the notes property: The notes property.
     *
     * @return the notes value.
     */
    public String notes() {
        return this.notes;
    }

    /**
     * Set the notes property: The notes property.
     *
     * @param notes the notes value to set.
     * @return the MicrosoftGraphApplicationInner object itself.
     */
    public MicrosoftGraphApplicationInner withNotes(String notes) {
        this.notes = notes;
        return this;
    }

    /**
     * Get the oauth2RequirePostResponse property: The oauth2RequirePostResponse property.
     *
     * @return the oauth2RequirePostResponse value.
     */
    public Boolean oauth2RequirePostResponse() {
        return this.oauth2RequirePostResponse;
    }

    /**
     * Set the oauth2RequirePostResponse property: The oauth2RequirePostResponse property.
     *
     * @param oauth2RequirePostResponse the oauth2RequirePostResponse value to set.
     * @return the MicrosoftGraphApplicationInner object itself.
     */
    public MicrosoftGraphApplicationInner withOauth2RequirePostResponse(Boolean oauth2RequirePostResponse) {
        this.oauth2RequirePostResponse = oauth2RequirePostResponse;
        return this;
    }

    /**
     * Get the optionalClaims property: optionalClaims.
     *
     * @return the optionalClaims value.
     */
    public MicrosoftGraphOptionalClaims optionalClaims() {
        return this.optionalClaims;
    }

    /**
     * Set the optionalClaims property: optionalClaims.
     *
     * @param optionalClaims the optionalClaims value to set.
     * @return the MicrosoftGraphApplicationInner object itself.
     */
    public MicrosoftGraphApplicationInner withOptionalClaims(MicrosoftGraphOptionalClaims optionalClaims) {
        this.optionalClaims = optionalClaims;
        return this;
    }

    /**
     * Get the parentalControlSettings property: parentalControlSettings.
     *
     * @return the parentalControlSettings value.
     */
    public MicrosoftGraphParentalControlSettings parentalControlSettings() {
        return this.parentalControlSettings;
    }

    /**
     * Set the parentalControlSettings property: parentalControlSettings.
     *
     * @param parentalControlSettings the parentalControlSettings value to set.
     * @return the MicrosoftGraphApplicationInner object itself.
     */
    public MicrosoftGraphApplicationInner withParentalControlSettings(
        MicrosoftGraphParentalControlSettings parentalControlSettings) {
        this.parentalControlSettings = parentalControlSettings;
        return this;
    }

    /**
     * Get the passwordCredentials property: The collection of password credentials associated with the application. Not
     * nullable.
     *
     * @return the passwordCredentials value.
     */
    public List<MicrosoftGraphPasswordCredentialInner> passwordCredentials() {
        return this.passwordCredentials;
    }

    /**
     * Set the passwordCredentials property: The collection of password credentials associated with the application. Not
     * nullable.
     *
     * @param passwordCredentials the passwordCredentials value to set.
     * @return the MicrosoftGraphApplicationInner object itself.
     */
    public MicrosoftGraphApplicationInner withPasswordCredentials(
        List<MicrosoftGraphPasswordCredentialInner> passwordCredentials) {
        this.passwordCredentials = passwordCredentials;
        return this;
    }

    /**
     * Get the publicClient property: publicClientApplication.
     *
     * @return the publicClient value.
     */
    public MicrosoftGraphPublicClientApplication publicClient() {
        return this.publicClient;
    }

    /**
     * Set the publicClient property: publicClientApplication.
     *
     * @param publicClient the publicClient value to set.
     * @return the MicrosoftGraphApplicationInner object itself.
     */
    public MicrosoftGraphApplicationInner withPublicClient(MicrosoftGraphPublicClientApplication publicClient) {
        this.publicClient = publicClient;
        return this;
    }

    /**
     * Get the publisherDomain property: The verified publisher domain for the application. Read-only.
     *
     * @return the publisherDomain value.
     */
    public String publisherDomain() {
        return this.publisherDomain;
    }

    /**
     * Set the publisherDomain property: The verified publisher domain for the application. Read-only.
     *
     * @param publisherDomain the publisherDomain value to set.
     * @return the MicrosoftGraphApplicationInner object itself.
     */
    public MicrosoftGraphApplicationInner withPublisherDomain(String publisherDomain) {
        this.publisherDomain = publisherDomain;
        return this;
    }

    /**
     * Get the requiredResourceAccess property: Specifies resources that this application requires access to and the set
     * of OAuth permission scopes and application roles that it needs under each of those resources. This
     * pre-configuration of required resource access drives the consent experience. Not nullable.
     *
     * @return the requiredResourceAccess value.
     */
    public List<MicrosoftGraphRequiredResourceAccess> requiredResourceAccess() {
        return this.requiredResourceAccess;
    }

    /**
     * Set the requiredResourceAccess property: Specifies resources that this application requires access to and the set
     * of OAuth permission scopes and application roles that it needs under each of those resources. This
     * pre-configuration of required resource access drives the consent experience. Not nullable.
     *
     * @param requiredResourceAccess the requiredResourceAccess value to set.
     * @return the MicrosoftGraphApplicationInner object itself.
     */
    public MicrosoftGraphApplicationInner withRequiredResourceAccess(
        List<MicrosoftGraphRequiredResourceAccess> requiredResourceAccess) {
        this.requiredResourceAccess = requiredResourceAccess;
        return this;
    }

    /**
     * Get the signInAudience property: Specifies the Microsoft accounts that are supported for the current application.
     * Supported values are:AzureADMyOrg: Users with a Microsoft work or school account in my organization’s Azure AD
     * tenant (single tenant)AzureADMultipleOrgs: Users with a Microsoft work or school account in any organization’s
     * Azure AD tenant (multi-tenant).AzureADandPersonalMicrosoftAccount: Users with a personal Microsoft account, or a
     * work or school account in any organization’s Azure AD tenant.PersonalMicrosoftAccount: Users with a personal
     * Microsoft account only.For authenticating users with Azure AD B2C user flows, use
     * AzureADandPersonalMicrosoftAccount. This value allows for the widest set of user identities including local
     * accounts and user identities from Microsoft, Facebook, Google, Twitter, or any OpenID Connect provider.
     *
     * @return the signInAudience value.
     */
    public String signInAudience() {
        return this.signInAudience;
    }

    /**
     * Set the signInAudience property: Specifies the Microsoft accounts that are supported for the current application.
     * Supported values are:AzureADMyOrg: Users with a Microsoft work or school account in my organization’s Azure AD
     * tenant (single tenant)AzureADMultipleOrgs: Users with a Microsoft work or school account in any organization’s
     * Azure AD tenant (multi-tenant).AzureADandPersonalMicrosoftAccount: Users with a personal Microsoft account, or a
     * work or school account in any organization’s Azure AD tenant.PersonalMicrosoftAccount: Users with a personal
     * Microsoft account only.For authenticating users with Azure AD B2C user flows, use
     * AzureADandPersonalMicrosoftAccount. This value allows for the widest set of user identities including local
     * accounts and user identities from Microsoft, Facebook, Google, Twitter, or any OpenID Connect provider.
     *
     * @param signInAudience the signInAudience value to set.
     * @return the MicrosoftGraphApplicationInner object itself.
     */
    public MicrosoftGraphApplicationInner withSignInAudience(String signInAudience) {
        this.signInAudience = signInAudience;
        return this;
    }

    /**
     * Get the tags property: Custom strings that can be used to categorize and identify the application. Not nullable.
     *
     * @return the tags value.
     */
    public List<String> tags() {
        return this.tags;
    }

    /**
     * Set the tags property: Custom strings that can be used to categorize and identify the application. Not nullable.
     *
     * @param tags the tags value to set.
     * @return the MicrosoftGraphApplicationInner object itself.
     */
    public MicrosoftGraphApplicationInner withTags(List<String> tags) {
        this.tags = tags;
        return this;
    }

    /**
     * Get the tokenEncryptionKeyId property: Specifies the keyId of a public key from the keyCredentials collection.
     * When configured, Azure AD encrypts all the tokens it emits by using the key this property points to. The
     * application code that receives the encrypted token must use the matching private key to decrypt the token before
     * it can be used for the signed-in user.
     *
     * @return the tokenEncryptionKeyId value.
     */
    public UUID tokenEncryptionKeyId() {
        return this.tokenEncryptionKeyId;
    }

    /**
     * Set the tokenEncryptionKeyId property: Specifies the keyId of a public key from the keyCredentials collection.
     * When configured, Azure AD encrypts all the tokens it emits by using the key this property points to. The
     * application code that receives the encrypted token must use the matching private key to decrypt the token before
     * it can be used for the signed-in user.
     *
     * @param tokenEncryptionKeyId the tokenEncryptionKeyId value to set.
     * @return the MicrosoftGraphApplicationInner object itself.
     */
    public MicrosoftGraphApplicationInner withTokenEncryptionKeyId(UUID tokenEncryptionKeyId) {
        this.tokenEncryptionKeyId = tokenEncryptionKeyId;
        return this;
    }

    /**
     * Get the web property: webApplication.
     *
     * @return the web value.
     */
    public MicrosoftGraphWebApplication web() {
        return this.web;
    }

    /**
     * Set the web property: webApplication.
     *
     * @param web the web value to set.
     * @return the MicrosoftGraphApplicationInner object itself.
     */
    public MicrosoftGraphApplicationInner withWeb(MicrosoftGraphWebApplication web) {
        this.web = web;
        return this;
    }

    /**
     * Get the createdOnBehalfOf property: directoryObject Represents an Azure Active Directory object. The
     * directoryObject type is the base type for many other directory entity types.
     *
     * @return the createdOnBehalfOf value.
     */
    public MicrosoftGraphDirectoryObjectInner createdOnBehalfOf() {
        return this.createdOnBehalfOf;
    }

    /**
     * Set the createdOnBehalfOf property: directoryObject Represents an Azure Active Directory object. The
     * directoryObject type is the base type for many other directory entity types.
     *
     * @param createdOnBehalfOf the createdOnBehalfOf value to set.
     * @return the MicrosoftGraphApplicationInner object itself.
     */
    public MicrosoftGraphApplicationInner withCreatedOnBehalfOf(MicrosoftGraphDirectoryObjectInner createdOnBehalfOf) {
        this.createdOnBehalfOf = createdOnBehalfOf;
        return this;
    }

    /**
     * Get the extensionProperties property: Read-only. Nullable.
     *
     * @return the extensionProperties value.
     */
    public List<MicrosoftGraphExtensionPropertyInner> extensionProperties() {
        return this.extensionProperties;
    }

    /**
     * Set the extensionProperties property: Read-only. Nullable.
     *
     * @param extensionProperties the extensionProperties value to set.
     * @return the MicrosoftGraphApplicationInner object itself.
     */
    public MicrosoftGraphApplicationInner withExtensionProperties(
        List<MicrosoftGraphExtensionPropertyInner> extensionProperties) {
        this.extensionProperties = extensionProperties;
        return this;
    }

    /**
     * Get the homeRealmDiscoveryPolicies property: The homeRealmDiscoveryPolicies property.
     *
     * @return the homeRealmDiscoveryPolicies value.
     */
    public List<MicrosoftGraphHomeRealmDiscoveryPolicyInner> homeRealmDiscoveryPolicies() {
        return this.homeRealmDiscoveryPolicies;
    }

    /**
     * Set the homeRealmDiscoveryPolicies property: The homeRealmDiscoveryPolicies property.
     *
     * @param homeRealmDiscoveryPolicies the homeRealmDiscoveryPolicies value to set.
     * @return the MicrosoftGraphApplicationInner object itself.
     */
    public MicrosoftGraphApplicationInner withHomeRealmDiscoveryPolicies(
        List<MicrosoftGraphHomeRealmDiscoveryPolicyInner> homeRealmDiscoveryPolicies) {
        this.homeRealmDiscoveryPolicies = homeRealmDiscoveryPolicies;
        return this;
    }

    /**
     * Get the owners property: Directory objects that are owners of the application. The owners are a set of non-admin
     * users who are allowed to modify this object. Requires version 2013-11-08 or newer. Read-only. Nullable.
     *
     * @return the owners value.
     */
    public List<MicrosoftGraphDirectoryObjectInner> owners() {
        return this.owners;
    }

    /**
     * Set the owners property: Directory objects that are owners of the application. The owners are a set of non-admin
     * users who are allowed to modify this object. Requires version 2013-11-08 or newer. Read-only. Nullable.
     *
     * @param owners the owners value to set.
     * @return the MicrosoftGraphApplicationInner object itself.
     */
    public MicrosoftGraphApplicationInner withOwners(List<MicrosoftGraphDirectoryObjectInner> owners) {
        this.owners = owners;
        return this;
    }

    /**
     * Get the tokenIssuancePolicies property: The tokenIssuancePolicies property.
     *
     * @return the tokenIssuancePolicies value.
     */
    public List<MicrosoftGraphTokenIssuancePolicy> tokenIssuancePolicies() {
        return this.tokenIssuancePolicies;
    }

    /**
     * Set the tokenIssuancePolicies property: The tokenIssuancePolicies property.
     *
     * @param tokenIssuancePolicies the tokenIssuancePolicies value to set.
     * @return the MicrosoftGraphApplicationInner object itself.
     */
    public MicrosoftGraphApplicationInner withTokenIssuancePolicies(
        List<MicrosoftGraphTokenIssuancePolicy> tokenIssuancePolicies) {
        this.tokenIssuancePolicies = tokenIssuancePolicies;
        return this;
    }

    /**
     * Get the tokenLifetimePolicies property: The tokenLifetimePolicies property.
     *
     * @return the tokenLifetimePolicies value.
     */
    public List<MicrosoftGraphTokenLifetimePolicy> tokenLifetimePolicies() {
        return this.tokenLifetimePolicies;
    }

    /**
     * Set the tokenLifetimePolicies property: The tokenLifetimePolicies property.
     *
     * @param tokenLifetimePolicies the tokenLifetimePolicies value to set.
     * @return the MicrosoftGraphApplicationInner object itself.
     */
    public MicrosoftGraphApplicationInner withTokenLifetimePolicies(
        List<MicrosoftGraphTokenLifetimePolicy> tokenLifetimePolicies) {
        this.tokenLifetimePolicies = tokenLifetimePolicies;
        return this;
    }

    /**
     * Get the additionalProperties property: Represents an Azure Active Directory object. The directoryObject type is
     * the base type for many other directory entity types.
     *
     * @return the additionalProperties value.
     */
    @JsonAnyGetter
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: Represents an Azure Active Directory object. The directoryObject type is
     * the base type for many other directory entity types.
     *
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphApplicationInner object itself.
     */
    public MicrosoftGraphApplicationInner withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @JsonAnySetter
    void withAdditionalProperties(String key, Object value) {
        if (additionalProperties == null) {
            additionalProperties = new HashMap<>();
        }
        additionalProperties.put(key, value);
    }

    /** {@inheritDoc} */
    @Override
    public MicrosoftGraphApplicationInner withDeletedDateTime(OffsetDateTime deletedDateTime) {
        super.withDeletedDateTime(deletedDateTime);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public MicrosoftGraphApplicationInner withId(String id) {
        super.withId(id);
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (addIns() != null) {
            addIns().forEach(e -> e.validate());
        }
        if (api() != null) {
            api().validate();
        }
        if (appRoles() != null) {
            appRoles().forEach(e -> e.validate());
        }
        if (info() != null) {
            info().validate();
        }
        if (keyCredentials() != null) {
            keyCredentials().forEach(e -> e.validate());
        }
        if (optionalClaims() != null) {
            optionalClaims().validate();
        }
        if (parentalControlSettings() != null) {
            parentalControlSettings().validate();
        }
        if (passwordCredentials() != null) {
            passwordCredentials().forEach(e -> e.validate());
        }
        if (publicClient() != null) {
            publicClient().validate();
        }
        if (requiredResourceAccess() != null) {
            requiredResourceAccess().forEach(e -> e.validate());
        }
        if (web() != null) {
            web().validate();
        }
        if (createdOnBehalfOf() != null) {
            createdOnBehalfOf().validate();
        }
        if (extensionProperties() != null) {
            extensionProperties().forEach(e -> e.validate());
        }
        if (homeRealmDiscoveryPolicies() != null) {
            homeRealmDiscoveryPolicies().forEach(e -> e.validate());
        }
        if (owners() != null) {
            owners().forEach(e -> e.validate());
        }
        if (tokenIssuancePolicies() != null) {
            tokenIssuancePolicies().forEach(e -> e.validate());
        }
        if (tokenLifetimePolicies() != null) {
            tokenLifetimePolicies().forEach(e -> e.validate());
        }
    }
}
