// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashMap;
import java.util.Map;

/** assignedLabel. */
@Fluent
public final class MicrosoftGraphAssignedLabel {
    /*
     * The display name of the label. Read-only.
     */
    @JsonProperty(value = "displayName")
    private String displayName;

    /*
     * The unique identifier of the label.
     */
    @JsonProperty(value = "labelId")
    private String labelId;

    /*
     * assignedLabel
     */
    @JsonIgnore private Map<String, Object> additionalProperties;

    /**
     * Get the displayName property: The display name of the label. Read-only.
     *
     * @return the displayName value.
     */
    public String displayName() {
        return this.displayName;
    }

    /**
     * Set the displayName property: The display name of the label. Read-only.
     *
     * @param displayName the displayName value to set.
     * @return the MicrosoftGraphAssignedLabel object itself.
     */
    public MicrosoftGraphAssignedLabel withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    /**
     * Get the labelId property: The unique identifier of the label.
     *
     * @return the labelId value.
     */
    public String labelId() {
        return this.labelId;
    }

    /**
     * Set the labelId property: The unique identifier of the label.
     *
     * @param labelId the labelId value to set.
     * @return the MicrosoftGraphAssignedLabel object itself.
     */
    public MicrosoftGraphAssignedLabel withLabelId(String labelId) {
        this.labelId = labelId;
        return this;
    }

    /**
     * Get the additionalProperties property: assignedLabel.
     *
     * @return the additionalProperties value.
     */
    @JsonAnyGetter
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: assignedLabel.
     *
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphAssignedLabel object itself.
     */
    public MicrosoftGraphAssignedLabel withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @JsonAnySetter
    void withAdditionalProperties(String key, Object value) {
        if (additionalProperties == null) {
            additionalProperties = new HashMap<>();
        }
        additionalProperties.put(key, value);
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
