// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashMap;
import java.util.Map;

/** calculatedColumn. */
@Fluent
public final class MicrosoftGraphCalculatedColumn {
    /*
     * For dateTime output types, the format of the value. Must be one of
     * dateOnly or dateTime.
     */
    @JsonProperty(value = "format")
    private String format;

    /*
     * The formula used to compute the value for this column.
     */
    @JsonProperty(value = "formula")
    private String formula;

    /*
     * The output type used to format values in this column. Must be one of
     * boolean, currency, dateTime, number, or text.
     */
    @JsonProperty(value = "outputType")
    private String outputType;

    /*
     * calculatedColumn
     */
    @JsonIgnore private Map<String, Object> additionalProperties;

    /**
     * Get the format property: For dateTime output types, the format of the value. Must be one of dateOnly or dateTime.
     *
     * @return the format value.
     */
    public String format() {
        return this.format;
    }

    /**
     * Set the format property: For dateTime output types, the format of the value. Must be one of dateOnly or dateTime.
     *
     * @param format the format value to set.
     * @return the MicrosoftGraphCalculatedColumn object itself.
     */
    public MicrosoftGraphCalculatedColumn withFormat(String format) {
        this.format = format;
        return this;
    }

    /**
     * Get the formula property: The formula used to compute the value for this column.
     *
     * @return the formula value.
     */
    public String formula() {
        return this.formula;
    }

    /**
     * Set the formula property: The formula used to compute the value for this column.
     *
     * @param formula the formula value to set.
     * @return the MicrosoftGraphCalculatedColumn object itself.
     */
    public MicrosoftGraphCalculatedColumn withFormula(String formula) {
        this.formula = formula;
        return this;
    }

    /**
     * Get the outputType property: The output type used to format values in this column. Must be one of boolean,
     * currency, dateTime, number, or text.
     *
     * @return the outputType value.
     */
    public String outputType() {
        return this.outputType;
    }

    /**
     * Set the outputType property: The output type used to format values in this column. Must be one of boolean,
     * currency, dateTime, number, or text.
     *
     * @param outputType the outputType value to set.
     * @return the MicrosoftGraphCalculatedColumn object itself.
     */
    public MicrosoftGraphCalculatedColumn withOutputType(String outputType) {
        this.outputType = outputType;
        return this;
    }

    /**
     * Get the additionalProperties property: calculatedColumn.
     *
     * @return the additionalProperties value.
     */
    @JsonAnyGetter
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: calculatedColumn.
     *
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphCalculatedColumn object itself.
     */
    public MicrosoftGraphCalculatedColumn withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @JsonAnySetter
    void withAdditionalProperties(String key, Object value) {
        if (additionalProperties == null) {
            additionalProperties = new HashMap<>();
        }
        additionalProperties.put(key, value);
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
