// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashMap;
import java.util.Map;

/** chatInfo. */
@Fluent
public final class MicrosoftGraphChatInfo {
    /*
     * The unique identifier of a message in a Microsoft Teams channel.
     */
    @JsonProperty(value = "messageId")
    private String messageId;

    /*
     * The ID of the reply message.
     */
    @JsonProperty(value = "replyChainMessageId")
    private String replyChainMessageId;

    /*
     * The unique identifier for a thread in Microsoft Teams.
     */
    @JsonProperty(value = "threadId")
    private String threadId;

    /*
     * chatInfo
     */
    @JsonIgnore private Map<String, Object> additionalProperties;

    /**
     * Get the messageId property: The unique identifier of a message in a Microsoft Teams channel.
     *
     * @return the messageId value.
     */
    public String messageId() {
        return this.messageId;
    }

    /**
     * Set the messageId property: The unique identifier of a message in a Microsoft Teams channel.
     *
     * @param messageId the messageId value to set.
     * @return the MicrosoftGraphChatInfo object itself.
     */
    public MicrosoftGraphChatInfo withMessageId(String messageId) {
        this.messageId = messageId;
        return this;
    }

    /**
     * Get the replyChainMessageId property: The ID of the reply message.
     *
     * @return the replyChainMessageId value.
     */
    public String replyChainMessageId() {
        return this.replyChainMessageId;
    }

    /**
     * Set the replyChainMessageId property: The ID of the reply message.
     *
     * @param replyChainMessageId the replyChainMessageId value to set.
     * @return the MicrosoftGraphChatInfo object itself.
     */
    public MicrosoftGraphChatInfo withReplyChainMessageId(String replyChainMessageId) {
        this.replyChainMessageId = replyChainMessageId;
        return this;
    }

    /**
     * Get the threadId property: The unique identifier for a thread in Microsoft Teams.
     *
     * @return the threadId value.
     */
    public String threadId() {
        return this.threadId;
    }

    /**
     * Set the threadId property: The unique identifier for a thread in Microsoft Teams.
     *
     * @param threadId the threadId value to set.
     * @return the MicrosoftGraphChatInfo object itself.
     */
    public MicrosoftGraphChatInfo withThreadId(String threadId) {
        this.threadId = threadId;
        return this;
    }

    /**
     * Get the additionalProperties property: chatInfo.
     *
     * @return the additionalProperties value.
     */
    @JsonAnyGetter
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: chatInfo.
     *
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphChatInfo object itself.
     */
    public MicrosoftGraphChatInfo withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @JsonAnySetter
    void withAdditionalProperties(String key, Object value) {
        if (additionalProperties == null) {
            additionalProperties = new HashMap<>();
        }
        additionalProperties.put(key, value);
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
