// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashMap;
import java.util.Map;

/** groupLifecyclePolicy. */
@Fluent
public final class MicrosoftGraphGroupLifecyclePolicy extends MicrosoftGraphEntity {
    /*
     * List of email address to send notifications for groups without owners.
     * Multiple email address can be defined by separating email address with a
     * semicolon.
     */
    @JsonProperty(value = "alternateNotificationEmails")
    private String alternateNotificationEmails;

    /*
     * Number of days before a group expires and needs to be renewed. Once
     * renewed, the group expiration is extended by the number of days defined.
     */
    @JsonProperty(value = "groupLifetimeInDays")
    private Integer groupLifetimeInDays;

    /*
     * The group type for which the expiration policy applies. Possible values
     * are All, Selected or None.
     */
    @JsonProperty(value = "managedGroupTypes")
    private String managedGroupTypes;

    /*
     * groupLifecyclePolicy
     */
    @JsonIgnore private Map<String, Object> additionalProperties;

    /**
     * Get the alternateNotificationEmails property: List of email address to send notifications for groups without
     * owners. Multiple email address can be defined by separating email address with a semicolon.
     *
     * @return the alternateNotificationEmails value.
     */
    public String alternateNotificationEmails() {
        return this.alternateNotificationEmails;
    }

    /**
     * Set the alternateNotificationEmails property: List of email address to send notifications for groups without
     * owners. Multiple email address can be defined by separating email address with a semicolon.
     *
     * @param alternateNotificationEmails the alternateNotificationEmails value to set.
     * @return the MicrosoftGraphGroupLifecyclePolicy object itself.
     */
    public MicrosoftGraphGroupLifecyclePolicy withAlternateNotificationEmails(String alternateNotificationEmails) {
        this.alternateNotificationEmails = alternateNotificationEmails;
        return this;
    }

    /**
     * Get the groupLifetimeInDays property: Number of days before a group expires and needs to be renewed. Once
     * renewed, the group expiration is extended by the number of days defined.
     *
     * @return the groupLifetimeInDays value.
     */
    public Integer groupLifetimeInDays() {
        return this.groupLifetimeInDays;
    }

    /**
     * Set the groupLifetimeInDays property: Number of days before a group expires and needs to be renewed. Once
     * renewed, the group expiration is extended by the number of days defined.
     *
     * @param groupLifetimeInDays the groupLifetimeInDays value to set.
     * @return the MicrosoftGraphGroupLifecyclePolicy object itself.
     */
    public MicrosoftGraphGroupLifecyclePolicy withGroupLifetimeInDays(Integer groupLifetimeInDays) {
        this.groupLifetimeInDays = groupLifetimeInDays;
        return this;
    }

    /**
     * Get the managedGroupTypes property: The group type for which the expiration policy applies. Possible values are
     * All, Selected or None.
     *
     * @return the managedGroupTypes value.
     */
    public String managedGroupTypes() {
        return this.managedGroupTypes;
    }

    /**
     * Set the managedGroupTypes property: The group type for which the expiration policy applies. Possible values are
     * All, Selected or None.
     *
     * @param managedGroupTypes the managedGroupTypes value to set.
     * @return the MicrosoftGraphGroupLifecyclePolicy object itself.
     */
    public MicrosoftGraphGroupLifecyclePolicy withManagedGroupTypes(String managedGroupTypes) {
        this.managedGroupTypes = managedGroupTypes;
        return this;
    }

    /**
     * Get the additionalProperties property: groupLifecyclePolicy.
     *
     * @return the additionalProperties value.
     */
    @JsonAnyGetter
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: groupLifecyclePolicy.
     *
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphGroupLifecyclePolicy object itself.
     */
    public MicrosoftGraphGroupLifecyclePolicy withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @JsonAnySetter
    void withAdditionalProperties(String key, Object value) {
        if (additionalProperties == null) {
            additionalProperties = new HashMap<>();
        }
        additionalProperties.put(key, value);
    }

    /** {@inheritDoc} */
    @Override
    public MicrosoftGraphGroupLifecyclePolicy withId(String id) {
        super.withId(id);
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
    }
}
