// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/** groupSetting. */
@Fluent
public final class MicrosoftGraphGroupSetting extends MicrosoftGraphEntity {
    /*
     * Display name of this group of settings, which comes from the associated
     * template.
     */
    @JsonProperty(value = "displayName")
    private String displayName;

    /*
     * Unique identifier for the template used to create this group of
     * settings. Read-only.
     */
    @JsonProperty(value = "templateId")
    private String templateId;

    /*
     * Collection of name value pairs. Must contain and set all the settings
     * defined in the template.
     */
    @JsonProperty(value = "values")
    private List<MicrosoftGraphSettingValue> values;

    /*
     * groupSetting
     */
    @JsonIgnore private Map<String, Object> additionalProperties;

    /**
     * Get the displayName property: Display name of this group of settings, which comes from the associated template.
     *
     * @return the displayName value.
     */
    public String displayName() {
        return this.displayName;
    }

    /**
     * Set the displayName property: Display name of this group of settings, which comes from the associated template.
     *
     * @param displayName the displayName value to set.
     * @return the MicrosoftGraphGroupSetting object itself.
     */
    public MicrosoftGraphGroupSetting withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    /**
     * Get the templateId property: Unique identifier for the template used to create this group of settings. Read-only.
     *
     * @return the templateId value.
     */
    public String templateId() {
        return this.templateId;
    }

    /**
     * Set the templateId property: Unique identifier for the template used to create this group of settings. Read-only.
     *
     * @param templateId the templateId value to set.
     * @return the MicrosoftGraphGroupSetting object itself.
     */
    public MicrosoftGraphGroupSetting withTemplateId(String templateId) {
        this.templateId = templateId;
        return this;
    }

    /**
     * Get the values property: Collection of name value pairs. Must contain and set all the settings defined in the
     * template.
     *
     * @return the values value.
     */
    public List<MicrosoftGraphSettingValue> values() {
        return this.values;
    }

    /**
     * Set the values property: Collection of name value pairs. Must contain and set all the settings defined in the
     * template.
     *
     * @param values the values value to set.
     * @return the MicrosoftGraphGroupSetting object itself.
     */
    public MicrosoftGraphGroupSetting withValues(List<MicrosoftGraphSettingValue> values) {
        this.values = values;
        return this;
    }

    /**
     * Get the additionalProperties property: groupSetting.
     *
     * @return the additionalProperties value.
     */
    @JsonAnyGetter
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: groupSetting.
     *
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphGroupSetting object itself.
     */
    public MicrosoftGraphGroupSetting withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @JsonAnySetter
    void withAdditionalProperties(String key, Object value) {
        if (additionalProperties == null) {
            additionalProperties = new HashMap<>();
        }
        additionalProperties.put(key, value);
    }

    /** {@inheritDoc} */
    @Override
    public MicrosoftGraphGroupSetting withId(String id) {
        super.withId(id);
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (values() != null) {
            values().forEach(e -> e.validate());
        }
    }
}
