// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashMap;
import java.util.Map;

/** location. */
@Fluent
public final class MicrosoftGraphLocation {
    /*
     * physicalAddress
     */
    @JsonProperty(value = "address")
    private MicrosoftGraphPhysicalAddress address;

    /*
     * outlookGeoCoordinates
     */
    @JsonProperty(value = "coordinates")
    private MicrosoftGraphOutlookGeoCoordinates coordinates;

    /*
     * The name associated with the location.
     */
    @JsonProperty(value = "displayName")
    private String displayName;

    /*
     * Optional email address of the location.
     */
    @JsonProperty(value = "locationEmailAddress")
    private String locationEmailAddress;

    /*
     * locationType
     */
    @JsonProperty(value = "locationType")
    private MicrosoftGraphLocationType locationType;

    /*
     * Optional URI representing the location.
     */
    @JsonProperty(value = "locationUri")
    private String locationUri;

    /*
     * For internal use only.
     */
    @JsonProperty(value = "uniqueId")
    private String uniqueId;

    /*
     * locationUniqueIdType
     */
    @JsonProperty(value = "uniqueIdType")
    private MicrosoftGraphLocationUniqueIdType uniqueIdType;

    /*
     * location
     */
    @JsonIgnore private Map<String, Object> additionalProperties;

    /**
     * Get the address property: physicalAddress.
     *
     * @return the address value.
     */
    public MicrosoftGraphPhysicalAddress address() {
        return this.address;
    }

    /**
     * Set the address property: physicalAddress.
     *
     * @param address the address value to set.
     * @return the MicrosoftGraphLocation object itself.
     */
    public MicrosoftGraphLocation withAddress(MicrosoftGraphPhysicalAddress address) {
        this.address = address;
        return this;
    }

    /**
     * Get the coordinates property: outlookGeoCoordinates.
     *
     * @return the coordinates value.
     */
    public MicrosoftGraphOutlookGeoCoordinates coordinates() {
        return this.coordinates;
    }

    /**
     * Set the coordinates property: outlookGeoCoordinates.
     *
     * @param coordinates the coordinates value to set.
     * @return the MicrosoftGraphLocation object itself.
     */
    public MicrosoftGraphLocation withCoordinates(MicrosoftGraphOutlookGeoCoordinates coordinates) {
        this.coordinates = coordinates;
        return this;
    }

    /**
     * Get the displayName property: The name associated with the location.
     *
     * @return the displayName value.
     */
    public String displayName() {
        return this.displayName;
    }

    /**
     * Set the displayName property: The name associated with the location.
     *
     * @param displayName the displayName value to set.
     * @return the MicrosoftGraphLocation object itself.
     */
    public MicrosoftGraphLocation withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    /**
     * Get the locationEmailAddress property: Optional email address of the location.
     *
     * @return the locationEmailAddress value.
     */
    public String locationEmailAddress() {
        return this.locationEmailAddress;
    }

    /**
     * Set the locationEmailAddress property: Optional email address of the location.
     *
     * @param locationEmailAddress the locationEmailAddress value to set.
     * @return the MicrosoftGraphLocation object itself.
     */
    public MicrosoftGraphLocation withLocationEmailAddress(String locationEmailAddress) {
        this.locationEmailAddress = locationEmailAddress;
        return this;
    }

    /**
     * Get the locationType property: locationType.
     *
     * @return the locationType value.
     */
    public MicrosoftGraphLocationType locationType() {
        return this.locationType;
    }

    /**
     * Set the locationType property: locationType.
     *
     * @param locationType the locationType value to set.
     * @return the MicrosoftGraphLocation object itself.
     */
    public MicrosoftGraphLocation withLocationType(MicrosoftGraphLocationType locationType) {
        this.locationType = locationType;
        return this;
    }

    /**
     * Get the locationUri property: Optional URI representing the location.
     *
     * @return the locationUri value.
     */
    public String locationUri() {
        return this.locationUri;
    }

    /**
     * Set the locationUri property: Optional URI representing the location.
     *
     * @param locationUri the locationUri value to set.
     * @return the MicrosoftGraphLocation object itself.
     */
    public MicrosoftGraphLocation withLocationUri(String locationUri) {
        this.locationUri = locationUri;
        return this;
    }

    /**
     * Get the uniqueId property: For internal use only.
     *
     * @return the uniqueId value.
     */
    public String uniqueId() {
        return this.uniqueId;
    }

    /**
     * Set the uniqueId property: For internal use only.
     *
     * @param uniqueId the uniqueId value to set.
     * @return the MicrosoftGraphLocation object itself.
     */
    public MicrosoftGraphLocation withUniqueId(String uniqueId) {
        this.uniqueId = uniqueId;
        return this;
    }

    /**
     * Get the uniqueIdType property: locationUniqueIdType.
     *
     * @return the uniqueIdType value.
     */
    public MicrosoftGraphLocationUniqueIdType uniqueIdType() {
        return this.uniqueIdType;
    }

    /**
     * Set the uniqueIdType property: locationUniqueIdType.
     *
     * @param uniqueIdType the uniqueIdType value to set.
     * @return the MicrosoftGraphLocation object itself.
     */
    public MicrosoftGraphLocation withUniqueIdType(MicrosoftGraphLocationUniqueIdType uniqueIdType) {
        this.uniqueIdType = uniqueIdType;
        return this;
    }

    /**
     * Get the additionalProperties property: location.
     *
     * @return the additionalProperties value.
     */
    @JsonAnyGetter
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: location.
     *
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphLocation object itself.
     */
    public MicrosoftGraphLocation withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @JsonAnySetter
    void withAdditionalProperties(String key, Object value) {
        if (additionalProperties == null) {
            additionalProperties = new HashMap<>();
        }
        additionalProperties.put(key, value);
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (address() != null) {
            address().validate();
        }
        if (coordinates() != null) {
            coordinates().validate();
        }
    }
}
