// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashMap;
import java.util.Map;

/** oAuth2PermissionGrant. */
@Fluent
public final class MicrosoftGraphOAuth2PermissionGrant extends MicrosoftGraphEntity {
    /*
     * The id of the client service principal for the application which is
     * authorized to act on behalf of a signed-in user when accessing an API.
     * Required. Supports $filter (eq only).
     */
    @JsonProperty(value = "clientId")
    private String clientId;

    /*
     * Indicates if authorization is granted for the client application to
     * impersonate all users or only a specific user. AllPrincipals indicates
     * authorization to impersonate all users. Principal indicates
     * authorization to impersonate a specific user. Consent on behalf of all
     * users can be granted by an administrator. Non-admin users may be
     * authorized to consent on behalf of themselves in some cases, for some
     * delegated permissions. Required. Supports $filter (eq only).
     */
    @JsonProperty(value = "consentType")
    private String consentType;

    /*
     * The id of the user on behalf of whom the client is authorized to access
     * the resource, when consentType is Principal. If consentType is
     * AllPrincipals this value is null. Required when consentType is
     * Principal.
     */
    @JsonProperty(value = "principalId")
    private String principalId;

    /*
     * The id of the resource service principal to which access is authorized.
     * This identifies the API which the client is authorized to attempt to
     * call on behalf of a signed-in user.
     */
    @JsonProperty(value = "resourceId")
    private String resourceId;

    /*
     * A space-separated list of the claim values for delegated permissions
     * which should be included in access tokens for the resource application
     * (the API). For example, openid User.Read GroupMember.Read.All. Each
     * claim value should match the value field of one of the delegated
     * permissions defined by the API, listed in the publishedPermissionScopes
     * property of the resource service principal.
     */
    @JsonProperty(value = "scope")
    private String scope;

    /*
     * oAuth2PermissionGrant
     */
    @JsonIgnore private Map<String, Object> additionalProperties;

    /**
     * Get the clientId property: The id of the client service principal for the application which is authorized to act
     * on behalf of a signed-in user when accessing an API. Required. Supports $filter (eq only).
     *
     * @return the clientId value.
     */
    public String clientId() {
        return this.clientId;
    }

    /**
     * Set the clientId property: The id of the client service principal for the application which is authorized to act
     * on behalf of a signed-in user when accessing an API. Required. Supports $filter (eq only).
     *
     * @param clientId the clientId value to set.
     * @return the MicrosoftGraphOAuth2PermissionGrant object itself.
     */
    public MicrosoftGraphOAuth2PermissionGrant withClientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    /**
     * Get the consentType property: Indicates if authorization is granted for the client application to impersonate all
     * users or only a specific user. AllPrincipals indicates authorization to impersonate all users. Principal
     * indicates authorization to impersonate a specific user. Consent on behalf of all users can be granted by an
     * administrator. Non-admin users may be authorized to consent on behalf of themselves in some cases, for some
     * delegated permissions. Required. Supports $filter (eq only).
     *
     * @return the consentType value.
     */
    public String consentType() {
        return this.consentType;
    }

    /**
     * Set the consentType property: Indicates if authorization is granted for the client application to impersonate all
     * users or only a specific user. AllPrincipals indicates authorization to impersonate all users. Principal
     * indicates authorization to impersonate a specific user. Consent on behalf of all users can be granted by an
     * administrator. Non-admin users may be authorized to consent on behalf of themselves in some cases, for some
     * delegated permissions. Required. Supports $filter (eq only).
     *
     * @param consentType the consentType value to set.
     * @return the MicrosoftGraphOAuth2PermissionGrant object itself.
     */
    public MicrosoftGraphOAuth2PermissionGrant withConsentType(String consentType) {
        this.consentType = consentType;
        return this;
    }

    /**
     * Get the principalId property: The id of the user on behalf of whom the client is authorized to access the
     * resource, when consentType is Principal. If consentType is AllPrincipals this value is null. Required when
     * consentType is Principal.
     *
     * @return the principalId value.
     */
    public String principalId() {
        return this.principalId;
    }

    /**
     * Set the principalId property: The id of the user on behalf of whom the client is authorized to access the
     * resource, when consentType is Principal. If consentType is AllPrincipals this value is null. Required when
     * consentType is Principal.
     *
     * @param principalId the principalId value to set.
     * @return the MicrosoftGraphOAuth2PermissionGrant object itself.
     */
    public MicrosoftGraphOAuth2PermissionGrant withPrincipalId(String principalId) {
        this.principalId = principalId;
        return this;
    }

    /**
     * Get the resourceId property: The id of the resource service principal to which access is authorized. This
     * identifies the API which the client is authorized to attempt to call on behalf of a signed-in user.
     *
     * @return the resourceId value.
     */
    public String resourceId() {
        return this.resourceId;
    }

    /**
     * Set the resourceId property: The id of the resource service principal to which access is authorized. This
     * identifies the API which the client is authorized to attempt to call on behalf of a signed-in user.
     *
     * @param resourceId the resourceId value to set.
     * @return the MicrosoftGraphOAuth2PermissionGrant object itself.
     */
    public MicrosoftGraphOAuth2PermissionGrant withResourceId(String resourceId) {
        this.resourceId = resourceId;
        return this;
    }

    /**
     * Get the scope property: A space-separated list of the claim values for delegated permissions which should be
     * included in access tokens for the resource application (the API). For example, openid User.Read
     * GroupMember.Read.All. Each claim value should match the value field of one of the delegated permissions defined
     * by the API, listed in the publishedPermissionScopes property of the resource service principal.
     *
     * @return the scope value.
     */
    public String scope() {
        return this.scope;
    }

    /**
     * Set the scope property: A space-separated list of the claim values for delegated permissions which should be
     * included in access tokens for the resource application (the API). For example, openid User.Read
     * GroupMember.Read.All. Each claim value should match the value field of one of the delegated permissions defined
     * by the API, listed in the publishedPermissionScopes property of the resource service principal.
     *
     * @param scope the scope value to set.
     * @return the MicrosoftGraphOAuth2PermissionGrant object itself.
     */
    public MicrosoftGraphOAuth2PermissionGrant withScope(String scope) {
        this.scope = scope;
        return this;
    }

    /**
     * Get the additionalProperties property: oAuth2PermissionGrant.
     *
     * @return the additionalProperties value.
     */
    @JsonAnyGetter
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: oAuth2PermissionGrant.
     *
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphOAuth2PermissionGrant object itself.
     */
    public MicrosoftGraphOAuth2PermissionGrant withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @JsonAnySetter
    void withAdditionalProperties(String key, Object value) {
        if (additionalProperties == null) {
            additionalProperties = new HashMap<>();
        }
        additionalProperties.put(key, value);
    }

    /** {@inheritDoc} */
    @Override
    public MicrosoftGraphOAuth2PermissionGrant withId(String id) {
        super.withId(id);
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
    }
}
