// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/** officeGraphInsights. */
@Fluent
public final class MicrosoftGraphOfficeGraphInsights extends MicrosoftGraphEntity {
    /*
     * Calculated relationship identifying documents shared with or by the
     * user. This includes URLs, file attachments, and reference attachments to
     * OneDrive for Business and SharePoint files found in Outlook messages and
     * meetings. This also includes URLs and reference attachments to Teams
     * conversations. Ordered by recency of share.
     */
    @JsonProperty(value = "shared")
    private List<MicrosoftGraphSharedInsight> shared;

    /*
     * Calculated relationship identifying documents trending around a user.
     * Trending documents are calculated based on activity of the user's
     * closest network of people and include files stored in OneDrive for
     * Business and SharePoint. Trending insights help the user to discover
     * potentially useful content that the user has access to, but has never
     * viewed before.
     */
    @JsonProperty(value = "trending")
    private List<MicrosoftGraphTrending> trending;

    /*
     * Calculated relationship identifying the latest documents viewed or
     * modified by a user, including OneDrive for Business and SharePoint
     * documents, ranked by recency of use.
     */
    @JsonProperty(value = "used")
    private List<MicrosoftGraphUsedInsight> used;

    /*
     * officeGraphInsights
     */
    @JsonIgnore private Map<String, Object> additionalProperties;

    /**
     * Get the shared property: Calculated relationship identifying documents shared with or by the user. This includes
     * URLs, file attachments, and reference attachments to OneDrive for Business and SharePoint files found in Outlook
     * messages and meetings. This also includes URLs and reference attachments to Teams conversations. Ordered by
     * recency of share.
     *
     * @return the shared value.
     */
    public List<MicrosoftGraphSharedInsight> shared() {
        return this.shared;
    }

    /**
     * Set the shared property: Calculated relationship identifying documents shared with or by the user. This includes
     * URLs, file attachments, and reference attachments to OneDrive for Business and SharePoint files found in Outlook
     * messages and meetings. This also includes URLs and reference attachments to Teams conversations. Ordered by
     * recency of share.
     *
     * @param shared the shared value to set.
     * @return the MicrosoftGraphOfficeGraphInsights object itself.
     */
    public MicrosoftGraphOfficeGraphInsights withShared(List<MicrosoftGraphSharedInsight> shared) {
        this.shared = shared;
        return this;
    }

    /**
     * Get the trending property: Calculated relationship identifying documents trending around a user. Trending
     * documents are calculated based on activity of the user's closest network of people and include files stored in
     * OneDrive for Business and SharePoint. Trending insights help the user to discover potentially useful content that
     * the user has access to, but has never viewed before.
     *
     * @return the trending value.
     */
    public List<MicrosoftGraphTrending> trending() {
        return this.trending;
    }

    /**
     * Set the trending property: Calculated relationship identifying documents trending around a user. Trending
     * documents are calculated based on activity of the user's closest network of people and include files stored in
     * OneDrive for Business and SharePoint. Trending insights help the user to discover potentially useful content that
     * the user has access to, but has never viewed before.
     *
     * @param trending the trending value to set.
     * @return the MicrosoftGraphOfficeGraphInsights object itself.
     */
    public MicrosoftGraphOfficeGraphInsights withTrending(List<MicrosoftGraphTrending> trending) {
        this.trending = trending;
        return this;
    }

    /**
     * Get the used property: Calculated relationship identifying the latest documents viewed or modified by a user,
     * including OneDrive for Business and SharePoint documents, ranked by recency of use.
     *
     * @return the used value.
     */
    public List<MicrosoftGraphUsedInsight> used() {
        return this.used;
    }

    /**
     * Set the used property: Calculated relationship identifying the latest documents viewed or modified by a user,
     * including OneDrive for Business and SharePoint documents, ranked by recency of use.
     *
     * @param used the used value to set.
     * @return the MicrosoftGraphOfficeGraphInsights object itself.
     */
    public MicrosoftGraphOfficeGraphInsights withUsed(List<MicrosoftGraphUsedInsight> used) {
        this.used = used;
        return this;
    }

    /**
     * Get the additionalProperties property: officeGraphInsights.
     *
     * @return the additionalProperties value.
     */
    @JsonAnyGetter
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: officeGraphInsights.
     *
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphOfficeGraphInsights object itself.
     */
    public MicrosoftGraphOfficeGraphInsights withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @JsonAnySetter
    void withAdditionalProperties(String key, Object value) {
        if (additionalProperties == null) {
            additionalProperties = new HashMap<>();
        }
        additionalProperties.put(key, value);
    }

    /** {@inheritDoc} */
    @Override
    public MicrosoftGraphOfficeGraphInsights withId(String id) {
        super.withId(id);
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (shared() != null) {
            shared().forEach(e -> e.validate());
        }
        if (trending() != null) {
            trending().forEach(e -> e.validate());
        }
        if (used() != null) {
            used().forEach(e -> e.validate());
        }
    }
}
