// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/** permission. */
@Fluent
public final class MicrosoftGraphPermission extends MicrosoftGraphEntity {
    /*
     * A format of yyyy-MM-ddTHH:mm:ssZ of DateTimeOffset indicates the
     * expiration time of the permission. DateTime.MinValue indicates there is
     * no expiration set for this permission. Optional.
     */
    @JsonProperty(value = "expirationDateTime")
    private OffsetDateTime expirationDateTime;

    /*
     * identitySet
     */
    @JsonProperty(value = "grantedTo")
    private MicrosoftGraphIdentitySet grantedTo;

    /*
     * For link type permissions, the details of the users to whom permission
     * was granted. Read-only.
     */
    @JsonProperty(value = "grantedToIdentities")
    private List<MicrosoftGraphIdentitySet> grantedToIdentities;

    /*
     * This indicates whether password is set for this permission, it's only
     * showing in response. Optional and Read-only and for OneDrive Personal
     * only.
     */
    @JsonProperty(value = "hasPassword")
    private Boolean hasPassword;

    /*
     * itemReference
     */
    @JsonProperty(value = "inheritedFrom")
    private MicrosoftGraphItemReference inheritedFrom;

    /*
     * sharingInvitation
     */
    @JsonProperty(value = "invitation")
    private MicrosoftGraphSharingInvitation invitation;

    /*
     * sharingLink
     */
    @JsonProperty(value = "link")
    private MicrosoftGraphSharingLink link;

    /*
     * The type of permission, e.g. read. See below for the full list of roles.
     * Read-only.
     */
    @JsonProperty(value = "roles")
    private List<String> roles;

    /*
     * A unique token that can be used to access this shared item via the
     * **shares** API. Read-only.
     */
    @JsonProperty(value = "shareId")
    private String shareId;

    /*
     * permission
     */
    @JsonIgnore private Map<String, Object> additionalProperties;

    /**
     * Get the expirationDateTime property: A format of yyyy-MM-ddTHH:mm:ssZ of DateTimeOffset indicates the expiration
     * time of the permission. DateTime.MinValue indicates there is no expiration set for this permission. Optional.
     *
     * @return the expirationDateTime value.
     */
    public OffsetDateTime expirationDateTime() {
        return this.expirationDateTime;
    }

    /**
     * Set the expirationDateTime property: A format of yyyy-MM-ddTHH:mm:ssZ of DateTimeOffset indicates the expiration
     * time of the permission. DateTime.MinValue indicates there is no expiration set for this permission. Optional.
     *
     * @param expirationDateTime the expirationDateTime value to set.
     * @return the MicrosoftGraphPermission object itself.
     */
    public MicrosoftGraphPermission withExpirationDateTime(OffsetDateTime expirationDateTime) {
        this.expirationDateTime = expirationDateTime;
        return this;
    }

    /**
     * Get the grantedTo property: identitySet.
     *
     * @return the grantedTo value.
     */
    public MicrosoftGraphIdentitySet grantedTo() {
        return this.grantedTo;
    }

    /**
     * Set the grantedTo property: identitySet.
     *
     * @param grantedTo the grantedTo value to set.
     * @return the MicrosoftGraphPermission object itself.
     */
    public MicrosoftGraphPermission withGrantedTo(MicrosoftGraphIdentitySet grantedTo) {
        this.grantedTo = grantedTo;
        return this;
    }

    /**
     * Get the grantedToIdentities property: For link type permissions, the details of the users to whom permission was
     * granted. Read-only.
     *
     * @return the grantedToIdentities value.
     */
    public List<MicrosoftGraphIdentitySet> grantedToIdentities() {
        return this.grantedToIdentities;
    }

    /**
     * Set the grantedToIdentities property: For link type permissions, the details of the users to whom permission was
     * granted. Read-only.
     *
     * @param grantedToIdentities the grantedToIdentities value to set.
     * @return the MicrosoftGraphPermission object itself.
     */
    public MicrosoftGraphPermission withGrantedToIdentities(List<MicrosoftGraphIdentitySet> grantedToIdentities) {
        this.grantedToIdentities = grantedToIdentities;
        return this;
    }

    /**
     * Get the hasPassword property: This indicates whether password is set for this permission, it's only showing in
     * response. Optional and Read-only and for OneDrive Personal only.
     *
     * @return the hasPassword value.
     */
    public Boolean hasPassword() {
        return this.hasPassword;
    }

    /**
     * Set the hasPassword property: This indicates whether password is set for this permission, it's only showing in
     * response. Optional and Read-only and for OneDrive Personal only.
     *
     * @param hasPassword the hasPassword value to set.
     * @return the MicrosoftGraphPermission object itself.
     */
    public MicrosoftGraphPermission withHasPassword(Boolean hasPassword) {
        this.hasPassword = hasPassword;
        return this;
    }

    /**
     * Get the inheritedFrom property: itemReference.
     *
     * @return the inheritedFrom value.
     */
    public MicrosoftGraphItemReference inheritedFrom() {
        return this.inheritedFrom;
    }

    /**
     * Set the inheritedFrom property: itemReference.
     *
     * @param inheritedFrom the inheritedFrom value to set.
     * @return the MicrosoftGraphPermission object itself.
     */
    public MicrosoftGraphPermission withInheritedFrom(MicrosoftGraphItemReference inheritedFrom) {
        this.inheritedFrom = inheritedFrom;
        return this;
    }

    /**
     * Get the invitation property: sharingInvitation.
     *
     * @return the invitation value.
     */
    public MicrosoftGraphSharingInvitation invitation() {
        return this.invitation;
    }

    /**
     * Set the invitation property: sharingInvitation.
     *
     * @param invitation the invitation value to set.
     * @return the MicrosoftGraphPermission object itself.
     */
    public MicrosoftGraphPermission withInvitation(MicrosoftGraphSharingInvitation invitation) {
        this.invitation = invitation;
        return this;
    }

    /**
     * Get the link property: sharingLink.
     *
     * @return the link value.
     */
    public MicrosoftGraphSharingLink link() {
        return this.link;
    }

    /**
     * Set the link property: sharingLink.
     *
     * @param link the link value to set.
     * @return the MicrosoftGraphPermission object itself.
     */
    public MicrosoftGraphPermission withLink(MicrosoftGraphSharingLink link) {
        this.link = link;
        return this;
    }

    /**
     * Get the roles property: The type of permission, e.g. read. See below for the full list of roles. Read-only.
     *
     * @return the roles value.
     */
    public List<String> roles() {
        return this.roles;
    }

    /**
     * Set the roles property: The type of permission, e.g. read. See below for the full list of roles. Read-only.
     *
     * @param roles the roles value to set.
     * @return the MicrosoftGraphPermission object itself.
     */
    public MicrosoftGraphPermission withRoles(List<String> roles) {
        this.roles = roles;
        return this;
    }

    /**
     * Get the shareId property: A unique token that can be used to access this shared item via the **shares** API.
     * Read-only.
     *
     * @return the shareId value.
     */
    public String shareId() {
        return this.shareId;
    }

    /**
     * Set the shareId property: A unique token that can be used to access this shared item via the **shares** API.
     * Read-only.
     *
     * @param shareId the shareId value to set.
     * @return the MicrosoftGraphPermission object itself.
     */
    public MicrosoftGraphPermission withShareId(String shareId) {
        this.shareId = shareId;
        return this;
    }

    /**
     * Get the additionalProperties property: permission.
     *
     * @return the additionalProperties value.
     */
    @JsonAnyGetter
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: permission.
     *
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphPermission object itself.
     */
    public MicrosoftGraphPermission withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @JsonAnySetter
    void withAdditionalProperties(String key, Object value) {
        if (additionalProperties == null) {
            additionalProperties = new HashMap<>();
        }
        additionalProperties.put(key, value);
    }

    /** {@inheritDoc} */
    @Override
    public MicrosoftGraphPermission withId(String id) {
        super.withId(id);
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (grantedTo() != null) {
            grantedTo().validate();
        }
        if (grantedToIdentities() != null) {
            grantedToIdentities().forEach(e -> e.validate());
        }
        if (inheritedFrom() != null) {
            inheritedFrom().validate();
        }
        if (invitation() != null) {
            invitation().validate();
        }
        if (link() != null) {
            link().validate();
        }
    }
}
