// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashMap;
import java.util.Map;

/** quota. */
@Fluent
public final class MicrosoftGraphQuota {
    /*
     * Total space consumed by files in the recycle bin, in bytes. Read-only.
     */
    @JsonProperty(value = "deleted")
    private Long deleted;

    /*
     * Total space remaining before reaching the quota limit, in bytes.
     * Read-only.
     */
    @JsonProperty(value = "remaining")
    private Long remaining;

    /*
     * Enumeration value that indicates the state of the storage space.
     * Read-only.
     */
    @JsonProperty(value = "state")
    private String state;

    /*
     * storagePlanInformation
     */
    @JsonProperty(value = "storagePlanInformation")
    private MicrosoftGraphStoragePlanInformation storagePlanInformation;

    /*
     * Total allowed storage space, in bytes. Read-only.
     */
    @JsonProperty(value = "total")
    private Long total;

    /*
     * Total space used, in bytes. Read-only.
     */
    @JsonProperty(value = "used")
    private Long used;

    /*
     * quota
     */
    @JsonIgnore private Map<String, Object> additionalProperties;

    /**
     * Get the deleted property: Total space consumed by files in the recycle bin, in bytes. Read-only.
     *
     * @return the deleted value.
     */
    public Long deleted() {
        return this.deleted;
    }

    /**
     * Set the deleted property: Total space consumed by files in the recycle bin, in bytes. Read-only.
     *
     * @param deleted the deleted value to set.
     * @return the MicrosoftGraphQuota object itself.
     */
    public MicrosoftGraphQuota withDeleted(Long deleted) {
        this.deleted = deleted;
        return this;
    }

    /**
     * Get the remaining property: Total space remaining before reaching the quota limit, in bytes. Read-only.
     *
     * @return the remaining value.
     */
    public Long remaining() {
        return this.remaining;
    }

    /**
     * Set the remaining property: Total space remaining before reaching the quota limit, in bytes. Read-only.
     *
     * @param remaining the remaining value to set.
     * @return the MicrosoftGraphQuota object itself.
     */
    public MicrosoftGraphQuota withRemaining(Long remaining) {
        this.remaining = remaining;
        return this;
    }

    /**
     * Get the state property: Enumeration value that indicates the state of the storage space. Read-only.
     *
     * @return the state value.
     */
    public String state() {
        return this.state;
    }

    /**
     * Set the state property: Enumeration value that indicates the state of the storage space. Read-only.
     *
     * @param state the state value to set.
     * @return the MicrosoftGraphQuota object itself.
     */
    public MicrosoftGraphQuota withState(String state) {
        this.state = state;
        return this;
    }

    /**
     * Get the storagePlanInformation property: storagePlanInformation.
     *
     * @return the storagePlanInformation value.
     */
    public MicrosoftGraphStoragePlanInformation storagePlanInformation() {
        return this.storagePlanInformation;
    }

    /**
     * Set the storagePlanInformation property: storagePlanInformation.
     *
     * @param storagePlanInformation the storagePlanInformation value to set.
     * @return the MicrosoftGraphQuota object itself.
     */
    public MicrosoftGraphQuota withStoragePlanInformation(MicrosoftGraphStoragePlanInformation storagePlanInformation) {
        this.storagePlanInformation = storagePlanInformation;
        return this;
    }

    /**
     * Get the total property: Total allowed storage space, in bytes. Read-only.
     *
     * @return the total value.
     */
    public Long total() {
        return this.total;
    }

    /**
     * Set the total property: Total allowed storage space, in bytes. Read-only.
     *
     * @param total the total value to set.
     * @return the MicrosoftGraphQuota object itself.
     */
    public MicrosoftGraphQuota withTotal(Long total) {
        this.total = total;
        return this;
    }

    /**
     * Get the used property: Total space used, in bytes. Read-only.
     *
     * @return the used value.
     */
    public Long used() {
        return this.used;
    }

    /**
     * Set the used property: Total space used, in bytes. Read-only.
     *
     * @param used the used value to set.
     * @return the MicrosoftGraphQuota object itself.
     */
    public MicrosoftGraphQuota withUsed(Long used) {
        this.used = used;
        return this;
    }

    /**
     * Get the additionalProperties property: quota.
     *
     * @return the additionalProperties value.
     */
    @JsonAnyGetter
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: quota.
     *
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphQuota object itself.
     */
    public MicrosoftGraphQuota withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @JsonAnySetter
    void withAdditionalProperties(String key, Object value) {
        if (additionalProperties == null) {
            additionalProperties = new HashMap<>();
        }
        additionalProperties.put(key, value);
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (storagePlanInformation() != null) {
            storagePlanInformation().validate();
        }
    }
}
