// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashMap;
import java.util.Map;

/** samlSingleSignOnSettings. */
@Fluent
public final class MicrosoftGraphSamlSingleSignOnSettings {
    /*
     * The relative URI the service provider would redirect to after completion
     * of the single sign-on flow.
     */
    @JsonProperty(value = "relayState")
    private String relayState;

    /*
     * samlSingleSignOnSettings
     */
    @JsonIgnore private Map<String, Object> additionalProperties;

    /**
     * Get the relayState property: The relative URI the service provider would redirect to after completion of the
     * single sign-on flow.
     *
     * @return the relayState value.
     */
    public String relayState() {
        return this.relayState;
    }

    /**
     * Set the relayState property: The relative URI the service provider would redirect to after completion of the
     * single sign-on flow.
     *
     * @param relayState the relayState value to set.
     * @return the MicrosoftGraphSamlSingleSignOnSettings object itself.
     */
    public MicrosoftGraphSamlSingleSignOnSettings withRelayState(String relayState) {
        this.relayState = relayState;
        return this;
    }

    /**
     * Get the additionalProperties property: samlSingleSignOnSettings.
     *
     * @return the additionalProperties value.
     */
    @JsonAnyGetter
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: samlSingleSignOnSettings.
     *
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphSamlSingleSignOnSettings object itself.
     */
    public MicrosoftGraphSamlSingleSignOnSettings withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @JsonAnySetter
    void withAdditionalProperties(String key, Object value) {
        if (additionalProperties == null) {
            additionalProperties = new HashMap<>();
        }
        additionalProperties.put(key, value);
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
