// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashMap;
import java.util.Map;

/** workbookApplication. */
@Fluent
public final class MicrosoftGraphWorkbookApplication extends MicrosoftGraphEntity {
    /*
     * Returns the calculation mode used in the workbook. Possible values are:
     * Automatic, AutomaticExceptTables, Manual.
     */
    @JsonProperty(value = "calculationMode")
    private String calculationMode;

    /*
     * workbookApplication
     */
    @JsonIgnore private Map<String, Object> additionalProperties;

    /**
     * Get the calculationMode property: Returns the calculation mode used in the workbook. Possible values are:
     * Automatic, AutomaticExceptTables, Manual.
     *
     * @return the calculationMode value.
     */
    public String calculationMode() {
        return this.calculationMode;
    }

    /**
     * Set the calculationMode property: Returns the calculation mode used in the workbook. Possible values are:
     * Automatic, AutomaticExceptTables, Manual.
     *
     * @param calculationMode the calculationMode value to set.
     * @return the MicrosoftGraphWorkbookApplication object itself.
     */
    public MicrosoftGraphWorkbookApplication withCalculationMode(String calculationMode) {
        this.calculationMode = calculationMode;
        return this;
    }

    /**
     * Get the additionalProperties property: workbookApplication.
     *
     * @return the additionalProperties value.
     */
    @JsonAnyGetter
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: workbookApplication.
     *
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphWorkbookApplication object itself.
     */
    public MicrosoftGraphWorkbookApplication withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @JsonAnySetter
    void withAdditionalProperties(String key, Object value) {
        if (additionalProperties == null) {
            additionalProperties = new HashMap<>();
        }
        additionalProperties.put(key, value);
    }

    /** {@inheritDoc} */
    @Override
    public MicrosoftGraphWorkbookApplication withId(String id) {
        super.withId(id);
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
    }
}
