// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashMap;
import java.util.Map;

/** workbookChartLegend. */
@Fluent
public final class MicrosoftGraphWorkbookChartLegend extends MicrosoftGraphEntity {
    /*
     * Boolean value for whether the chart legend should overlap with the main
     * body of the chart.
     */
    @JsonProperty(value = "overlay")
    private Boolean overlay;

    /*
     * Represents the position of the legend on the chart. The possible values
     * are: Top, Bottom, Left, Right, Corner, Custom.
     */
    @JsonProperty(value = "position")
    private String position;

    /*
     * A boolean value the represents the visibility of a ChartLegend object.
     */
    @JsonProperty(value = "visible")
    private Boolean visible;

    /*
     * workbookChartLegendFormat
     */
    @JsonProperty(value = "format")
    private MicrosoftGraphWorkbookChartLegendFormat format;

    /*
     * workbookChartLegend
     */
    @JsonIgnore private Map<String, Object> additionalProperties;

    /**
     * Get the overlay property: Boolean value for whether the chart legend should overlap with the main body of the
     * chart.
     *
     * @return the overlay value.
     */
    public Boolean overlay() {
        return this.overlay;
    }

    /**
     * Set the overlay property: Boolean value for whether the chart legend should overlap with the main body of the
     * chart.
     *
     * @param overlay the overlay value to set.
     * @return the MicrosoftGraphWorkbookChartLegend object itself.
     */
    public MicrosoftGraphWorkbookChartLegend withOverlay(Boolean overlay) {
        this.overlay = overlay;
        return this;
    }

    /**
     * Get the position property: Represents the position of the legend on the chart. The possible values are: Top,
     * Bottom, Left, Right, Corner, Custom.
     *
     * @return the position value.
     */
    public String position() {
        return this.position;
    }

    /**
     * Set the position property: Represents the position of the legend on the chart. The possible values are: Top,
     * Bottom, Left, Right, Corner, Custom.
     *
     * @param position the position value to set.
     * @return the MicrosoftGraphWorkbookChartLegend object itself.
     */
    public MicrosoftGraphWorkbookChartLegend withPosition(String position) {
        this.position = position;
        return this;
    }

    /**
     * Get the visible property: A boolean value the represents the visibility of a ChartLegend object.
     *
     * @return the visible value.
     */
    public Boolean visible() {
        return this.visible;
    }

    /**
     * Set the visible property: A boolean value the represents the visibility of a ChartLegend object.
     *
     * @param visible the visible value to set.
     * @return the MicrosoftGraphWorkbookChartLegend object itself.
     */
    public MicrosoftGraphWorkbookChartLegend withVisible(Boolean visible) {
        this.visible = visible;
        return this;
    }

    /**
     * Get the format property: workbookChartLegendFormat.
     *
     * @return the format value.
     */
    public MicrosoftGraphWorkbookChartLegendFormat format() {
        return this.format;
    }

    /**
     * Set the format property: workbookChartLegendFormat.
     *
     * @param format the format value to set.
     * @return the MicrosoftGraphWorkbookChartLegend object itself.
     */
    public MicrosoftGraphWorkbookChartLegend withFormat(MicrosoftGraphWorkbookChartLegendFormat format) {
        this.format = format;
        return this;
    }

    /**
     * Get the additionalProperties property: workbookChartLegend.
     *
     * @return the additionalProperties value.
     */
    @JsonAnyGetter
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: workbookChartLegend.
     *
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphWorkbookChartLegend object itself.
     */
    public MicrosoftGraphWorkbookChartLegend withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @JsonAnySetter
    void withAdditionalProperties(String key, Object value) {
        if (additionalProperties == null) {
            additionalProperties = new HashMap<>();
        }
        additionalProperties.put(key, value);
    }

    /** {@inheritDoc} */
    @Override
    public MicrosoftGraphWorkbookChartLegend withId(String id) {
        super.withId(id);
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (format() != null) {
            format().validate();
        }
    }
}
