// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.resourcemanager.authorization.fluent.ServicePrincipalsClient;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphKeyCredentialInner;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphPasswordCredentialInner;
import com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException;
import com.azure.resourcemanager.authorization.fluent.models.ServicePrincipalsAddKeyRequestBodyInner;
import com.azure.resourcemanager.authorization.fluent.models.ServicePrincipalsAddPasswordRequestBodyInner;
import reactor.core.publisher.Mono;

/** An instance of this class provides access to all the operations defined in ServicePrincipalsClient. */
public final class ServicePrincipalsClientImpl implements ServicePrincipalsClient {
    /** The proxy service used to perform REST calls. */
    private final ServicePrincipalsService service;

    /** The service client containing this operation class. */
    private final MicrosoftGraphClientImpl client;

    /**
     * Initializes an instance of ServicePrincipalsClientImpl.
     *
     * @param client the instance of the service client containing this operation class.
     */
    ServicePrincipalsClientImpl(MicrosoftGraphClientImpl client) {
        this.service =
            RestProxy.create(ServicePrincipalsService.class, client.getHttpPipeline(), client.getSerializerAdapter());
        this.client = client;
    }

    /**
     * The interface defining all the services for MicrosoftGraphClientServicePrincipals to be used by the proxy service
     * to perform REST calls.
     */
    @Host("{$host}")
    @ServiceInterface(name = "MicrosoftGraphClient")
    private interface ServicePrincipalsService {
        @Headers({"Content-Type: application/json"})
        @Post("/servicePrincipals/{servicePrincipal-id}/microsoft.graph.addKey")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<Response<MicrosoftGraphKeyCredentialInner>> addKey(
            @HostParam("$host") String endpoint,
            @PathParam("servicePrincipal-id") String servicePrincipalId,
            @BodyParam("application/json") ServicePrincipalsAddKeyRequestBodyInner body,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Post("/servicePrincipals/{servicePrincipal-id}/microsoft.graph.addPassword")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<Response<MicrosoftGraphPasswordCredentialInner>> addPassword(
            @HostParam("$host") String endpoint,
            @PathParam("servicePrincipal-id") String servicePrincipalId,
            @BodyParam("application/json") ServicePrincipalsAddPasswordRequestBodyInner body,
            @HeaderParam("Accept") String accept,
            Context context);
    }

    /**
     * Invoke action addKey.
     *
     * @param servicePrincipalId key: id of servicePrincipal.
     * @param body Action parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return keyCredential along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<MicrosoftGraphKeyCredentialInner>> addKeyWithResponseAsync(
        String servicePrincipalId, ServicePrincipalsAddKeyRequestBodyInner body) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (servicePrincipalId == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter servicePrincipalId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error(new IllegalArgumentException("Parameter body is required and cannot be null."));
        } else {
            body.validate();
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context -> service.addKey(this.client.getEndpoint(), servicePrincipalId, body, accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Invoke action addKey.
     *
     * @param servicePrincipalId key: id of servicePrincipal.
     * @param body Action parameters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return keyCredential along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<MicrosoftGraphKeyCredentialInner>> addKeyWithResponseAsync(
        String servicePrincipalId, ServicePrincipalsAddKeyRequestBodyInner body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (servicePrincipalId == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter servicePrincipalId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error(new IllegalArgumentException("Parameter body is required and cannot be null."));
        } else {
            body.validate();
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.addKey(this.client.getEndpoint(), servicePrincipalId, body, accept, context);
    }

    /**
     * Invoke action addKey.
     *
     * @param servicePrincipalId key: id of servicePrincipal.
     * @param body Action parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return keyCredential on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<MicrosoftGraphKeyCredentialInner> addKeyAsync(
        String servicePrincipalId, ServicePrincipalsAddKeyRequestBodyInner body) {
        return addKeyWithResponseAsync(servicePrincipalId, body)
            .flatMap(
                (Response<MicrosoftGraphKeyCredentialInner> res) -> {
                    if (res.getValue() != null) {
                        return Mono.just(res.getValue());
                    } else {
                        return Mono.empty();
                    }
                });
    }

    /**
     * Invoke action addKey.
     *
     * @param servicePrincipalId key: id of servicePrincipal.
     * @param body Action parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return keyCredential.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public MicrosoftGraphKeyCredentialInner addKey(
        String servicePrincipalId, ServicePrincipalsAddKeyRequestBodyInner body) {
        return addKeyAsync(servicePrincipalId, body).block();
    }

    /**
     * Invoke action addKey.
     *
     * @param servicePrincipalId key: id of servicePrincipal.
     * @param body Action parameters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return keyCredential along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<MicrosoftGraphKeyCredentialInner> addKeyWithResponse(
        String servicePrincipalId, ServicePrincipalsAddKeyRequestBodyInner body, Context context) {
        return addKeyWithResponseAsync(servicePrincipalId, body, context).block();
    }

    /**
     * Invoke action addPassword.
     *
     * @param servicePrincipalId key: id of servicePrincipal.
     * @param body Action parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return passwordCredential along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<MicrosoftGraphPasswordCredentialInner>> addPasswordWithResponseAsync(
        String servicePrincipalId, ServicePrincipalsAddPasswordRequestBodyInner body) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (servicePrincipalId == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter servicePrincipalId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error(new IllegalArgumentException("Parameter body is required and cannot be null."));
        } else {
            body.validate();
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context -> service.addPassword(this.client.getEndpoint(), servicePrincipalId, body, accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Invoke action addPassword.
     *
     * @param servicePrincipalId key: id of servicePrincipal.
     * @param body Action parameters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return passwordCredential along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<MicrosoftGraphPasswordCredentialInner>> addPasswordWithResponseAsync(
        String servicePrincipalId, ServicePrincipalsAddPasswordRequestBodyInner body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (servicePrincipalId == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter servicePrincipalId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error(new IllegalArgumentException("Parameter body is required and cannot be null."));
        } else {
            body.validate();
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.addPassword(this.client.getEndpoint(), servicePrincipalId, body, accept, context);
    }

    /**
     * Invoke action addPassword.
     *
     * @param servicePrincipalId key: id of servicePrincipal.
     * @param body Action parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return passwordCredential on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<MicrosoftGraphPasswordCredentialInner> addPasswordAsync(
        String servicePrincipalId, ServicePrincipalsAddPasswordRequestBodyInner body) {
        return addPasswordWithResponseAsync(servicePrincipalId, body)
            .flatMap(
                (Response<MicrosoftGraphPasswordCredentialInner> res) -> {
                    if (res.getValue() != null) {
                        return Mono.just(res.getValue());
                    } else {
                        return Mono.empty();
                    }
                });
    }

    /**
     * Invoke action addPassword.
     *
     * @param servicePrincipalId key: id of servicePrincipal.
     * @param body Action parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return passwordCredential.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public MicrosoftGraphPasswordCredentialInner addPassword(
        String servicePrincipalId, ServicePrincipalsAddPasswordRequestBodyInner body) {
        return addPasswordAsync(servicePrincipalId, body).block();
    }

    /**
     * Invoke action addPassword.
     *
     * @param servicePrincipalId key: id of servicePrincipal.
     * @param body Action parameters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return passwordCredential along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<MicrosoftGraphPasswordCredentialInner> addPasswordWithResponse(
        String servicePrincipalId, ServicePrincipalsAddPasswordRequestBodyInner body, Context context) {
        return addPasswordWithResponseAsync(servicePrincipalId, body, context).block();
    }
}
