// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashMap;
import java.util.Map;

/** The ApplicationsGetMemberObjectsRequestBody model. */
@Fluent
public final class ApplicationsGetMemberObjectsRequestBody {
    /*
     * The securityEnabledOnly property.
     */
    @JsonProperty(value = "securityEnabledOnly")
    private Boolean securityEnabledOnly;

    /*
     * Dictionary of <AnyObject>
     */
    @JsonIgnore private Map<String, Object> additionalProperties;

    /** Creates an instance of ApplicationsGetMemberObjectsRequestBody class. */
    public ApplicationsGetMemberObjectsRequestBody() {
    }

    /**
     * Get the securityEnabledOnly property: The securityEnabledOnly property.
     *
     * @return the securityEnabledOnly value.
     */
    public Boolean securityEnabledOnly() {
        return this.securityEnabledOnly;
    }

    /**
     * Set the securityEnabledOnly property: The securityEnabledOnly property.
     *
     * @param securityEnabledOnly the securityEnabledOnly value to set.
     * @return the ApplicationsGetMemberObjectsRequestBody object itself.
     */
    public ApplicationsGetMemberObjectsRequestBody withSecurityEnabledOnly(Boolean securityEnabledOnly) {
        this.securityEnabledOnly = securityEnabledOnly;
        return this;
    }

    /**
     * Get the additionalProperties property: Dictionary of &lt;AnyObject&gt;.
     *
     * @return the additionalProperties value.
     */
    @JsonAnyGetter
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: Dictionary of &lt;AnyObject&gt;.
     *
     * @param additionalProperties the additionalProperties value to set.
     * @return the ApplicationsGetMemberObjectsRequestBody object itself.
     */
    public ApplicationsGetMemberObjectsRequestBody withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @JsonAnySetter
    void withAdditionalProperties(String key, Object value) {
        if (additionalProperties == null) {
            additionalProperties = new HashMap<>();
        }
        additionalProperties.put(key, value);
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
