// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/** post. */
@Fluent
public final class MicrosoftGraphPost extends MicrosoftGraphOutlookItem {
    /*
     * itemBody
     */
    @JsonProperty(value = "body")
    private MicrosoftGraphItemBody body;

    /*
     * Unique ID of the conversation. Read-only.
     */
    @JsonProperty(value = "conversationId")
    private String conversationId;

    /*
     * Unique ID of the conversation thread. Read-only.
     */
    @JsonProperty(value = "conversationThreadId")
    private String conversationThreadId;

    /*
     * recipient
     */
    @JsonProperty(value = "from")
    private MicrosoftGraphRecipient from;

    /*
     * Indicates whether the post has at least one attachment. This is a default property.
     */
    @JsonProperty(value = "hasAttachments")
    private Boolean hasAttachments;

    /*
     * Conversation participants that were added to the thread as part of this post.
     */
    @JsonProperty(value = "newParticipants")
    private List<MicrosoftGraphRecipient> newParticipants;

    /*
     * Specifies when the post was received. The DateTimeOffset type represents date and time information using ISO
     * 8601 format and is always in UTC time. For example, midnight UTC on Jan 1, 2014 would look like this:
     * '2014-01-01T00:00:00Z'
     */
    @JsonProperty(value = "receivedDateTime")
    private OffsetDateTime receivedDateTime;

    /*
     * recipient
     */
    @JsonProperty(value = "sender")
    private MicrosoftGraphRecipient sender;

    /*
     * Read-only. Nullable.
     */
    @JsonProperty(value = "attachments")
    private List<MicrosoftGraphAttachment> attachments;

    /*
     * The collection of open extensions defined for the post. Read-only. Nullable.
     */
    @JsonProperty(value = "extensions")
    private List<MicrosoftGraphExtension> extensions;

    /*
     * post
     */
    @JsonProperty(value = "inReplyTo")
    private MicrosoftGraphPost inReplyTo;

    /*
     * The collection of multi-value extended properties defined for the post. Read-only. Nullable.
     */
    @JsonProperty(value = "multiValueExtendedProperties")
    private List<MicrosoftGraphMultiValueLegacyExtendedProperty> multiValueExtendedProperties;

    /*
     * The collection of single-value extended properties defined for the post. Read-only. Nullable.
     */
    @JsonProperty(value = "singleValueExtendedProperties")
    private List<MicrosoftGraphSingleValueLegacyExtendedProperty> singleValueExtendedProperties;

    /*
     * post
     */
    @JsonIgnore private Map<String, Object> additionalProperties;

    /** Creates an instance of MicrosoftGraphPost class. */
    public MicrosoftGraphPost() {
    }

    /**
     * Get the body property: itemBody.
     *
     * @return the body value.
     */
    public MicrosoftGraphItemBody body() {
        return this.body;
    }

    /**
     * Set the body property: itemBody.
     *
     * @param body the body value to set.
     * @return the MicrosoftGraphPost object itself.
     */
    public MicrosoftGraphPost withBody(MicrosoftGraphItemBody body) {
        this.body = body;
        return this;
    }

    /**
     * Get the conversationId property: Unique ID of the conversation. Read-only.
     *
     * @return the conversationId value.
     */
    public String conversationId() {
        return this.conversationId;
    }

    /**
     * Set the conversationId property: Unique ID of the conversation. Read-only.
     *
     * @param conversationId the conversationId value to set.
     * @return the MicrosoftGraphPost object itself.
     */
    public MicrosoftGraphPost withConversationId(String conversationId) {
        this.conversationId = conversationId;
        return this;
    }

    /**
     * Get the conversationThreadId property: Unique ID of the conversation thread. Read-only.
     *
     * @return the conversationThreadId value.
     */
    public String conversationThreadId() {
        return this.conversationThreadId;
    }

    /**
     * Set the conversationThreadId property: Unique ID of the conversation thread. Read-only.
     *
     * @param conversationThreadId the conversationThreadId value to set.
     * @return the MicrosoftGraphPost object itself.
     */
    public MicrosoftGraphPost withConversationThreadId(String conversationThreadId) {
        this.conversationThreadId = conversationThreadId;
        return this;
    }

    /**
     * Get the from property: recipient.
     *
     * @return the from value.
     */
    public MicrosoftGraphRecipient from() {
        return this.from;
    }

    /**
     * Set the from property: recipient.
     *
     * @param from the from value to set.
     * @return the MicrosoftGraphPost object itself.
     */
    public MicrosoftGraphPost withFrom(MicrosoftGraphRecipient from) {
        this.from = from;
        return this;
    }

    /**
     * Get the hasAttachments property: Indicates whether the post has at least one attachment. This is a default
     * property.
     *
     * @return the hasAttachments value.
     */
    public Boolean hasAttachments() {
        return this.hasAttachments;
    }

    /**
     * Set the hasAttachments property: Indicates whether the post has at least one attachment. This is a default
     * property.
     *
     * @param hasAttachments the hasAttachments value to set.
     * @return the MicrosoftGraphPost object itself.
     */
    public MicrosoftGraphPost withHasAttachments(Boolean hasAttachments) {
        this.hasAttachments = hasAttachments;
        return this;
    }

    /**
     * Get the newParticipants property: Conversation participants that were added to the thread as part of this post.
     *
     * @return the newParticipants value.
     */
    public List<MicrosoftGraphRecipient> newParticipants() {
        return this.newParticipants;
    }

    /**
     * Set the newParticipants property: Conversation participants that were added to the thread as part of this post.
     *
     * @param newParticipants the newParticipants value to set.
     * @return the MicrosoftGraphPost object itself.
     */
    public MicrosoftGraphPost withNewParticipants(List<MicrosoftGraphRecipient> newParticipants) {
        this.newParticipants = newParticipants;
        return this;
    }

    /**
     * Get the receivedDateTime property: Specifies when the post was received. The DateTimeOffset type represents date
     * and time information using ISO 8601 format and is always in UTC time. For example, midnight UTC on Jan 1, 2014
     * would look like this: '2014-01-01T00:00:00Z'.
     *
     * @return the receivedDateTime value.
     */
    public OffsetDateTime receivedDateTime() {
        return this.receivedDateTime;
    }

    /**
     * Set the receivedDateTime property: Specifies when the post was received. The DateTimeOffset type represents date
     * and time information using ISO 8601 format and is always in UTC time. For example, midnight UTC on Jan 1, 2014
     * would look like this: '2014-01-01T00:00:00Z'.
     *
     * @param receivedDateTime the receivedDateTime value to set.
     * @return the MicrosoftGraphPost object itself.
     */
    public MicrosoftGraphPost withReceivedDateTime(OffsetDateTime receivedDateTime) {
        this.receivedDateTime = receivedDateTime;
        return this;
    }

    /**
     * Get the sender property: recipient.
     *
     * @return the sender value.
     */
    public MicrosoftGraphRecipient sender() {
        return this.sender;
    }

    /**
     * Set the sender property: recipient.
     *
     * @param sender the sender value to set.
     * @return the MicrosoftGraphPost object itself.
     */
    public MicrosoftGraphPost withSender(MicrosoftGraphRecipient sender) {
        this.sender = sender;
        return this;
    }

    /**
     * Get the attachments property: Read-only. Nullable.
     *
     * @return the attachments value.
     */
    public List<MicrosoftGraphAttachment> attachments() {
        return this.attachments;
    }

    /**
     * Set the attachments property: Read-only. Nullable.
     *
     * @param attachments the attachments value to set.
     * @return the MicrosoftGraphPost object itself.
     */
    public MicrosoftGraphPost withAttachments(List<MicrosoftGraphAttachment> attachments) {
        this.attachments = attachments;
        return this;
    }

    /**
     * Get the extensions property: The collection of open extensions defined for the post. Read-only. Nullable.
     *
     * @return the extensions value.
     */
    public List<MicrosoftGraphExtension> extensions() {
        return this.extensions;
    }

    /**
     * Set the extensions property: The collection of open extensions defined for the post. Read-only. Nullable.
     *
     * @param extensions the extensions value to set.
     * @return the MicrosoftGraphPost object itself.
     */
    public MicrosoftGraphPost withExtensions(List<MicrosoftGraphExtension> extensions) {
        this.extensions = extensions;
        return this;
    }

    /**
     * Get the inReplyTo property: post.
     *
     * @return the inReplyTo value.
     */
    public MicrosoftGraphPost inReplyTo() {
        return this.inReplyTo;
    }

    /**
     * Set the inReplyTo property: post.
     *
     * @param inReplyTo the inReplyTo value to set.
     * @return the MicrosoftGraphPost object itself.
     */
    public MicrosoftGraphPost withInReplyTo(MicrosoftGraphPost inReplyTo) {
        this.inReplyTo = inReplyTo;
        return this;
    }

    /**
     * Get the multiValueExtendedProperties property: The collection of multi-value extended properties defined for the
     * post. Read-only. Nullable.
     *
     * @return the multiValueExtendedProperties value.
     */
    public List<MicrosoftGraphMultiValueLegacyExtendedProperty> multiValueExtendedProperties() {
        return this.multiValueExtendedProperties;
    }

    /**
     * Set the multiValueExtendedProperties property: The collection of multi-value extended properties defined for the
     * post. Read-only. Nullable.
     *
     * @param multiValueExtendedProperties the multiValueExtendedProperties value to set.
     * @return the MicrosoftGraphPost object itself.
     */
    public MicrosoftGraphPost withMultiValueExtendedProperties(
        List<MicrosoftGraphMultiValueLegacyExtendedProperty> multiValueExtendedProperties) {
        this.multiValueExtendedProperties = multiValueExtendedProperties;
        return this;
    }

    /**
     * Get the singleValueExtendedProperties property: The collection of single-value extended properties defined for
     * the post. Read-only. Nullable.
     *
     * @return the singleValueExtendedProperties value.
     */
    public List<MicrosoftGraphSingleValueLegacyExtendedProperty> singleValueExtendedProperties() {
        return this.singleValueExtendedProperties;
    }

    /**
     * Set the singleValueExtendedProperties property: The collection of single-value extended properties defined for
     * the post. Read-only. Nullable.
     *
     * @param singleValueExtendedProperties the singleValueExtendedProperties value to set.
     * @return the MicrosoftGraphPost object itself.
     */
    public MicrosoftGraphPost withSingleValueExtendedProperties(
        List<MicrosoftGraphSingleValueLegacyExtendedProperty> singleValueExtendedProperties) {
        this.singleValueExtendedProperties = singleValueExtendedProperties;
        return this;
    }

    /**
     * Get the additionalProperties property: post.
     *
     * @return the additionalProperties value.
     */
    @JsonAnyGetter
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: post.
     *
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphPost object itself.
     */
    public MicrosoftGraphPost withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @JsonAnySetter
    void withAdditionalProperties(String key, Object value) {
        if (additionalProperties == null) {
            additionalProperties = new HashMap<>();
        }
        additionalProperties.put(key, value);
    }

    /** {@inheritDoc} */
    @Override
    public MicrosoftGraphPost withCategories(List<String> categories) {
        super.withCategories(categories);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public MicrosoftGraphPost withChangeKey(String changeKey) {
        super.withChangeKey(changeKey);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public MicrosoftGraphPost withCreatedDateTime(OffsetDateTime createdDateTime) {
        super.withCreatedDateTime(createdDateTime);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public MicrosoftGraphPost withLastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
        super.withLastModifiedDateTime(lastModifiedDateTime);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public MicrosoftGraphPost withId(String id) {
        super.withId(id);
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (body() != null) {
            body().validate();
        }
        if (from() != null) {
            from().validate();
        }
        if (newParticipants() != null) {
            newParticipants().forEach(e -> e.validate());
        }
        if (sender() != null) {
            sender().validate();
        }
        if (attachments() != null) {
            attachments().forEach(e -> e.validate());
        }
        if (extensions() != null) {
            extensions().forEach(e -> e.validate());
        }
        if (inReplyTo() != null) {
            inReplyTo().validate();
        }
        if (multiValueExtendedProperties() != null) {
            multiValueExtendedProperties().forEach(e -> e.validate());
        }
        if (singleValueExtendedProperties() != null) {
            singleValueExtendedProperties().forEach(e -> e.validate());
        }
    }
}
