// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashMap;
import java.util.Map;

/** sizeRange. */
@Fluent
public final class MicrosoftGraphSizeRange {
    /*
     * The maximum size (in kilobytes) that an incoming message must have in order for a condition or exception to
     * apply.
     */
    @JsonProperty(value = "maximumSize")
    private Integer maximumSize;

    /*
     * The minimum size (in kilobytes) that an incoming message must have in order for a condition or exception to
     * apply.
     */
    @JsonProperty(value = "minimumSize")
    private Integer minimumSize;

    /*
     * sizeRange
     */
    @JsonIgnore private Map<String, Object> additionalProperties;

    /** Creates an instance of MicrosoftGraphSizeRange class. */
    public MicrosoftGraphSizeRange() {
    }

    /**
     * Get the maximumSize property: The maximum size (in kilobytes) that an incoming message must have in order for a
     * condition or exception to apply.
     *
     * @return the maximumSize value.
     */
    public Integer maximumSize() {
        return this.maximumSize;
    }

    /**
     * Set the maximumSize property: The maximum size (in kilobytes) that an incoming message must have in order for a
     * condition or exception to apply.
     *
     * @param maximumSize the maximumSize value to set.
     * @return the MicrosoftGraphSizeRange object itself.
     */
    public MicrosoftGraphSizeRange withMaximumSize(Integer maximumSize) {
        this.maximumSize = maximumSize;
        return this;
    }

    /**
     * Get the minimumSize property: The minimum size (in kilobytes) that an incoming message must have in order for a
     * condition or exception to apply.
     *
     * @return the minimumSize value.
     */
    public Integer minimumSize() {
        return this.minimumSize;
    }

    /**
     * Set the minimumSize property: The minimum size (in kilobytes) that an incoming message must have in order for a
     * condition or exception to apply.
     *
     * @param minimumSize the minimumSize value to set.
     * @return the MicrosoftGraphSizeRange object itself.
     */
    public MicrosoftGraphSizeRange withMinimumSize(Integer minimumSize) {
        this.minimumSize = minimumSize;
        return this;
    }

    /**
     * Get the additionalProperties property: sizeRange.
     *
     * @return the additionalProperties value.
     */
    @JsonAnyGetter
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: sizeRange.
     *
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphSizeRange object itself.
     */
    public MicrosoftGraphSizeRange withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @JsonAnySetter
    void withAdditionalProperties(String key, Object value) {
        if (additionalProperties == null) {
            additionalProperties = new HashMap<>();
        }
        additionalProperties.put(key, value);
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
