/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.authorization.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.BinaryData;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.authorization.fluent.ApplicationsApplicationsClient;
import com.azure.resourcemanager.authorization.fluent.models.CollectionOfApplication;
import com.azure.resourcemanager.authorization.fluent.models.Get2ItemsItem;
import com.azure.resourcemanager.authorization.fluent.models.Get3ItemsItem;
import com.azure.resourcemanager.authorization.fluent.models.Get6ItemsItem;
import com.azure.resourcemanager.authorization.fluent.models.Get7ItemsItem;
import com.azure.resourcemanager.authorization.fluent.models.Get8ItemsItem;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphApplicationInner;
import com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException;
import com.azure.resourcemanager.authorization.implementation.MicrosoftGraphClientImpl;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class ApplicationsApplicationsClientImpl
implements ApplicationsApplicationsClient {
    private final ApplicationsApplicationsService service;
    private final MicrosoftGraphClientImpl client;

    ApplicationsApplicationsClientImpl(MicrosoftGraphClientImpl client) {
        this.service = (ApplicationsApplicationsService)RestProxy.create(ApplicationsApplicationsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphApplicationInner>> listApplicationSinglePageAsync(String consistencyLevel, Integer top, Integer skip, String search, String filter, Boolean count, List<Get6ItemsItem> orderby, List<Get7ItemsItem> select, List<Get8ItemsItem> expand) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        String orderbyConverted = orderby == null ? null : orderby.stream().map(value -> Objects.toString(value, "")).collect(Collectors.joining(","));
        String selectConverted = select == null ? null : select.stream().map(value -> Objects.toString(value, "")).collect(Collectors.joining(","));
        String expandConverted = expand == null ? null : expand.stream().map(value -> Objects.toString(value, "")).collect(Collectors.joining(","));
        return FluxUtil.withContext(context -> this.service.listApplication(this.client.getEndpoint(), consistencyLevel, top, skip, search, filter, count, orderbyConverted, selectConverted, expandConverted, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfApplication)res.getValue()).value(), ((CollectionOfApplication)res.getValue()).odataNextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphApplicationInner>> listApplicationSinglePageAsync(String consistencyLevel, Integer top, Integer skip, String search, String filter, Boolean count, List<Get6ItemsItem> orderby, List<Get7ItemsItem> select, List<Get8ItemsItem> expand, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        String orderbyConverted = orderby == null ? null : orderby.stream().map(value -> Objects.toString(value, "")).collect(Collectors.joining(","));
        String selectConverted = select == null ? null : select.stream().map(value -> Objects.toString(value, "")).collect(Collectors.joining(","));
        String expandConverted = expand == null ? null : expand.stream().map(value -> Objects.toString(value, "")).collect(Collectors.joining(","));
        context = this.client.mergeContext(context);
        return this.service.listApplication(this.client.getEndpoint(), consistencyLevel, top, skip, search, filter, count, orderbyConverted, selectConverted, expandConverted, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfApplication)res.getValue()).value(), ((CollectionOfApplication)res.getValue()).odataNextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<MicrosoftGraphApplicationInner> listApplicationAsync(String consistencyLevel, Integer top, Integer skip, String search, String filter, Boolean count, List<Get6ItemsItem> orderby, List<Get7ItemsItem> select, List<Get8ItemsItem> expand) {
        return new PagedFlux(() -> this.listApplicationSinglePageAsync(consistencyLevel, top, skip, search, filter, count, orderby, select, expand), nextLink -> this.listMoreSinglePageAsync((String)nextLink));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<MicrosoftGraphApplicationInner> listApplicationAsync() {
        String consistencyLevel = null;
        Integer top = null;
        Integer skip = null;
        String search = null;
        String filter = null;
        Boolean count = null;
        List orderby = null;
        List select = null;
        List expand = null;
        return new PagedFlux(() -> this.listApplicationSinglePageAsync(consistencyLevel, top, skip, search, filter, count, orderby, select, expand), nextLink -> this.listMoreSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<MicrosoftGraphApplicationInner> listApplicationAsync(String consistencyLevel, Integer top, Integer skip, String search, String filter, Boolean count, List<Get6ItemsItem> orderby, List<Get7ItemsItem> select, List<Get8ItemsItem> expand, Context context) {
        return new PagedFlux(() -> this.listApplicationSinglePageAsync(consistencyLevel, top, skip, search, filter, count, orderby, select, expand, context), nextLink -> this.listMoreSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<MicrosoftGraphApplicationInner> listApplication() {
        String consistencyLevel = null;
        Integer top = null;
        Integer skip = null;
        String search = null;
        String filter = null;
        Boolean count = null;
        List<Get6ItemsItem> orderby = null;
        List<Get7ItemsItem> select = null;
        List<Get8ItemsItem> expand = null;
        return new PagedIterable(this.listApplicationAsync(consistencyLevel, top, skip, search, filter, count, orderby, select, expand));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<MicrosoftGraphApplicationInner> listApplication(String consistencyLevel, Integer top, Integer skip, String search, String filter, Boolean count, List<Get6ItemsItem> orderby, List<Get7ItemsItem> select, List<Get8ItemsItem> expand, Context context) {
        return new PagedIterable(this.listApplicationAsync(consistencyLevel, top, skip, search, filter, count, orderby, select, expand, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<MicrosoftGraphApplicationInner>> createApplicationWithResponseAsync(MicrosoftGraphApplicationInner body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createApplication(this.client.getEndpoint(), body, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<MicrosoftGraphApplicationInner>> createApplicationWithResponseAsync(MicrosoftGraphApplicationInner body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.createApplication(this.client.getEndpoint(), body, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<MicrosoftGraphApplicationInner> createApplicationAsync(MicrosoftGraphApplicationInner body) {
        return this.createApplicationWithResponseAsync(body).flatMap(res -> Mono.justOrEmpty((Object)((MicrosoftGraphApplicationInner)res.getValue())));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<MicrosoftGraphApplicationInner> createApplicationWithResponse(MicrosoftGraphApplicationInner body, Context context) {
        return (Response)this.createApplicationWithResponseAsync(body, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public MicrosoftGraphApplicationInner createApplication(MicrosoftGraphApplicationInner body) {
        return (MicrosoftGraphApplicationInner)this.createApplicationWithResponse(body, Context.NONE).getValue();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<MicrosoftGraphApplicationInner>> getApplicationWithResponseAsync(String applicationId, String consistencyLevel, List<Get2ItemsItem> select, List<Get3ItemsItem> expand) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (applicationId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter applicationId is required and cannot be null."));
        }
        String accept = "application/json";
        String selectConverted = select == null ? null : select.stream().map(value -> Objects.toString(value, "")).collect(Collectors.joining(","));
        String expandConverted = expand == null ? null : expand.stream().map(value -> Objects.toString(value, "")).collect(Collectors.joining(","));
        return FluxUtil.withContext(context -> this.service.getApplication(this.client.getEndpoint(), applicationId, consistencyLevel, selectConverted, expandConverted, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<MicrosoftGraphApplicationInner>> getApplicationWithResponseAsync(String applicationId, String consistencyLevel, List<Get2ItemsItem> select, List<Get3ItemsItem> expand, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (applicationId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter applicationId is required and cannot be null."));
        }
        String accept = "application/json";
        String selectConverted = select == null ? null : select.stream().map(value -> Objects.toString(value, "")).collect(Collectors.joining(","));
        String expandConverted = expand == null ? null : expand.stream().map(value -> Objects.toString(value, "")).collect(Collectors.joining(","));
        context = this.client.mergeContext(context);
        return this.service.getApplication(this.client.getEndpoint(), applicationId, consistencyLevel, selectConverted, expandConverted, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<MicrosoftGraphApplicationInner> getApplicationAsync(String applicationId) {
        String consistencyLevel = null;
        List<Get2ItemsItem> select = null;
        List<Get3ItemsItem> expand = null;
        return this.getApplicationWithResponseAsync(applicationId, consistencyLevel, select, expand).flatMap(res -> Mono.justOrEmpty((Object)((MicrosoftGraphApplicationInner)res.getValue())));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<MicrosoftGraphApplicationInner> getApplicationWithResponse(String applicationId, String consistencyLevel, List<Get2ItemsItem> select, List<Get3ItemsItem> expand, Context context) {
        return (Response)this.getApplicationWithResponseAsync(applicationId, consistencyLevel, select, expand, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public MicrosoftGraphApplicationInner getApplication(String applicationId) {
        String consistencyLevel = null;
        List<Get2ItemsItem> select = null;
        List<Get3ItemsItem> expand = null;
        return (MicrosoftGraphApplicationInner)this.getApplicationWithResponse(applicationId, consistencyLevel, select, expand, Context.NONE).getValue();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> updateApplicationWithResponseAsync(String applicationId, MicrosoftGraphApplicationInner body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (applicationId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter applicationId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.updateApplication(this.client.getEndpoint(), applicationId, body, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> updateApplicationWithResponseAsync(String applicationId, MicrosoftGraphApplicationInner body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (applicationId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter applicationId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.updateApplication(this.client.getEndpoint(), applicationId, body, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> updateApplicationAsync(String applicationId, MicrosoftGraphApplicationInner body) {
        return this.updateApplicationWithResponseAsync(applicationId, body).flatMap(ignored -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> updateApplicationWithResponse(String applicationId, MicrosoftGraphApplicationInner body, Context context) {
        return (Response)this.updateApplicationWithResponseAsync(applicationId, body, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void updateApplication(String applicationId, MicrosoftGraphApplicationInner body) {
        this.updateApplicationWithResponse(applicationId, body, Context.NONE);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteApplicationWithResponseAsync(String applicationId, String ifMatch) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (applicationId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter applicationId is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.deleteApplication(this.client.getEndpoint(), applicationId, ifMatch, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> deleteApplicationWithResponseAsync(String applicationId, String ifMatch, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (applicationId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter applicationId is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.deleteApplication(this.client.getEndpoint(), applicationId, ifMatch, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteApplicationAsync(String applicationId) {
        String ifMatch = null;
        return this.deleteApplicationWithResponseAsync(applicationId, ifMatch).flatMap(ignored -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteApplicationWithResponse(String applicationId, String ifMatch, Context context) {
        return (Response)this.deleteApplicationWithResponseAsync(applicationId, ifMatch, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deleteApplication(String applicationId) {
        String ifMatch = null;
        this.deleteApplicationWithResponse(applicationId, ifMatch, Context.NONE);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getLogoWithResponseAsync(String applicationId) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (applicationId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter applicationId is required and cannot be null."));
        }
        String accept = "application/octet-stream, application/json";
        return FluxUtil.withContext(context -> this.service.getLogo(this.client.getEndpoint(), applicationId, "application/octet-stream, application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<BinaryData>> getLogoWithResponseAsync(String applicationId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (applicationId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter applicationId is required and cannot be null."));
        }
        String accept = "application/octet-stream, application/json";
        context = this.client.mergeContext(context);
        return this.service.getLogo(this.client.getEndpoint(), applicationId, "application/octet-stream, application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<BinaryData> getLogoAsync(String applicationId) {
        return this.getLogoWithResponseAsync(applicationId).flatMap(res -> Mono.justOrEmpty((Object)((BinaryData)res.getValue())));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getLogoWithResponse(String applicationId, Context context) {
        return (Response)this.getLogoWithResponseAsync(applicationId, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public BinaryData getLogo(String applicationId) {
        return (BinaryData)this.getLogoWithResponse(applicationId, Context.NONE).getValue();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> setLogoWithResponseAsync(String applicationId, Flux<ByteBuffer> data, long contentLength) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (applicationId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter applicationId is required and cannot be null."));
        }
        if (data == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter data is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.setLogo(this.client.getEndpoint(), applicationId, data, contentLength, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> setLogoWithResponseAsync(String applicationId, Flux<ByteBuffer> data, long contentLength, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (applicationId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter applicationId is required and cannot be null."));
        }
        if (data == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter data is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.setLogo(this.client.getEndpoint(), applicationId, data, contentLength, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> setLogoAsync(String applicationId, Flux<ByteBuffer> data, long contentLength) {
        return this.setLogoWithResponseAsync(applicationId, data, contentLength).flatMap(ignored -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> setLogoWithResponse(String applicationId, Flux<ByteBuffer> data, long contentLength, Context context) {
        return (Response)this.setLogoWithResponseAsync(applicationId, data, contentLength, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void setLogo(String applicationId, Flux<ByteBuffer> data, long contentLength) {
        this.setLogoWithResponse(applicationId, data, contentLength, Context.NONE);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> setLogoWithResponseAsync(String applicationId, BinaryData data, long contentLength) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (applicationId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter applicationId is required and cannot be null."));
        }
        if (data == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter data is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.setLogo(this.client.getEndpoint(), applicationId, data, contentLength, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> setLogoWithResponseAsync(String applicationId, BinaryData data, long contentLength, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (applicationId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter applicationId is required and cannot be null."));
        }
        if (data == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter data is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.setLogo(this.client.getEndpoint(), applicationId, data, contentLength, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> setLogoAsync(String applicationId, BinaryData data, long contentLength) {
        return this.setLogoWithResponseAsync(applicationId, data, contentLength).flatMap(ignored -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> setLogoWithResponse(String applicationId, BinaryData data, long contentLength, Context context) {
        return (Response)this.setLogoWithResponseAsync(applicationId, data, contentLength, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void setLogo(String applicationId, BinaryData data, long contentLength) {
        this.setLogoWithResponse(applicationId, data, contentLength, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphApplicationInner>> listMoreSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.listMore(nextLink, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfApplication)res.getValue()).value(), ((CollectionOfApplication)res.getValue()).odataNextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphApplicationInner>> listMoreSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.listMore(nextLink, context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfApplication)res.getValue()).value(), ((CollectionOfApplication)res.getValue()).odataNextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="MicrosoftGraphClient")
    public static interface ApplicationsApplicationsService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/applications")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<CollectionOfApplication>> listApplication(@HostParam(value="$host") String var1, @HeaderParam(value="ConsistencyLevel") String var2, @QueryParam(value="$top") Integer var3, @QueryParam(value="$skip") Integer var4, @QueryParam(value="$search") String var5, @QueryParam(value="$filter") String var6, @QueryParam(value="$count") Boolean var7, @QueryParam(value="$orderby") String var8, @QueryParam(value="$select") String var9, @QueryParam(value="$expand") String var10, @HeaderParam(value="Accept") String var11, Context var12);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/applications")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<MicrosoftGraphApplicationInner>> createApplication(@HostParam(value="$host") String var1, @BodyParam(value="application/json") MicrosoftGraphApplicationInner var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/applications/{application-id}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<MicrosoftGraphApplicationInner>> getApplication(@HostParam(value="$host") String var1, @PathParam(value="application-id") String var2, @HeaderParam(value="ConsistencyLevel") String var3, @QueryParam(value="$select") String var4, @QueryParam(value="$expand") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Patch(value="/applications/{application-id}")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<Void>> updateApplication(@HostParam(value="$host") String var1, @PathParam(value="application-id") String var2, @BodyParam(value="application/json") MicrosoftGraphApplicationInner var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/applications/{application-id}")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<Void>> deleteApplication(@HostParam(value="$host") String var1, @PathParam(value="application-id") String var2, @HeaderParam(value="If-Match") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/applications/{application-id}/logo")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<BinaryData>> getLogo(@HostParam(value="$host") String var1, @PathParam(value="application-id") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/octet-stream"})
        @Put(value="/applications/{application-id}/logo")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<Void>> setLogo(@HostParam(value="$host") String var1, @PathParam(value="application-id") String var2, @BodyParam(value="application/octet-stream") Flux<ByteBuffer> var3, @HeaderParam(value="Content-Length") long var4, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/octet-stream"})
        @Put(value="/applications/{application-id}/logo")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<Void>> setLogo(@HostParam(value="$host") String var1, @PathParam(value="application-id") String var2, @BodyParam(value="application/octet-stream") BinaryData var3, @HeaderParam(value="Content-Length") long var4, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<CollectionOfApplication>> listMore(@PathParam(value="nextLink", encoded=true) String var1, Context var2);
    }
}

