/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.authorization.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.CollectionFormat;
import com.azure.core.util.serializer.JacksonAdapter;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.authorization.fluent.ContactsClient;
import com.azure.resourcemanager.authorization.fluent.models.CollectionOfDirectoryObject0AutoGenerated2;
import com.azure.resourcemanager.authorization.fluent.models.CollectionOfDirectoryObject1AutoGenerated2;
import com.azure.resourcemanager.authorization.fluent.models.CollectionOfDirectoryObjectAutoGenerated2;
import com.azure.resourcemanager.authorization.fluent.models.CollectionOfLinksOfDirectoryObject0AutoGenerated2;
import com.azure.resourcemanager.authorization.fluent.models.CollectionOfLinksOfDirectoryObject1AutoGenerated2;
import com.azure.resourcemanager.authorization.fluent.models.CollectionOfLinksOfDirectoryObjectAutoGenerated2;
import com.azure.resourcemanager.authorization.fluent.models.ContactsCheckMemberGroupsRequestBody;
import com.azure.resourcemanager.authorization.fluent.models.ContactsCheckMemberObjectsRequestBody;
import com.azure.resourcemanager.authorization.fluent.models.ContactsGetAvailableExtensionPropertiesRequestBody;
import com.azure.resourcemanager.authorization.fluent.models.ContactsGetByIdsRequestBody;
import com.azure.resourcemanager.authorization.fluent.models.ContactsGetMemberGroupsRequestBody;
import com.azure.resourcemanager.authorization.fluent.models.ContactsGetMemberObjectsRequestBody;
import com.azure.resourcemanager.authorization.fluent.models.ContactsOrderby;
import com.azure.resourcemanager.authorization.fluent.models.ContactsSelect;
import com.azure.resourcemanager.authorization.fluent.models.ContactsValidatePropertiesRequestBody;
import com.azure.resourcemanager.authorization.fluent.models.Get1ItemsItem;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphDirectoryObjectInner;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphExtensionPropertyInner;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphOrgContactInner;
import com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException;
import com.azure.resourcemanager.authorization.implementation.MicrosoftGraphClientImpl;
import java.util.List;
import java.util.Map;
import reactor.core.publisher.Mono;

public final class ContactsClientImpl
implements ContactsClient {
    private final ClientLogger logger = new ClientLogger(ContactsClientImpl.class);
    private final ContactsService service;
    private final MicrosoftGraphClientImpl client;

    ContactsClientImpl(MicrosoftGraphClientImpl client) {
        this.service = (ContactsService)RestProxy.create(ContactsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    private Mono<PagedResponse<MicrosoftGraphDirectoryObjectInner>> listDirectReportsSinglePageAsync(String orgContactId, Integer top, Integer skip, String search, String filter, Boolean count, List<ContactsOrderby> orderby, List<ContactsSelect> select, List<String> expand) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (orgContactId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter orgContactId is required and cannot be null."));
        }
        String accept = "application/json";
        String orderbyConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        String selectConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        return FluxUtil.withContext(context -> this.service.listDirectReports(this.client.getEndpoint(), orgContactId, top, skip, search, filter, count, orderbyConverted, selectConverted, expandConverted, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfDirectoryObjectAutoGenerated2)res.getValue()).value(), ((CollectionOfDirectoryObjectAutoGenerated2)res.getValue()).odataNextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<MicrosoftGraphDirectoryObjectInner>> listDirectReportsSinglePageAsync(String orgContactId, Integer top, Integer skip, String search, String filter, Boolean count, List<ContactsOrderby> orderby, List<ContactsSelect> select, List<String> expand, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (orgContactId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter orgContactId is required and cannot be null."));
        }
        String accept = "application/json";
        String orderbyConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        String selectConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        context = this.client.mergeContext(context);
        return this.service.listDirectReports(this.client.getEndpoint(), orgContactId, top, skip, search, filter, count, orderbyConverted, selectConverted, expandConverted, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfDirectoryObjectAutoGenerated2)res.getValue()).value(), ((CollectionOfDirectoryObjectAutoGenerated2)res.getValue()).odataNextLink(), null));
    }

    @Override
    public PagedFlux<MicrosoftGraphDirectoryObjectInner> listDirectReportsAsync(String orgContactId, Integer top, Integer skip, String search, String filter, Boolean count, List<ContactsOrderby> orderby, List<ContactsSelect> select, List<String> expand) {
        return new PagedFlux(() -> this.listDirectReportsSinglePageAsync(orgContactId, top, skip, search, filter, count, orderby, select, expand), nextLink -> this.listMoreSinglePageAsync((String)nextLink));
    }

    @Override
    public PagedFlux<MicrosoftGraphDirectoryObjectInner> listDirectReportsAsync(String orgContactId) {
        Integer top = null;
        Integer skip = null;
        String search = null;
        String filter = null;
        Boolean count = null;
        List orderby = null;
        List select = null;
        List expand = null;
        return new PagedFlux(() -> this.listDirectReportsSinglePageAsync(orgContactId, top, skip, search, filter, count, orderby, select, expand), nextLink -> this.listMoreSinglePageAsync((String)nextLink));
    }

    private PagedFlux<MicrosoftGraphDirectoryObjectInner> listDirectReportsAsync(String orgContactId, Integer top, Integer skip, String search, String filter, Boolean count, List<ContactsOrderby> orderby, List<ContactsSelect> select, List<String> expand, Context context) {
        return new PagedFlux(() -> this.listDirectReportsSinglePageAsync(orgContactId, top, skip, search, filter, count, orderby, select, expand, context), nextLink -> this.listMoreSinglePageAsync((String)nextLink, context));
    }

    @Override
    public PagedIterable<MicrosoftGraphDirectoryObjectInner> listDirectReports(String orgContactId) {
        Integer top = null;
        Integer skip = null;
        String search = null;
        String filter = null;
        Boolean count = null;
        List<ContactsOrderby> orderby = null;
        List<ContactsSelect> select = null;
        List<String> expand = null;
        return new PagedIterable(this.listDirectReportsAsync(orgContactId, top, skip, search, filter, count, orderby, select, expand));
    }

    @Override
    public PagedIterable<MicrosoftGraphDirectoryObjectInner> listDirectReports(String orgContactId, Integer top, Integer skip, String search, String filter, Boolean count, List<ContactsOrderby> orderby, List<ContactsSelect> select, List<String> expand, Context context) {
        return new PagedIterable(this.listDirectReportsAsync(orgContactId, top, skip, search, filter, count, orderby, select, expand, context));
    }

    private Mono<PagedResponse<String>> listRefDirectReportsSinglePageAsync(String orgContactId, Integer top, Integer skip, String search, String filter, Boolean count, List<ContactsOrderby> orderby) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (orgContactId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter orgContactId is required and cannot be null."));
        }
        String accept = "application/json";
        String orderbyConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        return FluxUtil.withContext(context -> this.service.listRefDirectReports(this.client.getEndpoint(), orgContactId, top, skip, search, filter, count, orderbyConverted, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfLinksOfDirectoryObjectAutoGenerated2)res.getValue()).value(), ((CollectionOfLinksOfDirectoryObjectAutoGenerated2)res.getValue()).odataNextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<String>> listRefDirectReportsSinglePageAsync(String orgContactId, Integer top, Integer skip, String search, String filter, Boolean count, List<ContactsOrderby> orderby, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (orgContactId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter orgContactId is required and cannot be null."));
        }
        String accept = "application/json";
        String orderbyConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        context = this.client.mergeContext(context);
        return this.service.listRefDirectReports(this.client.getEndpoint(), orgContactId, top, skip, search, filter, count, orderbyConverted, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfLinksOfDirectoryObjectAutoGenerated2)res.getValue()).value(), ((CollectionOfLinksOfDirectoryObjectAutoGenerated2)res.getValue()).odataNextLink(), null));
    }

    @Override
    public PagedFlux<String> listRefDirectReportsAsync(String orgContactId, Integer top, Integer skip, String search, String filter, Boolean count, List<ContactsOrderby> orderby) {
        return new PagedFlux(() -> this.listRefDirectReportsSinglePageAsync(orgContactId, top, skip, search, filter, count, orderby), nextLink -> this.listRefDirectReportsNextSinglePageAsync((String)nextLink));
    }

    @Override
    public PagedFlux<String> listRefDirectReportsAsync(String orgContactId) {
        Integer top = null;
        Integer skip = null;
        String search = null;
        String filter = null;
        Boolean count = null;
        List orderby = null;
        return new PagedFlux(() -> this.listRefDirectReportsSinglePageAsync(orgContactId, top, skip, search, filter, count, orderby), nextLink -> this.listRefDirectReportsNextSinglePageAsync((String)nextLink));
    }

    private PagedFlux<String> listRefDirectReportsAsync(String orgContactId, Integer top, Integer skip, String search, String filter, Boolean count, List<ContactsOrderby> orderby, Context context) {
        return new PagedFlux(() -> this.listRefDirectReportsSinglePageAsync(orgContactId, top, skip, search, filter, count, orderby, context), nextLink -> this.listRefDirectReportsNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    public PagedIterable<String> listRefDirectReports(String orgContactId) {
        Integer top = null;
        Integer skip = null;
        String search = null;
        String filter = null;
        Boolean count = null;
        List<ContactsOrderby> orderby = null;
        return new PagedIterable(this.listRefDirectReportsAsync(orgContactId, top, skip, search, filter, count, orderby));
    }

    @Override
    public PagedIterable<String> listRefDirectReports(String orgContactId, Integer top, Integer skip, String search, String filter, Boolean count, List<ContactsOrderby> orderby, Context context) {
        return new PagedIterable(this.listRefDirectReportsAsync(orgContactId, top, skip, search, filter, count, orderby, context));
    }

    @Override
    public Mono<Response<Map<String, Object>>> createRefDirectReportsWithResponseAsync(String orgContactId, Map<String, Object> body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (orgContactId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter orgContactId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createRefDirectReports(this.client.getEndpoint(), orgContactId, body, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<Map<String, Object>>> createRefDirectReportsWithResponseAsync(String orgContactId, Map<String, Object> body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (orgContactId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter orgContactId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.createRefDirectReports(this.client.getEndpoint(), orgContactId, body, "application/json", context);
    }

    @Override
    public Mono<Map<String, Object>> createRefDirectReportsAsync(String orgContactId, Map<String, Object> body) {
        return this.createRefDirectReportsWithResponseAsync(orgContactId, body).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Map)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    public Map<String, Object> createRefDirectReports(String orgContactId, Map<String, Object> body) {
        return (Map)this.createRefDirectReportsAsync(orgContactId, body).block();
    }

    @Override
    public Response<Map<String, Object>> createRefDirectReportsWithResponse(String orgContactId, Map<String, Object> body, Context context) {
        return (Response)this.createRefDirectReportsWithResponseAsync(orgContactId, body, context).block();
    }

    @Override
    public Mono<Response<MicrosoftGraphDirectoryObjectInner>> getManagerWithResponseAsync(String orgContactId, List<Get1ItemsItem> select, List<String> expand) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (orgContactId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter orgContactId is required and cannot be null."));
        }
        String accept = "application/json";
        String selectConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        return FluxUtil.withContext(context -> this.service.getManager(this.client.getEndpoint(), orgContactId, selectConverted, expandConverted, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<MicrosoftGraphDirectoryObjectInner>> getManagerWithResponseAsync(String orgContactId, List<Get1ItemsItem> select, List<String> expand, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (orgContactId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter orgContactId is required and cannot be null."));
        }
        String accept = "application/json";
        String selectConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        context = this.client.mergeContext(context);
        return this.service.getManager(this.client.getEndpoint(), orgContactId, selectConverted, expandConverted, "application/json", context);
    }

    @Override
    public Mono<MicrosoftGraphDirectoryObjectInner> getManagerAsync(String orgContactId, List<Get1ItemsItem> select, List<String> expand) {
        return this.getManagerWithResponseAsync(orgContactId, select, expand).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((MicrosoftGraphDirectoryObjectInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    public Mono<MicrosoftGraphDirectoryObjectInner> getManagerAsync(String orgContactId) {
        List<Get1ItemsItem> select = null;
        List<String> expand = null;
        return this.getManagerWithResponseAsync(orgContactId, select, expand).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((MicrosoftGraphDirectoryObjectInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    public MicrosoftGraphDirectoryObjectInner getManager(String orgContactId) {
        List<Get1ItemsItem> select = null;
        List<String> expand = null;
        return (MicrosoftGraphDirectoryObjectInner)this.getManagerAsync(orgContactId, select, expand).block();
    }

    @Override
    public Response<MicrosoftGraphDirectoryObjectInner> getManagerWithResponse(String orgContactId, List<Get1ItemsItem> select, List<String> expand, Context context) {
        return (Response)this.getManagerWithResponseAsync(orgContactId, select, expand, context).block();
    }

    @Override
    public Mono<Response<String>> getRefManagerWithResponseAsync(String orgContactId) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (orgContactId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter orgContactId is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getRefManager(this.client.getEndpoint(), orgContactId, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<String>> getRefManagerWithResponseAsync(String orgContactId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (orgContactId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter orgContactId is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getRefManager(this.client.getEndpoint(), orgContactId, "application/json", context);
    }

    @Override
    public Mono<String> getRefManagerAsync(String orgContactId) {
        return this.getRefManagerWithResponseAsync(orgContactId).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((String)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    public String getRefManager(String orgContactId) {
        return (String)this.getRefManagerAsync(orgContactId).block();
    }

    @Override
    public Response<String> getRefManagerWithResponse(String orgContactId, Context context) {
        return (Response)this.getRefManagerWithResponseAsync(orgContactId, context).block();
    }

    @Override
    public Mono<Response<Void>> setRefManagerWithResponseAsync(String orgContactId, Map<String, Object> body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (orgContactId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter orgContactId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.setRefManager(this.client.getEndpoint(), orgContactId, body, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<Void>> setRefManagerWithResponseAsync(String orgContactId, Map<String, Object> body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (orgContactId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter orgContactId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.setRefManager(this.client.getEndpoint(), orgContactId, body, "application/json", context);
    }

    @Override
    public Mono<Void> setRefManagerAsync(String orgContactId, Map<String, Object> body) {
        return this.setRefManagerWithResponseAsync(orgContactId, body).flatMap(res -> Mono.empty());
    }

    @Override
    public void setRefManager(String orgContactId, Map<String, Object> body) {
        this.setRefManagerAsync(orgContactId, body).block();
    }

    @Override
    public Response<Void> setRefManagerWithResponse(String orgContactId, Map<String, Object> body, Context context) {
        return (Response)this.setRefManagerWithResponseAsync(orgContactId, body, context).block();
    }

    @Override
    public Mono<Response<Void>> deleteRefManagerWithResponseAsync(String orgContactId, String ifMatch) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (orgContactId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter orgContactId is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.deleteRefManager(this.client.getEndpoint(), orgContactId, ifMatch, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<Void>> deleteRefManagerWithResponseAsync(String orgContactId, String ifMatch, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (orgContactId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter orgContactId is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.deleteRefManager(this.client.getEndpoint(), orgContactId, ifMatch, "application/json", context);
    }

    @Override
    public Mono<Void> deleteRefManagerAsync(String orgContactId, String ifMatch) {
        return this.deleteRefManagerWithResponseAsync(orgContactId, ifMatch).flatMap(res -> Mono.empty());
    }

    @Override
    public Mono<Void> deleteRefManagerAsync(String orgContactId) {
        String ifMatch = null;
        return this.deleteRefManagerWithResponseAsync(orgContactId, ifMatch).flatMap(res -> Mono.empty());
    }

    @Override
    public void deleteRefManager(String orgContactId) {
        String ifMatch = null;
        this.deleteRefManagerAsync(orgContactId, ifMatch).block();
    }

    @Override
    public Response<Void> deleteRefManagerWithResponse(String orgContactId, String ifMatch, Context context) {
        return (Response)this.deleteRefManagerWithResponseAsync(orgContactId, ifMatch, context).block();
    }

    private Mono<PagedResponse<MicrosoftGraphDirectoryObjectInner>> listMemberOfSinglePageAsync(String orgContactId, Integer top, Integer skip, String search, String filter, Boolean count, List<ContactsOrderby> orderby, List<ContactsSelect> select, List<String> expand) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (orgContactId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter orgContactId is required and cannot be null."));
        }
        String accept = "application/json";
        String orderbyConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        String selectConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        return FluxUtil.withContext(context -> this.service.listMemberOf(this.client.getEndpoint(), orgContactId, top, skip, search, filter, count, orderbyConverted, selectConverted, expandConverted, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfDirectoryObject0AutoGenerated2)res.getValue()).value(), ((CollectionOfDirectoryObject0AutoGenerated2)res.getValue()).odataNextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<MicrosoftGraphDirectoryObjectInner>> listMemberOfSinglePageAsync(String orgContactId, Integer top, Integer skip, String search, String filter, Boolean count, List<ContactsOrderby> orderby, List<ContactsSelect> select, List<String> expand, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (orgContactId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter orgContactId is required and cannot be null."));
        }
        String accept = "application/json";
        String orderbyConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        String selectConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        context = this.client.mergeContext(context);
        return this.service.listMemberOf(this.client.getEndpoint(), orgContactId, top, skip, search, filter, count, orderbyConverted, selectConverted, expandConverted, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfDirectoryObject0AutoGenerated2)res.getValue()).value(), ((CollectionOfDirectoryObject0AutoGenerated2)res.getValue()).odataNextLink(), null));
    }

    @Override
    public PagedFlux<MicrosoftGraphDirectoryObjectInner> listMemberOfAsync(String orgContactId, Integer top, Integer skip, String search, String filter, Boolean count, List<ContactsOrderby> orderby, List<ContactsSelect> select, List<String> expand) {
        return new PagedFlux(() -> this.listMemberOfSinglePageAsync(orgContactId, top, skip, search, filter, count, orderby, select, expand), nextLink -> this.listMemberOfNextSinglePageAsync((String)nextLink));
    }

    @Override
    public PagedFlux<MicrosoftGraphDirectoryObjectInner> listMemberOfAsync(String orgContactId) {
        Integer top = null;
        Integer skip = null;
        String search = null;
        String filter = null;
        Boolean count = null;
        List orderby = null;
        List select = null;
        List expand = null;
        return new PagedFlux(() -> this.listMemberOfSinglePageAsync(orgContactId, top, skip, search, filter, count, orderby, select, expand), nextLink -> this.listMemberOfNextSinglePageAsync((String)nextLink));
    }

    private PagedFlux<MicrosoftGraphDirectoryObjectInner> listMemberOfAsync(String orgContactId, Integer top, Integer skip, String search, String filter, Boolean count, List<ContactsOrderby> orderby, List<ContactsSelect> select, List<String> expand, Context context) {
        return new PagedFlux(() -> this.listMemberOfSinglePageAsync(orgContactId, top, skip, search, filter, count, orderby, select, expand, context), nextLink -> this.listMemberOfNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    public PagedIterable<MicrosoftGraphDirectoryObjectInner> listMemberOf(String orgContactId) {
        Integer top = null;
        Integer skip = null;
        String search = null;
        String filter = null;
        Boolean count = null;
        List<ContactsOrderby> orderby = null;
        List<ContactsSelect> select = null;
        List<String> expand = null;
        return new PagedIterable(this.listMemberOfAsync(orgContactId, top, skip, search, filter, count, orderby, select, expand));
    }

    @Override
    public PagedIterable<MicrosoftGraphDirectoryObjectInner> listMemberOf(String orgContactId, Integer top, Integer skip, String search, String filter, Boolean count, List<ContactsOrderby> orderby, List<ContactsSelect> select, List<String> expand, Context context) {
        return new PagedIterable(this.listMemberOfAsync(orgContactId, top, skip, search, filter, count, orderby, select, expand, context));
    }

    private Mono<PagedResponse<String>> listRefMemberOfSinglePageAsync(String orgContactId, Integer top, Integer skip, String search, String filter, Boolean count, List<ContactsOrderby> orderby) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (orgContactId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter orgContactId is required and cannot be null."));
        }
        String accept = "application/json";
        String orderbyConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        return FluxUtil.withContext(context -> this.service.listRefMemberOf(this.client.getEndpoint(), orgContactId, top, skip, search, filter, count, orderbyConverted, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfLinksOfDirectoryObject0AutoGenerated2)res.getValue()).value(), ((CollectionOfLinksOfDirectoryObject0AutoGenerated2)res.getValue()).odataNextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<String>> listRefMemberOfSinglePageAsync(String orgContactId, Integer top, Integer skip, String search, String filter, Boolean count, List<ContactsOrderby> orderby, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (orgContactId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter orgContactId is required and cannot be null."));
        }
        String accept = "application/json";
        String orderbyConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        context = this.client.mergeContext(context);
        return this.service.listRefMemberOf(this.client.getEndpoint(), orgContactId, top, skip, search, filter, count, orderbyConverted, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfLinksOfDirectoryObject0AutoGenerated2)res.getValue()).value(), ((CollectionOfLinksOfDirectoryObject0AutoGenerated2)res.getValue()).odataNextLink(), null));
    }

    @Override
    public PagedFlux<String> listRefMemberOfAsync(String orgContactId, Integer top, Integer skip, String search, String filter, Boolean count, List<ContactsOrderby> orderby) {
        return new PagedFlux(() -> this.listRefMemberOfSinglePageAsync(orgContactId, top, skip, search, filter, count, orderby), nextLink -> this.listRefMemberOfNextSinglePageAsync((String)nextLink));
    }

    @Override
    public PagedFlux<String> listRefMemberOfAsync(String orgContactId) {
        Integer top = null;
        Integer skip = null;
        String search = null;
        String filter = null;
        Boolean count = null;
        List orderby = null;
        return new PagedFlux(() -> this.listRefMemberOfSinglePageAsync(orgContactId, top, skip, search, filter, count, orderby), nextLink -> this.listRefMemberOfNextSinglePageAsync((String)nextLink));
    }

    private PagedFlux<String> listRefMemberOfAsync(String orgContactId, Integer top, Integer skip, String search, String filter, Boolean count, List<ContactsOrderby> orderby, Context context) {
        return new PagedFlux(() -> this.listRefMemberOfSinglePageAsync(orgContactId, top, skip, search, filter, count, orderby, context), nextLink -> this.listRefMemberOfNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    public PagedIterable<String> listRefMemberOf(String orgContactId) {
        Integer top = null;
        Integer skip = null;
        String search = null;
        String filter = null;
        Boolean count = null;
        List<ContactsOrderby> orderby = null;
        return new PagedIterable(this.listRefMemberOfAsync(orgContactId, top, skip, search, filter, count, orderby));
    }

    @Override
    public PagedIterable<String> listRefMemberOf(String orgContactId, Integer top, Integer skip, String search, String filter, Boolean count, List<ContactsOrderby> orderby, Context context) {
        return new PagedIterable(this.listRefMemberOfAsync(orgContactId, top, skip, search, filter, count, orderby, context));
    }

    @Override
    public Mono<Response<Map<String, Object>>> createRefMemberOfWithResponseAsync(String orgContactId, Map<String, Object> body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (orgContactId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter orgContactId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createRefMemberOf(this.client.getEndpoint(), orgContactId, body, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<Map<String, Object>>> createRefMemberOfWithResponseAsync(String orgContactId, Map<String, Object> body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (orgContactId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter orgContactId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.createRefMemberOf(this.client.getEndpoint(), orgContactId, body, "application/json", context);
    }

    @Override
    public Mono<Map<String, Object>> createRefMemberOfAsync(String orgContactId, Map<String, Object> body) {
        return this.createRefMemberOfWithResponseAsync(orgContactId, body).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Map)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    public Map<String, Object> createRefMemberOf(String orgContactId, Map<String, Object> body) {
        return (Map)this.createRefMemberOfAsync(orgContactId, body).block();
    }

    @Override
    public Response<Map<String, Object>> createRefMemberOfWithResponse(String orgContactId, Map<String, Object> body, Context context) {
        return (Response)this.createRefMemberOfWithResponseAsync(orgContactId, body, context).block();
    }

    @Override
    public Mono<Response<List<String>>> checkMemberGroupsWithResponseAsync(String orgContactId, ContactsCheckMemberGroupsRequestBody body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (orgContactId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter orgContactId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.checkMemberGroups(this.client.getEndpoint(), orgContactId, body, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<List<String>>> checkMemberGroupsWithResponseAsync(String orgContactId, ContactsCheckMemberGroupsRequestBody body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (orgContactId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter orgContactId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.checkMemberGroups(this.client.getEndpoint(), orgContactId, body, "application/json", context);
    }

    @Override
    public Mono<List<String>> checkMemberGroupsAsync(String orgContactId, ContactsCheckMemberGroupsRequestBody body) {
        return this.checkMemberGroupsWithResponseAsync(orgContactId, body).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((List)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    public List<String> checkMemberGroups(String orgContactId, ContactsCheckMemberGroupsRequestBody body) {
        return (List)this.checkMemberGroupsAsync(orgContactId, body).block();
    }

    @Override
    public Response<List<String>> checkMemberGroupsWithResponse(String orgContactId, ContactsCheckMemberGroupsRequestBody body, Context context) {
        return (Response)this.checkMemberGroupsWithResponseAsync(orgContactId, body, context).block();
    }

    @Override
    public Mono<Response<List<String>>> checkMemberObjectsWithResponseAsync(String orgContactId, ContactsCheckMemberObjectsRequestBody body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (orgContactId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter orgContactId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.checkMemberObjects(this.client.getEndpoint(), orgContactId, body, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<List<String>>> checkMemberObjectsWithResponseAsync(String orgContactId, ContactsCheckMemberObjectsRequestBody body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (orgContactId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter orgContactId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.checkMemberObjects(this.client.getEndpoint(), orgContactId, body, "application/json", context);
    }

    @Override
    public Mono<List<String>> checkMemberObjectsAsync(String orgContactId, ContactsCheckMemberObjectsRequestBody body) {
        return this.checkMemberObjectsWithResponseAsync(orgContactId, body).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((List)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    public List<String> checkMemberObjects(String orgContactId, ContactsCheckMemberObjectsRequestBody body) {
        return (List)this.checkMemberObjectsAsync(orgContactId, body).block();
    }

    @Override
    public Response<List<String>> checkMemberObjectsWithResponse(String orgContactId, ContactsCheckMemberObjectsRequestBody body, Context context) {
        return (Response)this.checkMemberObjectsWithResponseAsync(orgContactId, body, context).block();
    }

    @Override
    public Mono<Response<List<String>>> getMemberGroupsWithResponseAsync(String orgContactId, ContactsGetMemberGroupsRequestBody body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (orgContactId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter orgContactId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getMemberGroups(this.client.getEndpoint(), orgContactId, body, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<List<String>>> getMemberGroupsWithResponseAsync(String orgContactId, ContactsGetMemberGroupsRequestBody body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (orgContactId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter orgContactId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getMemberGroups(this.client.getEndpoint(), orgContactId, body, "application/json", context);
    }

    @Override
    public Mono<List<String>> getMemberGroupsAsync(String orgContactId, ContactsGetMemberGroupsRequestBody body) {
        return this.getMemberGroupsWithResponseAsync(orgContactId, body).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((List)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    public List<String> getMemberGroups(String orgContactId, ContactsGetMemberGroupsRequestBody body) {
        return (List)this.getMemberGroupsAsync(orgContactId, body).block();
    }

    @Override
    public Response<List<String>> getMemberGroupsWithResponse(String orgContactId, ContactsGetMemberGroupsRequestBody body, Context context) {
        return (Response)this.getMemberGroupsWithResponseAsync(orgContactId, body, context).block();
    }

    @Override
    public Mono<Response<List<String>>> getMemberObjectsWithResponseAsync(String orgContactId, ContactsGetMemberObjectsRequestBody body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (orgContactId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter orgContactId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getMemberObjects(this.client.getEndpoint(), orgContactId, body, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<List<String>>> getMemberObjectsWithResponseAsync(String orgContactId, ContactsGetMemberObjectsRequestBody body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (orgContactId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter orgContactId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getMemberObjects(this.client.getEndpoint(), orgContactId, body, "application/json", context);
    }

    @Override
    public Mono<List<String>> getMemberObjectsAsync(String orgContactId, ContactsGetMemberObjectsRequestBody body) {
        return this.getMemberObjectsWithResponseAsync(orgContactId, body).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((List)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    public List<String> getMemberObjects(String orgContactId, ContactsGetMemberObjectsRequestBody body) {
        return (List)this.getMemberObjectsAsync(orgContactId, body).block();
    }

    @Override
    public Response<List<String>> getMemberObjectsWithResponse(String orgContactId, ContactsGetMemberObjectsRequestBody body, Context context) {
        return (Response)this.getMemberObjectsWithResponseAsync(orgContactId, body, context).block();
    }

    @Override
    public Mono<Response<MicrosoftGraphDirectoryObjectInner>> restoreWithResponseAsync(String orgContactId) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (orgContactId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter orgContactId is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.restore(this.client.getEndpoint(), orgContactId, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<MicrosoftGraphDirectoryObjectInner>> restoreWithResponseAsync(String orgContactId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (orgContactId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter orgContactId is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.restore(this.client.getEndpoint(), orgContactId, "application/json", context);
    }

    @Override
    public Mono<MicrosoftGraphDirectoryObjectInner> restoreAsync(String orgContactId) {
        return this.restoreWithResponseAsync(orgContactId).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((MicrosoftGraphDirectoryObjectInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    public MicrosoftGraphDirectoryObjectInner restore(String orgContactId) {
        return (MicrosoftGraphDirectoryObjectInner)this.restoreAsync(orgContactId).block();
    }

    @Override
    public Response<MicrosoftGraphDirectoryObjectInner> restoreWithResponse(String orgContactId, Context context) {
        return (Response)this.restoreWithResponseAsync(orgContactId, context).block();
    }

    private Mono<PagedResponse<MicrosoftGraphDirectoryObjectInner>> listTransitiveMemberOfSinglePageAsync(String orgContactId, Integer top, Integer skip, String search, String filter, Boolean count, List<ContactsOrderby> orderby, List<ContactsSelect> select, List<String> expand) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (orgContactId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter orgContactId is required and cannot be null."));
        }
        String accept = "application/json";
        String orderbyConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        String selectConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        return FluxUtil.withContext(context -> this.service.listTransitiveMemberOf(this.client.getEndpoint(), orgContactId, top, skip, search, filter, count, orderbyConverted, selectConverted, expandConverted, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfDirectoryObject1AutoGenerated2)res.getValue()).value(), ((CollectionOfDirectoryObject1AutoGenerated2)res.getValue()).odataNextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<MicrosoftGraphDirectoryObjectInner>> listTransitiveMemberOfSinglePageAsync(String orgContactId, Integer top, Integer skip, String search, String filter, Boolean count, List<ContactsOrderby> orderby, List<ContactsSelect> select, List<String> expand, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (orgContactId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter orgContactId is required and cannot be null."));
        }
        String accept = "application/json";
        String orderbyConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        String selectConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        context = this.client.mergeContext(context);
        return this.service.listTransitiveMemberOf(this.client.getEndpoint(), orgContactId, top, skip, search, filter, count, orderbyConverted, selectConverted, expandConverted, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfDirectoryObject1AutoGenerated2)res.getValue()).value(), ((CollectionOfDirectoryObject1AutoGenerated2)res.getValue()).odataNextLink(), null));
    }

    @Override
    public PagedFlux<MicrosoftGraphDirectoryObjectInner> listTransitiveMemberOfAsync(String orgContactId, Integer top, Integer skip, String search, String filter, Boolean count, List<ContactsOrderby> orderby, List<ContactsSelect> select, List<String> expand) {
        return new PagedFlux(() -> this.listTransitiveMemberOfSinglePageAsync(orgContactId, top, skip, search, filter, count, orderby, select, expand), nextLink -> this.listTransitiveMemberOfNextSinglePageAsync((String)nextLink));
    }

    @Override
    public PagedFlux<MicrosoftGraphDirectoryObjectInner> listTransitiveMemberOfAsync(String orgContactId) {
        Integer top = null;
        Integer skip = null;
        String search = null;
        String filter = null;
        Boolean count = null;
        List orderby = null;
        List select = null;
        List expand = null;
        return new PagedFlux(() -> this.listTransitiveMemberOfSinglePageAsync(orgContactId, top, skip, search, filter, count, orderby, select, expand), nextLink -> this.listTransitiveMemberOfNextSinglePageAsync((String)nextLink));
    }

    private PagedFlux<MicrosoftGraphDirectoryObjectInner> listTransitiveMemberOfAsync(String orgContactId, Integer top, Integer skip, String search, String filter, Boolean count, List<ContactsOrderby> orderby, List<ContactsSelect> select, List<String> expand, Context context) {
        return new PagedFlux(() -> this.listTransitiveMemberOfSinglePageAsync(orgContactId, top, skip, search, filter, count, orderby, select, expand, context), nextLink -> this.listTransitiveMemberOfNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    public PagedIterable<MicrosoftGraphDirectoryObjectInner> listTransitiveMemberOf(String orgContactId) {
        Integer top = null;
        Integer skip = null;
        String search = null;
        String filter = null;
        Boolean count = null;
        List<ContactsOrderby> orderby = null;
        List<ContactsSelect> select = null;
        List<String> expand = null;
        return new PagedIterable(this.listTransitiveMemberOfAsync(orgContactId, top, skip, search, filter, count, orderby, select, expand));
    }

    @Override
    public PagedIterable<MicrosoftGraphDirectoryObjectInner> listTransitiveMemberOf(String orgContactId, Integer top, Integer skip, String search, String filter, Boolean count, List<ContactsOrderby> orderby, List<ContactsSelect> select, List<String> expand, Context context) {
        return new PagedIterable(this.listTransitiveMemberOfAsync(orgContactId, top, skip, search, filter, count, orderby, select, expand, context));
    }

    private Mono<PagedResponse<String>> listRefTransitiveMemberOfSinglePageAsync(String orgContactId, Integer top, Integer skip, String search, String filter, Boolean count, List<ContactsOrderby> orderby) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (orgContactId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter orgContactId is required and cannot be null."));
        }
        String accept = "application/json";
        String orderbyConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        return FluxUtil.withContext(context -> this.service.listRefTransitiveMemberOf(this.client.getEndpoint(), orgContactId, top, skip, search, filter, count, orderbyConverted, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfLinksOfDirectoryObject1AutoGenerated2)res.getValue()).value(), ((CollectionOfLinksOfDirectoryObject1AutoGenerated2)res.getValue()).odataNextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<String>> listRefTransitiveMemberOfSinglePageAsync(String orgContactId, Integer top, Integer skip, String search, String filter, Boolean count, List<ContactsOrderby> orderby, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (orgContactId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter orgContactId is required and cannot be null."));
        }
        String accept = "application/json";
        String orderbyConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        context = this.client.mergeContext(context);
        return this.service.listRefTransitiveMemberOf(this.client.getEndpoint(), orgContactId, top, skip, search, filter, count, orderbyConverted, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfLinksOfDirectoryObject1AutoGenerated2)res.getValue()).value(), ((CollectionOfLinksOfDirectoryObject1AutoGenerated2)res.getValue()).odataNextLink(), null));
    }

    @Override
    public PagedFlux<String> listRefTransitiveMemberOfAsync(String orgContactId, Integer top, Integer skip, String search, String filter, Boolean count, List<ContactsOrderby> orderby) {
        return new PagedFlux(() -> this.listRefTransitiveMemberOfSinglePageAsync(orgContactId, top, skip, search, filter, count, orderby), nextLink -> this.listRefTransitiveMemberOfNextSinglePageAsync((String)nextLink));
    }

    @Override
    public PagedFlux<String> listRefTransitiveMemberOfAsync(String orgContactId) {
        Integer top = null;
        Integer skip = null;
        String search = null;
        String filter = null;
        Boolean count = null;
        List orderby = null;
        return new PagedFlux(() -> this.listRefTransitiveMemberOfSinglePageAsync(orgContactId, top, skip, search, filter, count, orderby), nextLink -> this.listRefTransitiveMemberOfNextSinglePageAsync((String)nextLink));
    }

    private PagedFlux<String> listRefTransitiveMemberOfAsync(String orgContactId, Integer top, Integer skip, String search, String filter, Boolean count, List<ContactsOrderby> orderby, Context context) {
        return new PagedFlux(() -> this.listRefTransitiveMemberOfSinglePageAsync(orgContactId, top, skip, search, filter, count, orderby, context), nextLink -> this.listRefTransitiveMemberOfNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    public PagedIterable<String> listRefTransitiveMemberOf(String orgContactId) {
        Integer top = null;
        Integer skip = null;
        String search = null;
        String filter = null;
        Boolean count = null;
        List<ContactsOrderby> orderby = null;
        return new PagedIterable(this.listRefTransitiveMemberOfAsync(orgContactId, top, skip, search, filter, count, orderby));
    }

    @Override
    public PagedIterable<String> listRefTransitiveMemberOf(String orgContactId, Integer top, Integer skip, String search, String filter, Boolean count, List<ContactsOrderby> orderby, Context context) {
        return new PagedIterable(this.listRefTransitiveMemberOfAsync(orgContactId, top, skip, search, filter, count, orderby, context));
    }

    @Override
    public Mono<Response<Map<String, Object>>> createRefTransitiveMemberOfWithResponseAsync(String orgContactId, Map<String, Object> body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (orgContactId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter orgContactId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createRefTransitiveMemberOf(this.client.getEndpoint(), orgContactId, body, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<Map<String, Object>>> createRefTransitiveMemberOfWithResponseAsync(String orgContactId, Map<String, Object> body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (orgContactId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter orgContactId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.createRefTransitiveMemberOf(this.client.getEndpoint(), orgContactId, body, "application/json", context);
    }

    @Override
    public Mono<Map<String, Object>> createRefTransitiveMemberOfAsync(String orgContactId, Map<String, Object> body) {
        return this.createRefTransitiveMemberOfWithResponseAsync(orgContactId, body).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Map)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    public Map<String, Object> createRefTransitiveMemberOf(String orgContactId, Map<String, Object> body) {
        return (Map)this.createRefTransitiveMemberOfAsync(orgContactId, body).block();
    }

    @Override
    public Response<Map<String, Object>> createRefTransitiveMemberOfWithResponse(String orgContactId, Map<String, Object> body, Context context) {
        return (Response)this.createRefTransitiveMemberOfWithResponseAsync(orgContactId, body, context).block();
    }

    @Override
    public Mono<Response<List<MicrosoftGraphOrgContactInner>>> deltaWithResponseAsync() {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.delta(this.client.getEndpoint(), "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<List<MicrosoftGraphOrgContactInner>>> deltaWithResponseAsync(Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.delta(this.client.getEndpoint(), "application/json", context);
    }

    @Override
    public Mono<List<MicrosoftGraphOrgContactInner>> deltaAsync() {
        return this.deltaWithResponseAsync().flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((List)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    public List<MicrosoftGraphOrgContactInner> delta() {
        return (List)this.deltaAsync().block();
    }

    @Override
    public Response<List<MicrosoftGraphOrgContactInner>> deltaWithResponse(Context context) {
        return (Response)this.deltaWithResponseAsync(context).block();
    }

    @Override
    public Mono<Response<List<MicrosoftGraphExtensionPropertyInner>>> getAvailableExtensionPropertiesWithResponseAsync(ContactsGetAvailableExtensionPropertiesRequestBody body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getAvailableExtensionProperties(this.client.getEndpoint(), body, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<List<MicrosoftGraphExtensionPropertyInner>>> getAvailableExtensionPropertiesWithResponseAsync(ContactsGetAvailableExtensionPropertiesRequestBody body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getAvailableExtensionProperties(this.client.getEndpoint(), body, "application/json", context);
    }

    @Override
    public Mono<List<MicrosoftGraphExtensionPropertyInner>> getAvailableExtensionPropertiesAsync(ContactsGetAvailableExtensionPropertiesRequestBody body) {
        return this.getAvailableExtensionPropertiesWithResponseAsync(body).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((List)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    public List<MicrosoftGraphExtensionPropertyInner> getAvailableExtensionProperties(ContactsGetAvailableExtensionPropertiesRequestBody body) {
        return (List)this.getAvailableExtensionPropertiesAsync(body).block();
    }

    @Override
    public Response<List<MicrosoftGraphExtensionPropertyInner>> getAvailableExtensionPropertiesWithResponse(ContactsGetAvailableExtensionPropertiesRequestBody body, Context context) {
        return (Response)this.getAvailableExtensionPropertiesWithResponseAsync(body, context).block();
    }

    @Override
    public Mono<Response<List<MicrosoftGraphDirectoryObjectInner>>> getByIdsWithResponseAsync(ContactsGetByIdsRequestBody body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getByIds(this.client.getEndpoint(), body, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<List<MicrosoftGraphDirectoryObjectInner>>> getByIdsWithResponseAsync(ContactsGetByIdsRequestBody body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getByIds(this.client.getEndpoint(), body, "application/json", context);
    }

    @Override
    public Mono<List<MicrosoftGraphDirectoryObjectInner>> getByIdsAsync(ContactsGetByIdsRequestBody body) {
        return this.getByIdsWithResponseAsync(body).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((List)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    public List<MicrosoftGraphDirectoryObjectInner> getByIds(ContactsGetByIdsRequestBody body) {
        return (List)this.getByIdsAsync(body).block();
    }

    @Override
    public Response<List<MicrosoftGraphDirectoryObjectInner>> getByIdsWithResponse(ContactsGetByIdsRequestBody body, Context context) {
        return (Response)this.getByIdsWithResponseAsync(body, context).block();
    }

    @Override
    public Mono<Response<Void>> validatePropertiesWithResponseAsync(ContactsValidatePropertiesRequestBody body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.validateProperties(this.client.getEndpoint(), body, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<Void>> validatePropertiesWithResponseAsync(ContactsValidatePropertiesRequestBody body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.validateProperties(this.client.getEndpoint(), body, "application/json", context);
    }

    @Override
    public Mono<Void> validatePropertiesAsync(ContactsValidatePropertiesRequestBody body) {
        return this.validatePropertiesWithResponseAsync(body).flatMap(res -> Mono.empty());
    }

    @Override
    public void validateProperties(ContactsValidatePropertiesRequestBody body) {
        this.validatePropertiesAsync(body).block();
    }

    @Override
    public Response<Void> validatePropertiesWithResponse(ContactsValidatePropertiesRequestBody body, Context context) {
        return (Response)this.validatePropertiesWithResponseAsync(body, context).block();
    }

    private Mono<PagedResponse<MicrosoftGraphDirectoryObjectInner>> listMoreSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.listMore(nextLink, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfDirectoryObjectAutoGenerated2)res.getValue()).value(), ((CollectionOfDirectoryObjectAutoGenerated2)res.getValue()).odataNextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<MicrosoftGraphDirectoryObjectInner>> listMoreSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.listMore(nextLink, context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfDirectoryObjectAutoGenerated2)res.getValue()).value(), ((CollectionOfDirectoryObjectAutoGenerated2)res.getValue()).odataNextLink(), null));
    }

    private Mono<PagedResponse<String>> listRefDirectReportsNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.listRefDirectReportsNext(nextLink, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfLinksOfDirectoryObjectAutoGenerated2)res.getValue()).value(), ((CollectionOfLinksOfDirectoryObjectAutoGenerated2)res.getValue()).odataNextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<String>> listRefDirectReportsNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.listRefDirectReportsNext(nextLink, context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfLinksOfDirectoryObjectAutoGenerated2)res.getValue()).value(), ((CollectionOfLinksOfDirectoryObjectAutoGenerated2)res.getValue()).odataNextLink(), null));
    }

    private Mono<PagedResponse<MicrosoftGraphDirectoryObjectInner>> listMemberOfNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.listMemberOfNext(nextLink, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfDirectoryObject0AutoGenerated2)res.getValue()).value(), ((CollectionOfDirectoryObject0AutoGenerated2)res.getValue()).odataNextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<MicrosoftGraphDirectoryObjectInner>> listMemberOfNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.listMemberOfNext(nextLink, context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfDirectoryObject0AutoGenerated2)res.getValue()).value(), ((CollectionOfDirectoryObject0AutoGenerated2)res.getValue()).odataNextLink(), null));
    }

    private Mono<PagedResponse<String>> listRefMemberOfNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.listRefMemberOfNext(nextLink, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfLinksOfDirectoryObject0AutoGenerated2)res.getValue()).value(), ((CollectionOfLinksOfDirectoryObject0AutoGenerated2)res.getValue()).odataNextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<String>> listRefMemberOfNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.listRefMemberOfNext(nextLink, context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfLinksOfDirectoryObject0AutoGenerated2)res.getValue()).value(), ((CollectionOfLinksOfDirectoryObject0AutoGenerated2)res.getValue()).odataNextLink(), null));
    }

    private Mono<PagedResponse<MicrosoftGraphDirectoryObjectInner>> listTransitiveMemberOfNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.listTransitiveMemberOfNext(nextLink, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfDirectoryObject1AutoGenerated2)res.getValue()).value(), ((CollectionOfDirectoryObject1AutoGenerated2)res.getValue()).odataNextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<MicrosoftGraphDirectoryObjectInner>> listTransitiveMemberOfNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.listTransitiveMemberOfNext(nextLink, context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfDirectoryObject1AutoGenerated2)res.getValue()).value(), ((CollectionOfDirectoryObject1AutoGenerated2)res.getValue()).odataNextLink(), null));
    }

    private Mono<PagedResponse<String>> listRefTransitiveMemberOfNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.listRefTransitiveMemberOfNext(nextLink, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfLinksOfDirectoryObject1AutoGenerated2)res.getValue()).value(), ((CollectionOfLinksOfDirectoryObject1AutoGenerated2)res.getValue()).odataNextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<String>> listRefTransitiveMemberOfNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.listRefTransitiveMemberOfNext(nextLink, context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfLinksOfDirectoryObject1AutoGenerated2)res.getValue()).value(), ((CollectionOfLinksOfDirectoryObject1AutoGenerated2)res.getValue()).odataNextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="MicrosoftGraphClient")
    private static interface ContactsService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/contacts/{orgContact-id}/directReports")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<CollectionOfDirectoryObjectAutoGenerated2>> listDirectReports(@HostParam(value="$host") String var1, @PathParam(value="orgContact-id") String var2, @QueryParam(value="$top") Integer var3, @QueryParam(value="$skip") Integer var4, @QueryParam(value="$search") String var5, @QueryParam(value="$filter") String var6, @QueryParam(value="$count") Boolean var7, @QueryParam(value="$orderby") String var8, @QueryParam(value="$select") String var9, @QueryParam(value="$expand") String var10, @HeaderParam(value="Accept") String var11, Context var12);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/contacts/{orgContact-id}/directReports/$ref")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<CollectionOfLinksOfDirectoryObjectAutoGenerated2>> listRefDirectReports(@HostParam(value="$host") String var1, @PathParam(value="orgContact-id") String var2, @QueryParam(value="$top") Integer var3, @QueryParam(value="$skip") Integer var4, @QueryParam(value="$search") String var5, @QueryParam(value="$filter") String var6, @QueryParam(value="$count") Boolean var7, @QueryParam(value="$orderby") String var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/contacts/{orgContact-id}/directReports/$ref")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<Map<String, Object>>> createRefDirectReports(@HostParam(value="$host") String var1, @PathParam(value="orgContact-id") String var2, @BodyParam(value="application/json") Map<String, Object> var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/contacts/{orgContact-id}/manager")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<MicrosoftGraphDirectoryObjectInner>> getManager(@HostParam(value="$host") String var1, @PathParam(value="orgContact-id") String var2, @QueryParam(value="$select") String var3, @QueryParam(value="$expand") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/contacts/{orgContact-id}/manager/$ref")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<String>> getRefManager(@HostParam(value="$host") String var1, @PathParam(value="orgContact-id") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/contacts/{orgContact-id}/manager/$ref")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<Void>> setRefManager(@HostParam(value="$host") String var1, @PathParam(value="orgContact-id") String var2, @BodyParam(value="application/json") Map<String, Object> var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/contacts/{orgContact-id}/manager/$ref")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<Void>> deleteRefManager(@HostParam(value="$host") String var1, @PathParam(value="orgContact-id") String var2, @HeaderParam(value="If-Match") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/contacts/{orgContact-id}/memberOf")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<CollectionOfDirectoryObject0AutoGenerated2>> listMemberOf(@HostParam(value="$host") String var1, @PathParam(value="orgContact-id") String var2, @QueryParam(value="$top") Integer var3, @QueryParam(value="$skip") Integer var4, @QueryParam(value="$search") String var5, @QueryParam(value="$filter") String var6, @QueryParam(value="$count") Boolean var7, @QueryParam(value="$orderby") String var8, @QueryParam(value="$select") String var9, @QueryParam(value="$expand") String var10, @HeaderParam(value="Accept") String var11, Context var12);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/contacts/{orgContact-id}/memberOf/$ref")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<CollectionOfLinksOfDirectoryObject0AutoGenerated2>> listRefMemberOf(@HostParam(value="$host") String var1, @PathParam(value="orgContact-id") String var2, @QueryParam(value="$top") Integer var3, @QueryParam(value="$skip") Integer var4, @QueryParam(value="$search") String var5, @QueryParam(value="$filter") String var6, @QueryParam(value="$count") Boolean var7, @QueryParam(value="$orderby") String var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/contacts/{orgContact-id}/memberOf/$ref")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<Map<String, Object>>> createRefMemberOf(@HostParam(value="$host") String var1, @PathParam(value="orgContact-id") String var2, @BodyParam(value="application/json") Map<String, Object> var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/contacts/{orgContact-id}/microsoft.graph.checkMemberGroups")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<List<String>>> checkMemberGroups(@HostParam(value="$host") String var1, @PathParam(value="orgContact-id") String var2, @BodyParam(value="application/json") ContactsCheckMemberGroupsRequestBody var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/contacts/{orgContact-id}/microsoft.graph.checkMemberObjects")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<List<String>>> checkMemberObjects(@HostParam(value="$host") String var1, @PathParam(value="orgContact-id") String var2, @BodyParam(value="application/json") ContactsCheckMemberObjectsRequestBody var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/contacts/{orgContact-id}/microsoft.graph.getMemberGroups")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<List<String>>> getMemberGroups(@HostParam(value="$host") String var1, @PathParam(value="orgContact-id") String var2, @BodyParam(value="application/json") ContactsGetMemberGroupsRequestBody var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/contacts/{orgContact-id}/microsoft.graph.getMemberObjects")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<List<String>>> getMemberObjects(@HostParam(value="$host") String var1, @PathParam(value="orgContact-id") String var2, @BodyParam(value="application/json") ContactsGetMemberObjectsRequestBody var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/contacts/{orgContact-id}/microsoft.graph.restore")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<MicrosoftGraphDirectoryObjectInner>> restore(@HostParam(value="$host") String var1, @PathParam(value="orgContact-id") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/contacts/{orgContact-id}/transitiveMemberOf")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<CollectionOfDirectoryObject1AutoGenerated2>> listTransitiveMemberOf(@HostParam(value="$host") String var1, @PathParam(value="orgContact-id") String var2, @QueryParam(value="$top") Integer var3, @QueryParam(value="$skip") Integer var4, @QueryParam(value="$search") String var5, @QueryParam(value="$filter") String var6, @QueryParam(value="$count") Boolean var7, @QueryParam(value="$orderby") String var8, @QueryParam(value="$select") String var9, @QueryParam(value="$expand") String var10, @HeaderParam(value="Accept") String var11, Context var12);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/contacts/{orgContact-id}/transitiveMemberOf/$ref")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<CollectionOfLinksOfDirectoryObject1AutoGenerated2>> listRefTransitiveMemberOf(@HostParam(value="$host") String var1, @PathParam(value="orgContact-id") String var2, @QueryParam(value="$top") Integer var3, @QueryParam(value="$skip") Integer var4, @QueryParam(value="$search") String var5, @QueryParam(value="$filter") String var6, @QueryParam(value="$count") Boolean var7, @QueryParam(value="$orderby") String var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/contacts/{orgContact-id}/transitiveMemberOf/$ref")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<Map<String, Object>>> createRefTransitiveMemberOf(@HostParam(value="$host") String var1, @PathParam(value="orgContact-id") String var2, @BodyParam(value="application/json") Map<String, Object> var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/contacts/microsoft.graph.delta()")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<List<MicrosoftGraphOrgContactInner>>> delta(@HostParam(value="$host") String var1, @HeaderParam(value="Accept") String var2, Context var3);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/contacts/microsoft.graph.getAvailableExtensionProperties")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<List<MicrosoftGraphExtensionPropertyInner>>> getAvailableExtensionProperties(@HostParam(value="$host") String var1, @BodyParam(value="application/json") ContactsGetAvailableExtensionPropertiesRequestBody var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/contacts/microsoft.graph.getByIds")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<List<MicrosoftGraphDirectoryObjectInner>>> getByIds(@HostParam(value="$host") String var1, @BodyParam(value="application/json") ContactsGetByIdsRequestBody var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/contacts/microsoft.graph.validateProperties")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<Void>> validateProperties(@HostParam(value="$host") String var1, @BodyParam(value="application/json") ContactsValidatePropertiesRequestBody var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<CollectionOfDirectoryObjectAutoGenerated2>> listMore(@PathParam(value="nextLink", encoded=true) String var1, Context var2);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<CollectionOfLinksOfDirectoryObjectAutoGenerated2>> listRefDirectReportsNext(@PathParam(value="nextLink", encoded=true) String var1, Context var2);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<CollectionOfDirectoryObject0AutoGenerated2>> listMemberOfNext(@PathParam(value="nextLink", encoded=true) String var1, Context var2);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<CollectionOfLinksOfDirectoryObject0AutoGenerated2>> listRefMemberOfNext(@PathParam(value="nextLink", encoded=true) String var1, Context var2);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<CollectionOfDirectoryObject1AutoGenerated2>> listTransitiveMemberOfNext(@PathParam(value="nextLink", encoded=true) String var1, Context var2);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<CollectionOfLinksOfDirectoryObject1AutoGenerated2>> listRefTransitiveMemberOfNext(@PathParam(value="nextLink", encoded=true) String var1, Context var2);
    }
}

