/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.authorization.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.CollectionFormat;
import com.azure.core.util.serializer.JacksonAdapter;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.authorization.fluent.SubscribedSkusSubscribedSkusClient;
import com.azure.resourcemanager.authorization.fluent.models.CollectionOfSubscribedSku;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphSubscribedSkuInner;
import com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException;
import com.azure.resourcemanager.authorization.fluent.models.SubscribedSkusSubscribedSkuOrderby;
import com.azure.resourcemanager.authorization.fluent.models.SubscribedSkusSubscribedSkuSelect;
import com.azure.resourcemanager.authorization.implementation.MicrosoftGraphClientImpl;
import java.util.List;
import reactor.core.publisher.Mono;

public final class SubscribedSkusSubscribedSkusClientImpl
implements SubscribedSkusSubscribedSkusClient {
    private final ClientLogger logger = new ClientLogger(SubscribedSkusSubscribedSkusClientImpl.class);
    private final SubscribedSkusSubscribedSkusService service;
    private final MicrosoftGraphClientImpl client;

    SubscribedSkusSubscribedSkusClientImpl(MicrosoftGraphClientImpl client) {
        this.service = (SubscribedSkusSubscribedSkusService)RestProxy.create(SubscribedSkusSubscribedSkusService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    private Mono<PagedResponse<MicrosoftGraphSubscribedSkuInner>> listSubscribedSkuSinglePageAsync(Integer top, Integer skip, String search, String filter, Boolean count, List<SubscribedSkusSubscribedSkuOrderby> orderby, List<SubscribedSkusSubscribedSkuSelect> select, List<String> expand) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        String orderbyConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        String selectConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        return FluxUtil.withContext(context -> this.service.listSubscribedSku(this.client.getEndpoint(), top, skip, search, filter, count, orderbyConverted, selectConverted, expandConverted, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfSubscribedSku)res.getValue()).value(), ((CollectionOfSubscribedSku)res.getValue()).odataNextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<MicrosoftGraphSubscribedSkuInner>> listSubscribedSkuSinglePageAsync(Integer top, Integer skip, String search, String filter, Boolean count, List<SubscribedSkusSubscribedSkuOrderby> orderby, List<SubscribedSkusSubscribedSkuSelect> select, List<String> expand, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        String orderbyConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        String selectConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        context = this.client.mergeContext(context);
        return this.service.listSubscribedSku(this.client.getEndpoint(), top, skip, search, filter, count, orderbyConverted, selectConverted, expandConverted, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfSubscribedSku)res.getValue()).value(), ((CollectionOfSubscribedSku)res.getValue()).odataNextLink(), null));
    }

    @Override
    public PagedFlux<MicrosoftGraphSubscribedSkuInner> listSubscribedSkuAsync(Integer top, Integer skip, String search, String filter, Boolean count, List<SubscribedSkusSubscribedSkuOrderby> orderby, List<SubscribedSkusSubscribedSkuSelect> select, List<String> expand) {
        return new PagedFlux(() -> this.listSubscribedSkuSinglePageAsync(top, skip, search, filter, count, orderby, select, expand), nextLink -> this.listMoreSinglePageAsync((String)nextLink));
    }

    @Override
    public PagedFlux<MicrosoftGraphSubscribedSkuInner> listSubscribedSkuAsync() {
        Integer top = null;
        Integer skip = null;
        String search = null;
        String filter = null;
        Boolean count = null;
        List orderby = null;
        List select = null;
        List expand = null;
        return new PagedFlux(() -> this.listSubscribedSkuSinglePageAsync(top, skip, search, filter, count, orderby, select, expand), nextLink -> this.listMoreSinglePageAsync((String)nextLink));
    }

    private PagedFlux<MicrosoftGraphSubscribedSkuInner> listSubscribedSkuAsync(Integer top, Integer skip, String search, String filter, Boolean count, List<SubscribedSkusSubscribedSkuOrderby> orderby, List<SubscribedSkusSubscribedSkuSelect> select, List<String> expand, Context context) {
        return new PagedFlux(() -> this.listSubscribedSkuSinglePageAsync(top, skip, search, filter, count, orderby, select, expand, context), nextLink -> this.listMoreSinglePageAsync((String)nextLink, context));
    }

    @Override
    public PagedIterable<MicrosoftGraphSubscribedSkuInner> listSubscribedSku() {
        Integer top = null;
        Integer skip = null;
        String search = null;
        String filter = null;
        Boolean count = null;
        List<SubscribedSkusSubscribedSkuOrderby> orderby = null;
        List<SubscribedSkusSubscribedSkuSelect> select = null;
        List<String> expand = null;
        return new PagedIterable(this.listSubscribedSkuAsync(top, skip, search, filter, count, orderby, select, expand));
    }

    @Override
    public PagedIterable<MicrosoftGraphSubscribedSkuInner> listSubscribedSku(Integer top, Integer skip, String search, String filter, Boolean count, List<SubscribedSkusSubscribedSkuOrderby> orderby, List<SubscribedSkusSubscribedSkuSelect> select, List<String> expand, Context context) {
        return new PagedIterable(this.listSubscribedSkuAsync(top, skip, search, filter, count, orderby, select, expand, context));
    }

    @Override
    public Mono<Response<MicrosoftGraphSubscribedSkuInner>> createSubscribedSkuWithResponseAsync(MicrosoftGraphSubscribedSkuInner body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createSubscribedSku(this.client.getEndpoint(), body, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<MicrosoftGraphSubscribedSkuInner>> createSubscribedSkuWithResponseAsync(MicrosoftGraphSubscribedSkuInner body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.createSubscribedSku(this.client.getEndpoint(), body, "application/json", context);
    }

    @Override
    public Mono<MicrosoftGraphSubscribedSkuInner> createSubscribedSkuAsync(MicrosoftGraphSubscribedSkuInner body) {
        return this.createSubscribedSkuWithResponseAsync(body).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((MicrosoftGraphSubscribedSkuInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    public MicrosoftGraphSubscribedSkuInner createSubscribedSku(MicrosoftGraphSubscribedSkuInner body) {
        return (MicrosoftGraphSubscribedSkuInner)this.createSubscribedSkuAsync(body).block();
    }

    @Override
    public Response<MicrosoftGraphSubscribedSkuInner> createSubscribedSkuWithResponse(MicrosoftGraphSubscribedSkuInner body, Context context) {
        return (Response)this.createSubscribedSkuWithResponseAsync(body, context).block();
    }

    @Override
    public Mono<Response<MicrosoftGraphSubscribedSkuInner>> getSubscribedSkuWithResponseAsync(String subscribedSkuId, List<SubscribedSkusSubscribedSkuSelect> select, List<String> expand) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (subscribedSkuId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter subscribedSkuId is required and cannot be null."));
        }
        String accept = "application/json";
        String selectConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        return FluxUtil.withContext(context -> this.service.getSubscribedSku(this.client.getEndpoint(), subscribedSkuId, selectConverted, expandConverted, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<MicrosoftGraphSubscribedSkuInner>> getSubscribedSkuWithResponseAsync(String subscribedSkuId, List<SubscribedSkusSubscribedSkuSelect> select, List<String> expand, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (subscribedSkuId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter subscribedSkuId is required and cannot be null."));
        }
        String accept = "application/json";
        String selectConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        context = this.client.mergeContext(context);
        return this.service.getSubscribedSku(this.client.getEndpoint(), subscribedSkuId, selectConverted, expandConverted, "application/json", context);
    }

    @Override
    public Mono<MicrosoftGraphSubscribedSkuInner> getSubscribedSkuAsync(String subscribedSkuId, List<SubscribedSkusSubscribedSkuSelect> select, List<String> expand) {
        return this.getSubscribedSkuWithResponseAsync(subscribedSkuId, select, expand).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((MicrosoftGraphSubscribedSkuInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    public Mono<MicrosoftGraphSubscribedSkuInner> getSubscribedSkuAsync(String subscribedSkuId) {
        List<SubscribedSkusSubscribedSkuSelect> select = null;
        List<String> expand = null;
        return this.getSubscribedSkuWithResponseAsync(subscribedSkuId, select, expand).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((MicrosoftGraphSubscribedSkuInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    public MicrosoftGraphSubscribedSkuInner getSubscribedSku(String subscribedSkuId) {
        List<SubscribedSkusSubscribedSkuSelect> select = null;
        List<String> expand = null;
        return (MicrosoftGraphSubscribedSkuInner)this.getSubscribedSkuAsync(subscribedSkuId, select, expand).block();
    }

    @Override
    public Response<MicrosoftGraphSubscribedSkuInner> getSubscribedSkuWithResponse(String subscribedSkuId, List<SubscribedSkusSubscribedSkuSelect> select, List<String> expand, Context context) {
        return (Response)this.getSubscribedSkuWithResponseAsync(subscribedSkuId, select, expand, context).block();
    }

    @Override
    public Mono<Response<Void>> updateSubscribedSkuWithResponseAsync(String subscribedSkuId, MicrosoftGraphSubscribedSkuInner body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (subscribedSkuId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter subscribedSkuId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.updateSubscribedSku(this.client.getEndpoint(), subscribedSkuId, body, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<Void>> updateSubscribedSkuWithResponseAsync(String subscribedSkuId, MicrosoftGraphSubscribedSkuInner body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (subscribedSkuId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter subscribedSkuId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.updateSubscribedSku(this.client.getEndpoint(), subscribedSkuId, body, "application/json", context);
    }

    @Override
    public Mono<Void> updateSubscribedSkuAsync(String subscribedSkuId, MicrosoftGraphSubscribedSkuInner body) {
        return this.updateSubscribedSkuWithResponseAsync(subscribedSkuId, body).flatMap(res -> Mono.empty());
    }

    @Override
    public void updateSubscribedSku(String subscribedSkuId, MicrosoftGraphSubscribedSkuInner body) {
        this.updateSubscribedSkuAsync(subscribedSkuId, body).block();
    }

    @Override
    public Response<Void> updateSubscribedSkuWithResponse(String subscribedSkuId, MicrosoftGraphSubscribedSkuInner body, Context context) {
        return (Response)this.updateSubscribedSkuWithResponseAsync(subscribedSkuId, body, context).block();
    }

    @Override
    public Mono<Response<Void>> deleteSubscribedSkuWithResponseAsync(String subscribedSkuId, String ifMatch) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (subscribedSkuId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter subscribedSkuId is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.deleteSubscribedSku(this.client.getEndpoint(), subscribedSkuId, ifMatch, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<Void>> deleteSubscribedSkuWithResponseAsync(String subscribedSkuId, String ifMatch, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (subscribedSkuId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter subscribedSkuId is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.deleteSubscribedSku(this.client.getEndpoint(), subscribedSkuId, ifMatch, "application/json", context);
    }

    @Override
    public Mono<Void> deleteSubscribedSkuAsync(String subscribedSkuId, String ifMatch) {
        return this.deleteSubscribedSkuWithResponseAsync(subscribedSkuId, ifMatch).flatMap(res -> Mono.empty());
    }

    @Override
    public Mono<Void> deleteSubscribedSkuAsync(String subscribedSkuId) {
        String ifMatch = null;
        return this.deleteSubscribedSkuWithResponseAsync(subscribedSkuId, ifMatch).flatMap(res -> Mono.empty());
    }

    @Override
    public void deleteSubscribedSku(String subscribedSkuId) {
        String ifMatch = null;
        this.deleteSubscribedSkuAsync(subscribedSkuId, ifMatch).block();
    }

    @Override
    public Response<Void> deleteSubscribedSkuWithResponse(String subscribedSkuId, String ifMatch, Context context) {
        return (Response)this.deleteSubscribedSkuWithResponseAsync(subscribedSkuId, ifMatch, context).block();
    }

    private Mono<PagedResponse<MicrosoftGraphSubscribedSkuInner>> listMoreSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.listMore(nextLink, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfSubscribedSku)res.getValue()).value(), ((CollectionOfSubscribedSku)res.getValue()).odataNextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<MicrosoftGraphSubscribedSkuInner>> listMoreSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.listMore(nextLink, context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfSubscribedSku)res.getValue()).value(), ((CollectionOfSubscribedSku)res.getValue()).odataNextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="MicrosoftGraphClient")
    private static interface SubscribedSkusSubscribedSkusService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscribedSkus")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<CollectionOfSubscribedSku>> listSubscribedSku(@HostParam(value="$host") String var1, @QueryParam(value="$top") Integer var2, @QueryParam(value="$skip") Integer var3, @QueryParam(value="$search") String var4, @QueryParam(value="$filter") String var5, @QueryParam(value="$count") Boolean var6, @QueryParam(value="$orderby") String var7, @QueryParam(value="$select") String var8, @QueryParam(value="$expand") String var9, @HeaderParam(value="Accept") String var10, Context var11);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscribedSkus")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<MicrosoftGraphSubscribedSkuInner>> createSubscribedSku(@HostParam(value="$host") String var1, @BodyParam(value="application/json") MicrosoftGraphSubscribedSkuInner var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscribedSkus/{subscribedSku-id}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<MicrosoftGraphSubscribedSkuInner>> getSubscribedSku(@HostParam(value="$host") String var1, @PathParam(value="subscribedSku-id") String var2, @QueryParam(value="$select") String var3, @QueryParam(value="$expand") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Patch(value="/subscribedSkus/{subscribedSku-id}")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<Void>> updateSubscribedSku(@HostParam(value="$host") String var1, @PathParam(value="subscribedSku-id") String var2, @BodyParam(value="application/json") MicrosoftGraphSubscribedSkuInner var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/subscribedSkus/{subscribedSku-id}")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<Void>> deleteSubscribedSku(@HostParam(value="$host") String var1, @PathParam(value="subscribedSku-id") String var2, @HeaderParam(value="If-Match") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<CollectionOfSubscribedSku>> listMore(@PathParam(value="nextLink", encoded=true) String var1, Context var2);
    }
}

