// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent;

import com.azure.core.http.HttpPipeline;
import java.time.Duration;

/** The interface for AuthorizationManagementClient class. */
public interface AuthorizationManagementClient {
    /**
     * Gets The ID of the target subscription.
     *
     * @return the subscriptionId value.
     */
    String getSubscriptionId();

    /**
     * Gets server parameter.
     *
     * @return the endpoint value.
     */
    String getEndpoint();

    /**
     * Gets The HTTP pipeline to send requests through.
     *
     * @return the httpPipeline value.
     */
    HttpPipeline getHttpPipeline();

    /**
     * Gets The default poll interval for long-running operation.
     *
     * @return the defaultPollInterval value.
     */
    Duration getDefaultPollInterval();

    /**
     * Gets the ClassicAdministratorsClient object to access its operations.
     *
     * @return the ClassicAdministratorsClient object.
     */
    ClassicAdministratorsClient getClassicAdministrators();

    /**
     * Gets the GlobalAdministratorsClient object to access its operations.
     *
     * @return the GlobalAdministratorsClient object.
     */
    GlobalAdministratorsClient getGlobalAdministrators();

    /**
     * Gets the DenyAssignmentsClient object to access its operations.
     *
     * @return the DenyAssignmentsClient object.
     */
    DenyAssignmentsClient getDenyAssignments();

    /**
     * Gets the ProviderOperationsMetadatasClient object to access its operations.
     *
     * @return the ProviderOperationsMetadatasClient object.
     */
    ProviderOperationsMetadatasClient getProviderOperationsMetadatas();

    /**
     * Gets the RoleAssignmentsClient object to access its operations.
     *
     * @return the RoleAssignmentsClient object.
     */
    RoleAssignmentsClient getRoleAssignments();

    /**
     * Gets the PermissionsClient object to access its operations.
     *
     * @return the PermissionsClient object.
     */
    PermissionsClient getPermissions();

    /**
     * Gets the RoleDefinitionsClient object to access its operations.
     *
     * @return the RoleDefinitionsClient object.
     */
    RoleDefinitionsClient getRoleDefinitions();

    /**
     * Gets the EligibleChildResourcesClient object to access its operations.
     *
     * @return the EligibleChildResourcesClient object.
     */
    EligibleChildResourcesClient getEligibleChildResources();

    /**
     * Gets the RoleAssignmentSchedulesClient object to access its operations.
     *
     * @return the RoleAssignmentSchedulesClient object.
     */
    RoleAssignmentSchedulesClient getRoleAssignmentSchedules();

    /**
     * Gets the RoleAssignmentScheduleInstancesClient object to access its operations.
     *
     * @return the RoleAssignmentScheduleInstancesClient object.
     */
    RoleAssignmentScheduleInstancesClient getRoleAssignmentScheduleInstances();

    /**
     * Gets the RoleAssignmentScheduleRequestsClient object to access its operations.
     *
     * @return the RoleAssignmentScheduleRequestsClient object.
     */
    RoleAssignmentScheduleRequestsClient getRoleAssignmentScheduleRequests();

    /**
     * Gets the RoleEligibilitySchedulesClient object to access its operations.
     *
     * @return the RoleEligibilitySchedulesClient object.
     */
    RoleEligibilitySchedulesClient getRoleEligibilitySchedules();

    /**
     * Gets the RoleEligibilityScheduleInstancesClient object to access its operations.
     *
     * @return the RoleEligibilityScheduleInstancesClient object.
     */
    RoleEligibilityScheduleInstancesClient getRoleEligibilityScheduleInstances();

    /**
     * Gets the RoleEligibilityScheduleRequestsClient object to access its operations.
     *
     * @return the RoleEligibilityScheduleRequestsClient object.
     */
    RoleEligibilityScheduleRequestsClient getRoleEligibilityScheduleRequests();

    /**
     * Gets the RoleManagementPoliciesClient object to access its operations.
     *
     * @return the RoleManagementPoliciesClient object.
     */
    RoleManagementPoliciesClient getRoleManagementPolicies();

    /**
     * Gets the RoleManagementPolicyAssignmentsClient object to access its operations.
     *
     * @return the RoleManagementPolicyAssignmentsClient object.
     */
    RoleManagementPolicyAssignmentsClient getRoleManagementPolicyAssignments();
}
