// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.util.ExpandableStringEnum;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Collection;

/** deviceRegistrationState. */
public final class MicrosoftGraphDeviceRegistrationState
    extends ExpandableStringEnum<MicrosoftGraphDeviceRegistrationState> {
    /** Static value notRegistered for MicrosoftGraphDeviceRegistrationState. */
    public static final MicrosoftGraphDeviceRegistrationState NOT_REGISTERED = fromString("notRegistered");

    /** Static value registered for MicrosoftGraphDeviceRegistrationState. */
    public static final MicrosoftGraphDeviceRegistrationState REGISTERED = fromString("registered");

    /** Static value revoked for MicrosoftGraphDeviceRegistrationState. */
    public static final MicrosoftGraphDeviceRegistrationState REVOKED = fromString("revoked");

    /** Static value keyConflict for MicrosoftGraphDeviceRegistrationState. */
    public static final MicrosoftGraphDeviceRegistrationState KEY_CONFLICT = fromString("keyConflict");

    /** Static value approvalPending for MicrosoftGraphDeviceRegistrationState. */
    public static final MicrosoftGraphDeviceRegistrationState APPROVAL_PENDING = fromString("approvalPending");

    /** Static value certificateReset for MicrosoftGraphDeviceRegistrationState. */
    public static final MicrosoftGraphDeviceRegistrationState CERTIFICATE_RESET = fromString("certificateReset");

    /** Static value notRegisteredPendingEnrollment for MicrosoftGraphDeviceRegistrationState. */
    public static final MicrosoftGraphDeviceRegistrationState NOT_REGISTERED_PENDING_ENROLLMENT =
        fromString("notRegisteredPendingEnrollment");

    /** Static value unknown for MicrosoftGraphDeviceRegistrationState. */
    public static final MicrosoftGraphDeviceRegistrationState UNKNOWN = fromString("unknown");

    /**
     * Creates a new instance of MicrosoftGraphDeviceRegistrationState value.
     *
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public MicrosoftGraphDeviceRegistrationState() {
    }

    /**
     * Creates or finds a MicrosoftGraphDeviceRegistrationState from its string representation.
     *
     * @param name a name to look for.
     * @return the corresponding MicrosoftGraphDeviceRegistrationState.
     */
    @JsonCreator
    public static MicrosoftGraphDeviceRegistrationState fromString(String name) {
        return fromString(name, MicrosoftGraphDeviceRegistrationState.class);
    }

    /**
     * Gets known MicrosoftGraphDeviceRegistrationState values.
     *
     * @return known MicrosoftGraphDeviceRegistrationState values.
     */
    public static Collection<MicrosoftGraphDeviceRegistrationState> values() {
        return values(MicrosoftGraphDeviceRegistrationState.class);
    }
}
