// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashMap;
import java.util.Map;

/** linkedResource. */
@Fluent
public final class MicrosoftGraphLinkedResource extends MicrosoftGraphEntity {
    /*
     * Field indicating the app name of the source that is sending the linkedResource.
     */
    @JsonProperty(value = "applicationName")
    private String applicationName;

    /*
     * Field indicating the title of the linkedResource.
     */
    @JsonProperty(value = "displayName")
    private String displayName;

    /*
     * Id of the object that is associated with this task on the third-party/partner system.
     */
    @JsonProperty(value = "externalId")
    private String externalId;

    /*
     * Deep link to the linkedResource.
     */
    @JsonProperty(value = "webUrl")
    private String webUrl;

    /*
     * linkedResource
     */
    @JsonIgnore private Map<String, Object> additionalProperties;

    /** Creates an instance of MicrosoftGraphLinkedResource class. */
    public MicrosoftGraphLinkedResource() {
    }

    /**
     * Get the applicationName property: Field indicating the app name of the source that is sending the linkedResource.
     *
     * @return the applicationName value.
     */
    public String applicationName() {
        return this.applicationName;
    }

    /**
     * Set the applicationName property: Field indicating the app name of the source that is sending the linkedResource.
     *
     * @param applicationName the applicationName value to set.
     * @return the MicrosoftGraphLinkedResource object itself.
     */
    public MicrosoftGraphLinkedResource withApplicationName(String applicationName) {
        this.applicationName = applicationName;
        return this;
    }

    /**
     * Get the displayName property: Field indicating the title of the linkedResource.
     *
     * @return the displayName value.
     */
    public String displayName() {
        return this.displayName;
    }

    /**
     * Set the displayName property: Field indicating the title of the linkedResource.
     *
     * @param displayName the displayName value to set.
     * @return the MicrosoftGraphLinkedResource object itself.
     */
    public MicrosoftGraphLinkedResource withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    /**
     * Get the externalId property: Id of the object that is associated with this task on the third-party/partner
     * system.
     *
     * @return the externalId value.
     */
    public String externalId() {
        return this.externalId;
    }

    /**
     * Set the externalId property: Id of the object that is associated with this task on the third-party/partner
     * system.
     *
     * @param externalId the externalId value to set.
     * @return the MicrosoftGraphLinkedResource object itself.
     */
    public MicrosoftGraphLinkedResource withExternalId(String externalId) {
        this.externalId = externalId;
        return this;
    }

    /**
     * Get the webUrl property: Deep link to the linkedResource.
     *
     * @return the webUrl value.
     */
    public String webUrl() {
        return this.webUrl;
    }

    /**
     * Set the webUrl property: Deep link to the linkedResource.
     *
     * @param webUrl the webUrl value to set.
     * @return the MicrosoftGraphLinkedResource object itself.
     */
    public MicrosoftGraphLinkedResource withWebUrl(String webUrl) {
        this.webUrl = webUrl;
        return this;
    }

    /**
     * Get the additionalProperties property: linkedResource.
     *
     * @return the additionalProperties value.
     */
    @JsonAnyGetter
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: linkedResource.
     *
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphLinkedResource object itself.
     */
    public MicrosoftGraphLinkedResource withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @JsonAnySetter
    void withAdditionalProperties(String key, Object value) {
        if (additionalProperties == null) {
            additionalProperties = new HashMap<>();
        }
        additionalProperties.put(key, value);
    }

    /** {@inheritDoc} */
    @Override
    public MicrosoftGraphLinkedResource withId(String id) {
        super.withId(id);
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
    }
}
