// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;

/** listItemVersion. */
@Fluent
public final class MicrosoftGraphListItemVersion extends MicrosoftGraphBaseItemVersion {
    /*
     * fieldValueSet
     */
    @JsonProperty(value = "fields")
    private MicrosoftGraphFieldValueSet fields;

    /*
     * listItemVersion
     */
    @JsonIgnore private Map<String, Object> additionalProperties;

    /** Creates an instance of MicrosoftGraphListItemVersion class. */
    public MicrosoftGraphListItemVersion() {
    }

    /**
     * Get the fields property: fieldValueSet.
     *
     * @return the fields value.
     */
    public MicrosoftGraphFieldValueSet fields() {
        return this.fields;
    }

    /**
     * Set the fields property: fieldValueSet.
     *
     * @param fields the fields value to set.
     * @return the MicrosoftGraphListItemVersion object itself.
     */
    public MicrosoftGraphListItemVersion withFields(MicrosoftGraphFieldValueSet fields) {
        this.fields = fields;
        return this;
    }

    /**
     * Get the additionalProperties property: listItemVersion.
     *
     * @return the additionalProperties value.
     */
    @JsonAnyGetter
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: listItemVersion.
     *
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphListItemVersion object itself.
     */
    public MicrosoftGraphListItemVersion withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @JsonAnySetter
    void withAdditionalProperties(String key, Object value) {
        if (additionalProperties == null) {
            additionalProperties = new HashMap<>();
        }
        additionalProperties.put(key, value);
    }

    /** {@inheritDoc} */
    @Override
    public MicrosoftGraphListItemVersion withLastModifiedBy(MicrosoftGraphIdentitySet lastModifiedBy) {
        super.withLastModifiedBy(lastModifiedBy);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public MicrosoftGraphListItemVersion withLastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
        super.withLastModifiedDateTime(lastModifiedDateTime);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public MicrosoftGraphListItemVersion withPublication(MicrosoftGraphPublicationFacet publication) {
        super.withPublication(publication);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public MicrosoftGraphListItemVersion withId(String id) {
        super.withId(id);
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (fields() != null) {
            fields().validate();
        }
    }
}
