// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/** plannerBucket. */
@Fluent
public final class MicrosoftGraphPlannerBucket extends MicrosoftGraphEntity {
    /*
     * Name of the bucket.
     */
    @JsonProperty(value = "name")
    private String name;

    /*
     * Hint used to order items of this type in a list view. The format is defined as outlined here.
     */
    @JsonProperty(value = "orderHint")
    private String orderHint;

    /*
     * Plan ID to which the bucket belongs.
     */
    @JsonProperty(value = "planId")
    private String planId;

    /*
     * Read-only. Nullable. The collection of tasks in the bucket.
     */
    @JsonProperty(value = "tasks")
    private List<MicrosoftGraphPlannerTask> tasks;

    /*
     * plannerBucket
     */
    @JsonIgnore private Map<String, Object> additionalProperties;

    /** Creates an instance of MicrosoftGraphPlannerBucket class. */
    public MicrosoftGraphPlannerBucket() {
    }

    /**
     * Get the name property: Name of the bucket.
     *
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: Name of the bucket.
     *
     * @param name the name value to set.
     * @return the MicrosoftGraphPlannerBucket object itself.
     */
    public MicrosoftGraphPlannerBucket withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the orderHint property: Hint used to order items of this type in a list view. The format is defined as
     * outlined here.
     *
     * @return the orderHint value.
     */
    public String orderHint() {
        return this.orderHint;
    }

    /**
     * Set the orderHint property: Hint used to order items of this type in a list view. The format is defined as
     * outlined here.
     *
     * @param orderHint the orderHint value to set.
     * @return the MicrosoftGraphPlannerBucket object itself.
     */
    public MicrosoftGraphPlannerBucket withOrderHint(String orderHint) {
        this.orderHint = orderHint;
        return this;
    }

    /**
     * Get the planId property: Plan ID to which the bucket belongs.
     *
     * @return the planId value.
     */
    public String planId() {
        return this.planId;
    }

    /**
     * Set the planId property: Plan ID to which the bucket belongs.
     *
     * @param planId the planId value to set.
     * @return the MicrosoftGraphPlannerBucket object itself.
     */
    public MicrosoftGraphPlannerBucket withPlanId(String planId) {
        this.planId = planId;
        return this;
    }

    /**
     * Get the tasks property: Read-only. Nullable. The collection of tasks in the bucket.
     *
     * @return the tasks value.
     */
    public List<MicrosoftGraphPlannerTask> tasks() {
        return this.tasks;
    }

    /**
     * Set the tasks property: Read-only. Nullable. The collection of tasks in the bucket.
     *
     * @param tasks the tasks value to set.
     * @return the MicrosoftGraphPlannerBucket object itself.
     */
    public MicrosoftGraphPlannerBucket withTasks(List<MicrosoftGraphPlannerTask> tasks) {
        this.tasks = tasks;
        return this;
    }

    /**
     * Get the additionalProperties property: plannerBucket.
     *
     * @return the additionalProperties value.
     */
    @JsonAnyGetter
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: plannerBucket.
     *
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphPlannerBucket object itself.
     */
    public MicrosoftGraphPlannerBucket withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @JsonAnySetter
    void withAdditionalProperties(String key, Object value) {
        if (additionalProperties == null) {
            additionalProperties = new HashMap<>();
        }
        additionalProperties.put(key, value);
    }

    /** {@inheritDoc} */
    @Override
    public MicrosoftGraphPlannerBucket withId(String id) {
        super.withId(id);
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (tasks() != null) {
            tasks().forEach(e -> e.validate());
        }
    }
}
