// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/** preAuthorizedApplication. */
@Fluent
public final class MicrosoftGraphPreAuthorizedApplication {
    /*
     * The unique identifier for the application.
     */
    @JsonProperty(value = "appId")
    private String appId;

    /*
     * The unique identifier for the oauth2PermissionScopes the application requires.
     */
    @JsonProperty(value = "delegatedPermissionIds")
    private List<String> delegatedPermissionIds;

    /*
     * preAuthorizedApplication
     */
    @JsonIgnore private Map<String, Object> additionalProperties;

    /** Creates an instance of MicrosoftGraphPreAuthorizedApplication class. */
    public MicrosoftGraphPreAuthorizedApplication() {
    }

    /**
     * Get the appId property: The unique identifier for the application.
     *
     * @return the appId value.
     */
    public String appId() {
        return this.appId;
    }

    /**
     * Set the appId property: The unique identifier for the application.
     *
     * @param appId the appId value to set.
     * @return the MicrosoftGraphPreAuthorizedApplication object itself.
     */
    public MicrosoftGraphPreAuthorizedApplication withAppId(String appId) {
        this.appId = appId;
        return this;
    }

    /**
     * Get the delegatedPermissionIds property: The unique identifier for the oauth2PermissionScopes the application
     * requires.
     *
     * @return the delegatedPermissionIds value.
     */
    public List<String> delegatedPermissionIds() {
        return this.delegatedPermissionIds;
    }

    /**
     * Set the delegatedPermissionIds property: The unique identifier for the oauth2PermissionScopes the application
     * requires.
     *
     * @param delegatedPermissionIds the delegatedPermissionIds value to set.
     * @return the MicrosoftGraphPreAuthorizedApplication object itself.
     */
    public MicrosoftGraphPreAuthorizedApplication withDelegatedPermissionIds(List<String> delegatedPermissionIds) {
        this.delegatedPermissionIds = delegatedPermissionIds;
        return this;
    }

    /**
     * Get the additionalProperties property: preAuthorizedApplication.
     *
     * @return the additionalProperties value.
     */
    @JsonAnyGetter
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: preAuthorizedApplication.
     *
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphPreAuthorizedApplication object itself.
     */
    public MicrosoftGraphPreAuthorizedApplication withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @JsonAnySetter
    void withAdditionalProperties(String key, Object value) {
        if (additionalProperties == null) {
            additionalProperties = new HashMap<>();
        }
        additionalProperties.put(key, value);
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
