// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/** site. */
@Fluent
public final class MicrosoftGraphSite extends MicrosoftGraphBaseItemInner {
    /*
     * The full title for the site. Read-only.
     */
    @JsonProperty(value = "displayName")
    private String displayName;

    /*
     * publicError
     */
    @JsonProperty(value = "error")
    private MicrosoftGraphPublicError error;

    /*
     * root
     */
    @JsonProperty(value = "root")
    @JsonInclude(value = JsonInclude.Include.NON_NULL, content = JsonInclude.Include.ALWAYS)
    private Map<String, Object> root;

    /*
     * sharepointIds
     */
    @JsonProperty(value = "sharepointIds")
    private MicrosoftGraphSharepointIds sharepointIds;

    /*
     * siteCollection
     */
    @JsonProperty(value = "siteCollection")
    private MicrosoftGraphSiteCollection siteCollection;

    /*
     * itemAnalytics
     */
    @JsonProperty(value = "analytics")
    private MicrosoftGraphItemAnalytics analytics;

    /*
     * The collection of column definitions reusable across lists under this site.
     */
    @JsonProperty(value = "columns")
    private List<MicrosoftGraphColumnDefinition> columns;

    /*
     * The collection of content types defined for this site.
     */
    @JsonProperty(value = "contentTypes")
    private List<MicrosoftGraphContentType> contentTypes;

    /*
     * drive
     */
    @JsonProperty(value = "drive")
    private MicrosoftGraphDrive drive;

    /*
     * The collection of drives (document libraries) under this site.
     */
    @JsonProperty(value = "drives")
    private List<MicrosoftGraphDrive> drives;

    /*
     * Used to address any item contained in this site. This collection cannot be enumerated.
     */
    @JsonProperty(value = "items")
    private List<MicrosoftGraphBaseItemInner> items;

    /*
     * The collection of lists under this site.
     */
    @JsonProperty(value = "lists")
    private List<MicrosoftGraphList> lists;

    /*
     * The collection of the sub-sites under this site.
     */
    @JsonProperty(value = "sites")
    private List<MicrosoftGraphSite> sites;

    /*
     * onenote
     */
    @JsonProperty(value = "onenote")
    private MicrosoftGraphOnenote onenote;

    /*
     * site
     */
    @JsonIgnore private Map<String, Object> additionalProperties;

    /** Creates an instance of MicrosoftGraphSite class. */
    public MicrosoftGraphSite() {
    }

    /**
     * Get the displayName property: The full title for the site. Read-only.
     *
     * @return the displayName value.
     */
    public String displayName() {
        return this.displayName;
    }

    /**
     * Set the displayName property: The full title for the site. Read-only.
     *
     * @param displayName the displayName value to set.
     * @return the MicrosoftGraphSite object itself.
     */
    public MicrosoftGraphSite withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    /**
     * Get the error property: publicError.
     *
     * @return the error value.
     */
    public MicrosoftGraphPublicError error() {
        return this.error;
    }

    /**
     * Set the error property: publicError.
     *
     * @param error the error value to set.
     * @return the MicrosoftGraphSite object itself.
     */
    public MicrosoftGraphSite withError(MicrosoftGraphPublicError error) {
        this.error = error;
        return this;
    }

    /**
     * Get the root property: root.
     *
     * @return the root value.
     */
    public Map<String, Object> root() {
        return this.root;
    }

    /**
     * Set the root property: root.
     *
     * @param root the root value to set.
     * @return the MicrosoftGraphSite object itself.
     */
    public MicrosoftGraphSite withRoot(Map<String, Object> root) {
        this.root = root;
        return this;
    }

    /**
     * Get the sharepointIds property: sharepointIds.
     *
     * @return the sharepointIds value.
     */
    public MicrosoftGraphSharepointIds sharepointIds() {
        return this.sharepointIds;
    }

    /**
     * Set the sharepointIds property: sharepointIds.
     *
     * @param sharepointIds the sharepointIds value to set.
     * @return the MicrosoftGraphSite object itself.
     */
    public MicrosoftGraphSite withSharepointIds(MicrosoftGraphSharepointIds sharepointIds) {
        this.sharepointIds = sharepointIds;
        return this;
    }

    /**
     * Get the siteCollection property: siteCollection.
     *
     * @return the siteCollection value.
     */
    public MicrosoftGraphSiteCollection siteCollection() {
        return this.siteCollection;
    }

    /**
     * Set the siteCollection property: siteCollection.
     *
     * @param siteCollection the siteCollection value to set.
     * @return the MicrosoftGraphSite object itself.
     */
    public MicrosoftGraphSite withSiteCollection(MicrosoftGraphSiteCollection siteCollection) {
        this.siteCollection = siteCollection;
        return this;
    }

    /**
     * Get the analytics property: itemAnalytics.
     *
     * @return the analytics value.
     */
    public MicrosoftGraphItemAnalytics analytics() {
        return this.analytics;
    }

    /**
     * Set the analytics property: itemAnalytics.
     *
     * @param analytics the analytics value to set.
     * @return the MicrosoftGraphSite object itself.
     */
    public MicrosoftGraphSite withAnalytics(MicrosoftGraphItemAnalytics analytics) {
        this.analytics = analytics;
        return this;
    }

    /**
     * Get the columns property: The collection of column definitions reusable across lists under this site.
     *
     * @return the columns value.
     */
    public List<MicrosoftGraphColumnDefinition> columns() {
        return this.columns;
    }

    /**
     * Set the columns property: The collection of column definitions reusable across lists under this site.
     *
     * @param columns the columns value to set.
     * @return the MicrosoftGraphSite object itself.
     */
    public MicrosoftGraphSite withColumns(List<MicrosoftGraphColumnDefinition> columns) {
        this.columns = columns;
        return this;
    }

    /**
     * Get the contentTypes property: The collection of content types defined for this site.
     *
     * @return the contentTypes value.
     */
    public List<MicrosoftGraphContentType> contentTypes() {
        return this.contentTypes;
    }

    /**
     * Set the contentTypes property: The collection of content types defined for this site.
     *
     * @param contentTypes the contentTypes value to set.
     * @return the MicrosoftGraphSite object itself.
     */
    public MicrosoftGraphSite withContentTypes(List<MicrosoftGraphContentType> contentTypes) {
        this.contentTypes = contentTypes;
        return this;
    }

    /**
     * Get the drive property: drive.
     *
     * @return the drive value.
     */
    public MicrosoftGraphDrive drive() {
        return this.drive;
    }

    /**
     * Set the drive property: drive.
     *
     * @param drive the drive value to set.
     * @return the MicrosoftGraphSite object itself.
     */
    public MicrosoftGraphSite withDrive(MicrosoftGraphDrive drive) {
        this.drive = drive;
        return this;
    }

    /**
     * Get the drives property: The collection of drives (document libraries) under this site.
     *
     * @return the drives value.
     */
    public List<MicrosoftGraphDrive> drives() {
        return this.drives;
    }

    /**
     * Set the drives property: The collection of drives (document libraries) under this site.
     *
     * @param drives the drives value to set.
     * @return the MicrosoftGraphSite object itself.
     */
    public MicrosoftGraphSite withDrives(List<MicrosoftGraphDrive> drives) {
        this.drives = drives;
        return this;
    }

    /**
     * Get the items property: Used to address any item contained in this site. This collection cannot be enumerated.
     *
     * @return the items value.
     */
    public List<MicrosoftGraphBaseItemInner> items() {
        return this.items;
    }

    /**
     * Set the items property: Used to address any item contained in this site. This collection cannot be enumerated.
     *
     * @param items the items value to set.
     * @return the MicrosoftGraphSite object itself.
     */
    public MicrosoftGraphSite withItems(List<MicrosoftGraphBaseItemInner> items) {
        this.items = items;
        return this;
    }

    /**
     * Get the lists property: The collection of lists under this site.
     *
     * @return the lists value.
     */
    public List<MicrosoftGraphList> lists() {
        return this.lists;
    }

    /**
     * Set the lists property: The collection of lists under this site.
     *
     * @param lists the lists value to set.
     * @return the MicrosoftGraphSite object itself.
     */
    public MicrosoftGraphSite withLists(List<MicrosoftGraphList> lists) {
        this.lists = lists;
        return this;
    }

    /**
     * Get the sites property: The collection of the sub-sites under this site.
     *
     * @return the sites value.
     */
    public List<MicrosoftGraphSite> sites() {
        return this.sites;
    }

    /**
     * Set the sites property: The collection of the sub-sites under this site.
     *
     * @param sites the sites value to set.
     * @return the MicrosoftGraphSite object itself.
     */
    public MicrosoftGraphSite withSites(List<MicrosoftGraphSite> sites) {
        this.sites = sites;
        return this;
    }

    /**
     * Get the onenote property: onenote.
     *
     * @return the onenote value.
     */
    public MicrosoftGraphOnenote onenote() {
        return this.onenote;
    }

    /**
     * Set the onenote property: onenote.
     *
     * @param onenote the onenote value to set.
     * @return the MicrosoftGraphSite object itself.
     */
    public MicrosoftGraphSite withOnenote(MicrosoftGraphOnenote onenote) {
        this.onenote = onenote;
        return this;
    }

    /**
     * Get the additionalProperties property: site.
     *
     * @return the additionalProperties value.
     */
    @JsonAnyGetter
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: site.
     *
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphSite object itself.
     */
    public MicrosoftGraphSite withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @JsonAnySetter
    void withAdditionalProperties(String key, Object value) {
        if (additionalProperties == null) {
            additionalProperties = new HashMap<>();
        }
        additionalProperties.put(key, value);
    }

    /** {@inheritDoc} */
    @Override
    public MicrosoftGraphSite withCreatedBy(MicrosoftGraphIdentitySet createdBy) {
        super.withCreatedBy(createdBy);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public MicrosoftGraphSite withCreatedDateTime(OffsetDateTime createdDateTime) {
        super.withCreatedDateTime(createdDateTime);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public MicrosoftGraphSite withDescription(String description) {
        super.withDescription(description);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public MicrosoftGraphSite withEtag(String etag) {
        super.withEtag(etag);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public MicrosoftGraphSite withLastModifiedBy(MicrosoftGraphIdentitySet lastModifiedBy) {
        super.withLastModifiedBy(lastModifiedBy);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public MicrosoftGraphSite withLastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
        super.withLastModifiedDateTime(lastModifiedDateTime);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public MicrosoftGraphSite withName(String name) {
        super.withName(name);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public MicrosoftGraphSite withParentReference(MicrosoftGraphItemReference parentReference) {
        super.withParentReference(parentReference);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public MicrosoftGraphSite withWebUrl(String webUrl) {
        super.withWebUrl(webUrl);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public MicrosoftGraphSite withCreatedByUser(MicrosoftGraphUserInner createdByUser) {
        super.withCreatedByUser(createdByUser);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public MicrosoftGraphSite withLastModifiedByUser(MicrosoftGraphUserInner lastModifiedByUser) {
        super.withLastModifiedByUser(lastModifiedByUser);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public MicrosoftGraphSite withId(String id) {
        super.withId(id);
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (error() != null) {
            error().validate();
        }
        if (sharepointIds() != null) {
            sharepointIds().validate();
        }
        if (siteCollection() != null) {
            siteCollection().validate();
        }
        if (analytics() != null) {
            analytics().validate();
        }
        if (columns() != null) {
            columns().forEach(e -> e.validate());
        }
        if (contentTypes() != null) {
            contentTypes().forEach(e -> e.validate());
        }
        if (drive() != null) {
            drive().validate();
        }
        if (drives() != null) {
            drives().forEach(e -> e.validate());
        }
        if (items() != null) {
            items().forEach(e -> e.validate());
        }
        if (lists() != null) {
            lists().forEach(e -> e.validate());
        }
        if (sites() != null) {
            sites().forEach(e -> e.validate());
        }
        if (onenote() != null) {
            onenote().validate();
        }
    }
}
