// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashMap;
import java.util.Map;

/** teamGuestSettings. */
@Fluent
public final class MicrosoftGraphTeamGuestSettings {
    /*
     * If set to true, guests can add and update channels.
     */
    @JsonProperty(value = "allowCreateUpdateChannels")
    private Boolean allowCreateUpdateChannels;

    /*
     * If set to true, guests can delete channels.
     */
    @JsonProperty(value = "allowDeleteChannels")
    private Boolean allowDeleteChannels;

    /*
     * teamGuestSettings
     */
    @JsonIgnore private Map<String, Object> additionalProperties;

    /** Creates an instance of MicrosoftGraphTeamGuestSettings class. */
    public MicrosoftGraphTeamGuestSettings() {
    }

    /**
     * Get the allowCreateUpdateChannels property: If set to true, guests can add and update channels.
     *
     * @return the allowCreateUpdateChannels value.
     */
    public Boolean allowCreateUpdateChannels() {
        return this.allowCreateUpdateChannels;
    }

    /**
     * Set the allowCreateUpdateChannels property: If set to true, guests can add and update channels.
     *
     * @param allowCreateUpdateChannels the allowCreateUpdateChannels value to set.
     * @return the MicrosoftGraphTeamGuestSettings object itself.
     */
    public MicrosoftGraphTeamGuestSettings withAllowCreateUpdateChannels(Boolean allowCreateUpdateChannels) {
        this.allowCreateUpdateChannels = allowCreateUpdateChannels;
        return this;
    }

    /**
     * Get the allowDeleteChannels property: If set to true, guests can delete channels.
     *
     * @return the allowDeleteChannels value.
     */
    public Boolean allowDeleteChannels() {
        return this.allowDeleteChannels;
    }

    /**
     * Set the allowDeleteChannels property: If set to true, guests can delete channels.
     *
     * @param allowDeleteChannels the allowDeleteChannels value to set.
     * @return the MicrosoftGraphTeamGuestSettings object itself.
     */
    public MicrosoftGraphTeamGuestSettings withAllowDeleteChannels(Boolean allowDeleteChannels) {
        this.allowDeleteChannels = allowDeleteChannels;
        return this;
    }

    /**
     * Get the additionalProperties property: teamGuestSettings.
     *
     * @return the additionalProperties value.
     */
    @JsonAnyGetter
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: teamGuestSettings.
     *
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphTeamGuestSettings object itself.
     */
    public MicrosoftGraphTeamGuestSettings withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @JsonAnySetter
    void withAdditionalProperties(String key, Object value) {
        if (additionalProperties == null) {
            additionalProperties = new HashMap<>();
        }
        additionalProperties.put(key, value);
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
