// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashMap;
import java.util.Map;

/** workbookChartAxis. */
@Fluent
public final class MicrosoftGraphWorkbookChartAxis extends MicrosoftGraphEntity {
    /*
     * Json
     */
    @JsonProperty(value = "majorUnit")
    @JsonInclude(value = JsonInclude.Include.NON_NULL, content = JsonInclude.Include.ALWAYS)
    private Map<String, Object> majorUnit;

    /*
     * Json
     */
    @JsonProperty(value = "maximum")
    @JsonInclude(value = JsonInclude.Include.NON_NULL, content = JsonInclude.Include.ALWAYS)
    private Map<String, Object> maximum;

    /*
     * Json
     */
    @JsonProperty(value = "minimum")
    @JsonInclude(value = JsonInclude.Include.NON_NULL, content = JsonInclude.Include.ALWAYS)
    private Map<String, Object> minimum;

    /*
     * Json
     */
    @JsonProperty(value = "minorUnit")
    @JsonInclude(value = JsonInclude.Include.NON_NULL, content = JsonInclude.Include.ALWAYS)
    private Map<String, Object> minorUnit;

    /*
     * workbookChartAxisFormat
     */
    @JsonProperty(value = "format")
    private MicrosoftGraphWorkbookChartAxisFormat format;

    /*
     * workbookChartGridlines
     */
    @JsonProperty(value = "majorGridlines")
    private MicrosoftGraphWorkbookChartGridlines majorGridlines;

    /*
     * workbookChartGridlines
     */
    @JsonProperty(value = "minorGridlines")
    private MicrosoftGraphWorkbookChartGridlines minorGridlines;

    /*
     * workbookChartAxisTitle
     */
    @JsonProperty(value = "title")
    private MicrosoftGraphWorkbookChartAxisTitle title;

    /*
     * workbookChartAxis
     */
    @JsonIgnore private Map<String, Object> additionalProperties;

    /** Creates an instance of MicrosoftGraphWorkbookChartAxis class. */
    public MicrosoftGraphWorkbookChartAxis() {
    }

    /**
     * Get the majorUnit property: Json.
     *
     * @return the majorUnit value.
     */
    public Map<String, Object> majorUnit() {
        return this.majorUnit;
    }

    /**
     * Set the majorUnit property: Json.
     *
     * @param majorUnit the majorUnit value to set.
     * @return the MicrosoftGraphWorkbookChartAxis object itself.
     */
    public MicrosoftGraphWorkbookChartAxis withMajorUnit(Map<String, Object> majorUnit) {
        this.majorUnit = majorUnit;
        return this;
    }

    /**
     * Get the maximum property: Json.
     *
     * @return the maximum value.
     */
    public Map<String, Object> maximum() {
        return this.maximum;
    }

    /**
     * Set the maximum property: Json.
     *
     * @param maximum the maximum value to set.
     * @return the MicrosoftGraphWorkbookChartAxis object itself.
     */
    public MicrosoftGraphWorkbookChartAxis withMaximum(Map<String, Object> maximum) {
        this.maximum = maximum;
        return this;
    }

    /**
     * Get the minimum property: Json.
     *
     * @return the minimum value.
     */
    public Map<String, Object> minimum() {
        return this.minimum;
    }

    /**
     * Set the minimum property: Json.
     *
     * @param minimum the minimum value to set.
     * @return the MicrosoftGraphWorkbookChartAxis object itself.
     */
    public MicrosoftGraphWorkbookChartAxis withMinimum(Map<String, Object> minimum) {
        this.minimum = minimum;
        return this;
    }

    /**
     * Get the minorUnit property: Json.
     *
     * @return the minorUnit value.
     */
    public Map<String, Object> minorUnit() {
        return this.minorUnit;
    }

    /**
     * Set the minorUnit property: Json.
     *
     * @param minorUnit the minorUnit value to set.
     * @return the MicrosoftGraphWorkbookChartAxis object itself.
     */
    public MicrosoftGraphWorkbookChartAxis withMinorUnit(Map<String, Object> minorUnit) {
        this.minorUnit = minorUnit;
        return this;
    }

    /**
     * Get the format property: workbookChartAxisFormat.
     *
     * @return the format value.
     */
    public MicrosoftGraphWorkbookChartAxisFormat format() {
        return this.format;
    }

    /**
     * Set the format property: workbookChartAxisFormat.
     *
     * @param format the format value to set.
     * @return the MicrosoftGraphWorkbookChartAxis object itself.
     */
    public MicrosoftGraphWorkbookChartAxis withFormat(MicrosoftGraphWorkbookChartAxisFormat format) {
        this.format = format;
        return this;
    }

    /**
     * Get the majorGridlines property: workbookChartGridlines.
     *
     * @return the majorGridlines value.
     */
    public MicrosoftGraphWorkbookChartGridlines majorGridlines() {
        return this.majorGridlines;
    }

    /**
     * Set the majorGridlines property: workbookChartGridlines.
     *
     * @param majorGridlines the majorGridlines value to set.
     * @return the MicrosoftGraphWorkbookChartAxis object itself.
     */
    public MicrosoftGraphWorkbookChartAxis withMajorGridlines(MicrosoftGraphWorkbookChartGridlines majorGridlines) {
        this.majorGridlines = majorGridlines;
        return this;
    }

    /**
     * Get the minorGridlines property: workbookChartGridlines.
     *
     * @return the minorGridlines value.
     */
    public MicrosoftGraphWorkbookChartGridlines minorGridlines() {
        return this.minorGridlines;
    }

    /**
     * Set the minorGridlines property: workbookChartGridlines.
     *
     * @param minorGridlines the minorGridlines value to set.
     * @return the MicrosoftGraphWorkbookChartAxis object itself.
     */
    public MicrosoftGraphWorkbookChartAxis withMinorGridlines(MicrosoftGraphWorkbookChartGridlines minorGridlines) {
        this.minorGridlines = minorGridlines;
        return this;
    }

    /**
     * Get the title property: workbookChartAxisTitle.
     *
     * @return the title value.
     */
    public MicrosoftGraphWorkbookChartAxisTitle title() {
        return this.title;
    }

    /**
     * Set the title property: workbookChartAxisTitle.
     *
     * @param title the title value to set.
     * @return the MicrosoftGraphWorkbookChartAxis object itself.
     */
    public MicrosoftGraphWorkbookChartAxis withTitle(MicrosoftGraphWorkbookChartAxisTitle title) {
        this.title = title;
        return this;
    }

    /**
     * Get the additionalProperties property: workbookChartAxis.
     *
     * @return the additionalProperties value.
     */
    @JsonAnyGetter
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: workbookChartAxis.
     *
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphWorkbookChartAxis object itself.
     */
    public MicrosoftGraphWorkbookChartAxis withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @JsonAnySetter
    void withAdditionalProperties(String key, Object value) {
        if (additionalProperties == null) {
            additionalProperties = new HashMap<>();
        }
        additionalProperties.put(key, value);
    }

    /** {@inheritDoc} */
    @Override
    public MicrosoftGraphWorkbookChartAxis withId(String id) {
        super.withId(id);
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (format() != null) {
            format().validate();
        }
        if (majorGridlines() != null) {
            majorGridlines().validate();
        }
        if (minorGridlines() != null) {
            minorGridlines().validate();
        }
        if (title() != null) {
            title().validate();
        }
    }
}
