// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashMap;
import java.util.Map;

/** workbookTableColumn. */
@Fluent
public final class MicrosoftGraphWorkbookTableColumn extends MicrosoftGraphEntity {
    /*
     * Returns the index number of the column within the columns collection of the table. Zero-indexed. Read-only.
     */
    @JsonProperty(value = "index")
    private Integer index;

    /*
     * Returns the name of the table column.
     */
    @JsonProperty(value = "name")
    private String name;

    /*
     * Json
     */
    @JsonProperty(value = "values")
    @JsonInclude(value = JsonInclude.Include.NON_NULL, content = JsonInclude.Include.ALWAYS)
    private Map<String, Object> values;

    /*
     * workbookFilter
     */
    @JsonProperty(value = "filter")
    private MicrosoftGraphWorkbookFilter filter;

    /*
     * workbookTableColumn
     */
    @JsonIgnore private Map<String, Object> additionalProperties;

    /** Creates an instance of MicrosoftGraphWorkbookTableColumn class. */
    public MicrosoftGraphWorkbookTableColumn() {
    }

    /**
     * Get the index property: Returns the index number of the column within the columns collection of the table.
     * Zero-indexed. Read-only.
     *
     * @return the index value.
     */
    public Integer index() {
        return this.index;
    }

    /**
     * Set the index property: Returns the index number of the column within the columns collection of the table.
     * Zero-indexed. Read-only.
     *
     * @param index the index value to set.
     * @return the MicrosoftGraphWorkbookTableColumn object itself.
     */
    public MicrosoftGraphWorkbookTableColumn withIndex(Integer index) {
        this.index = index;
        return this;
    }

    /**
     * Get the name property: Returns the name of the table column.
     *
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: Returns the name of the table column.
     *
     * @param name the name value to set.
     * @return the MicrosoftGraphWorkbookTableColumn object itself.
     */
    public MicrosoftGraphWorkbookTableColumn withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the values property: Json.
     *
     * @return the values value.
     */
    public Map<String, Object> values() {
        return this.values;
    }

    /**
     * Set the values property: Json.
     *
     * @param values the values value to set.
     * @return the MicrosoftGraphWorkbookTableColumn object itself.
     */
    public MicrosoftGraphWorkbookTableColumn withValues(Map<String, Object> values) {
        this.values = values;
        return this;
    }

    /**
     * Get the filter property: workbookFilter.
     *
     * @return the filter value.
     */
    public MicrosoftGraphWorkbookFilter filter() {
        return this.filter;
    }

    /**
     * Set the filter property: workbookFilter.
     *
     * @param filter the filter value to set.
     * @return the MicrosoftGraphWorkbookTableColumn object itself.
     */
    public MicrosoftGraphWorkbookTableColumn withFilter(MicrosoftGraphWorkbookFilter filter) {
        this.filter = filter;
        return this;
    }

    /**
     * Get the additionalProperties property: workbookTableColumn.
     *
     * @return the additionalProperties value.
     */
    @JsonAnyGetter
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: workbookTableColumn.
     *
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphWorkbookTableColumn object itself.
     */
    public MicrosoftGraphWorkbookTableColumn withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @JsonAnySetter
    void withAdditionalProperties(String key, Object value) {
        if (additionalProperties == null) {
            additionalProperties = new HashMap<>();
        }
        additionalProperties.put(key, value);
    }

    /** {@inheritDoc} */
    @Override
    public MicrosoftGraphWorkbookTableColumn withId(String id) {
        super.withId(id);
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (filter() != null) {
            filter().validate();
        }
    }
}
