// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.resourcemanager.authorization.fluent.RoleManagementPolicyAssignmentsClient;
import com.azure.resourcemanager.authorization.fluent.models.RoleManagementPolicyAssignmentInner;
import com.azure.resourcemanager.authorization.models.RoleManagementPolicyAssignmentListResult;
import com.azure.resourcemanager.resources.fluentcore.collection.InnerSupportsDelete;
import reactor.core.publisher.Mono;

/** An instance of this class provides access to all the operations defined in RoleManagementPolicyAssignmentsClient. */
public final class RoleManagementPolicyAssignmentsClientImpl
    implements InnerSupportsDelete<Void>, RoleManagementPolicyAssignmentsClient {
    /** The proxy service used to perform REST calls. */
    private final RoleManagementPolicyAssignmentsService service;

    /** The service client containing this operation class. */
    private final AuthorizationManagementClientImpl client;

    /**
     * Initializes an instance of RoleManagementPolicyAssignmentsClientImpl.
     *
     * @param client the instance of the service client containing this operation class.
     */
    RoleManagementPolicyAssignmentsClientImpl(AuthorizationManagementClientImpl client) {
        this.service =
            RestProxy
                .create(
                    RoleManagementPolicyAssignmentsService.class,
                    client.getHttpPipeline(),
                    client.getSerializerAdapter());
        this.client = client;
    }

    /**
     * The interface defining all the services for AuthorizationManagementClientRoleManagementPolicyAssignments to be
     * used by the proxy service to perform REST calls.
     */
    @Host("{$host}")
    @ServiceInterface(name = "AuthorizationManagem")
    public interface RoleManagementPolicyAssignmentsService {
        @Headers({"Content-Type: application/json"})
        @Get(
            "/{scope}/providers/Microsoft.Authorization/roleManagementPolicyAssignments/{roleManagementPolicyAssignmentName}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<RoleManagementPolicyAssignmentInner>> get(
            @HostParam("$host") String endpoint,
            @PathParam(value = "scope", encoded = true) String scope,
            @PathParam("roleManagementPolicyAssignmentName") String roleManagementPolicyAssignmentName,
            @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Put(
            "/{scope}/providers/Microsoft.Authorization/roleManagementPolicyAssignments/{roleManagementPolicyAssignmentName}")
        @ExpectedResponses({201})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<RoleManagementPolicyAssignmentInner>> create(
            @HostParam("$host") String endpoint,
            @PathParam(value = "scope", encoded = true) String scope,
            @PathParam("roleManagementPolicyAssignmentName") String roleManagementPolicyAssignmentName,
            @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") RoleManagementPolicyAssignmentInner parameters,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Delete(
            "/{scope}/providers/Microsoft.Authorization/roleManagementPolicyAssignments/{roleManagementPolicyAssignmentName}")
        @ExpectedResponses({200, 204})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<Void>> delete(
            @HostParam("$host") String endpoint,
            @PathParam(value = "scope", encoded = true) String scope,
            @PathParam("roleManagementPolicyAssignmentName") String roleManagementPolicyAssignmentName,
            @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Get("/{scope}/providers/Microsoft.Authorization/roleManagementPolicyAssignments")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<RoleManagementPolicyAssignmentListResult>> listForScope(
            @HostParam("$host") String endpoint,
            @PathParam(value = "scope", encoded = true) String scope,
            @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Get("{nextLink}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<RoleManagementPolicyAssignmentListResult>> listForScopeNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink,
            @HostParam("$host") String endpoint,
            @HeaderParam("Accept") String accept,
            Context context);
    }

    /**
     * Get the specified role management policy assignment for a resource scope.
     *
     * @param scope The scope of the role management policy.
     * @param roleManagementPolicyAssignmentName The name of format {guid_guid} the role management policy assignment to
     *     get.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the specified role management policy assignment for a resource scope along with {@link Response} on
     *     successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<RoleManagementPolicyAssignmentInner>> getWithResponseAsync(
        String scope, String roleManagementPolicyAssignmentName) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (scope == null) {
            return Mono.error(new IllegalArgumentException("Parameter scope is required and cannot be null."));
        }
        if (roleManagementPolicyAssignmentName == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter roleManagementPolicyAssignmentName is required and cannot be null."));
        }
        final String apiVersion = "2020-10-01";
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .get(
                            this.client.getEndpoint(),
                            scope,
                            roleManagementPolicyAssignmentName,
                            apiVersion,
                            accept,
                            context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Get the specified role management policy assignment for a resource scope.
     *
     * @param scope The scope of the role management policy.
     * @param roleManagementPolicyAssignmentName The name of format {guid_guid} the role management policy assignment to
     *     get.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the specified role management policy assignment for a resource scope along with {@link Response} on
     *     successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<RoleManagementPolicyAssignmentInner>> getWithResponseAsync(
        String scope, String roleManagementPolicyAssignmentName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (scope == null) {
            return Mono.error(new IllegalArgumentException("Parameter scope is required and cannot be null."));
        }
        if (roleManagementPolicyAssignmentName == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter roleManagementPolicyAssignmentName is required and cannot be null."));
        }
        final String apiVersion = "2020-10-01";
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .get(this.client.getEndpoint(), scope, roleManagementPolicyAssignmentName, apiVersion, accept, context);
    }

    /**
     * Get the specified role management policy assignment for a resource scope.
     *
     * @param scope The scope of the role management policy.
     * @param roleManagementPolicyAssignmentName The name of format {guid_guid} the role management policy assignment to
     *     get.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the specified role management policy assignment for a resource scope on successful completion of {@link
     *     Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<RoleManagementPolicyAssignmentInner> getAsync(String scope, String roleManagementPolicyAssignmentName) {
        return getWithResponseAsync(scope, roleManagementPolicyAssignmentName)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Get the specified role management policy assignment for a resource scope.
     *
     * @param scope The scope of the role management policy.
     * @param roleManagementPolicyAssignmentName The name of format {guid_guid} the role management policy assignment to
     *     get.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the specified role management policy assignment for a resource scope along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<RoleManagementPolicyAssignmentInner> getWithResponse(
        String scope, String roleManagementPolicyAssignmentName, Context context) {
        return getWithResponseAsync(scope, roleManagementPolicyAssignmentName, context).block();
    }

    /**
     * Get the specified role management policy assignment for a resource scope.
     *
     * @param scope The scope of the role management policy.
     * @param roleManagementPolicyAssignmentName The name of format {guid_guid} the role management policy assignment to
     *     get.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the specified role management policy assignment for a resource scope.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public RoleManagementPolicyAssignmentInner get(String scope, String roleManagementPolicyAssignmentName) {
        return getWithResponse(scope, roleManagementPolicyAssignmentName, Context.NONE).getValue();
    }

    /**
     * Create a role management policy assignment.
     *
     * @param scope The scope of the role management policy assignment to upsert.
     * @param roleManagementPolicyAssignmentName The name of format {guid_guid} the role management policy assignment to
     *     upsert.
     * @param parameters Parameters for the role management policy assignment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return role management policy along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<RoleManagementPolicyAssignmentInner>> createWithResponseAsync(
        String scope, String roleManagementPolicyAssignmentName, RoleManagementPolicyAssignmentInner parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (scope == null) {
            return Mono.error(new IllegalArgumentException("Parameter scope is required and cannot be null."));
        }
        if (roleManagementPolicyAssignmentName == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter roleManagementPolicyAssignmentName is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error(new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        } else {
            parameters.validate();
        }
        final String apiVersion = "2020-10-01";
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .create(
                            this.client.getEndpoint(),
                            scope,
                            roleManagementPolicyAssignmentName,
                            apiVersion,
                            parameters,
                            accept,
                            context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Create a role management policy assignment.
     *
     * @param scope The scope of the role management policy assignment to upsert.
     * @param roleManagementPolicyAssignmentName The name of format {guid_guid} the role management policy assignment to
     *     upsert.
     * @param parameters Parameters for the role management policy assignment.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return role management policy along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<RoleManagementPolicyAssignmentInner>> createWithResponseAsync(
        String scope,
        String roleManagementPolicyAssignmentName,
        RoleManagementPolicyAssignmentInner parameters,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (scope == null) {
            return Mono.error(new IllegalArgumentException("Parameter scope is required and cannot be null."));
        }
        if (roleManagementPolicyAssignmentName == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter roleManagementPolicyAssignmentName is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error(new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        } else {
            parameters.validate();
        }
        final String apiVersion = "2020-10-01";
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .create(
                this.client.getEndpoint(),
                scope,
                roleManagementPolicyAssignmentName,
                apiVersion,
                parameters,
                accept,
                context);
    }

    /**
     * Create a role management policy assignment.
     *
     * @param scope The scope of the role management policy assignment to upsert.
     * @param roleManagementPolicyAssignmentName The name of format {guid_guid} the role management policy assignment to
     *     upsert.
     * @param parameters Parameters for the role management policy assignment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return role management policy on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<RoleManagementPolicyAssignmentInner> createAsync(
        String scope, String roleManagementPolicyAssignmentName, RoleManagementPolicyAssignmentInner parameters) {
        return createWithResponseAsync(scope, roleManagementPolicyAssignmentName, parameters)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Create a role management policy assignment.
     *
     * @param scope The scope of the role management policy assignment to upsert.
     * @param roleManagementPolicyAssignmentName The name of format {guid_guid} the role management policy assignment to
     *     upsert.
     * @param parameters Parameters for the role management policy assignment.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return role management policy along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<RoleManagementPolicyAssignmentInner> createWithResponse(
        String scope,
        String roleManagementPolicyAssignmentName,
        RoleManagementPolicyAssignmentInner parameters,
        Context context) {
        return createWithResponseAsync(scope, roleManagementPolicyAssignmentName, parameters, context).block();
    }

    /**
     * Create a role management policy assignment.
     *
     * @param scope The scope of the role management policy assignment to upsert.
     * @param roleManagementPolicyAssignmentName The name of format {guid_guid} the role management policy assignment to
     *     upsert.
     * @param parameters Parameters for the role management policy assignment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return role management policy.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public RoleManagementPolicyAssignmentInner create(
        String scope, String roleManagementPolicyAssignmentName, RoleManagementPolicyAssignmentInner parameters) {
        return createWithResponse(scope, roleManagementPolicyAssignmentName, parameters, Context.NONE).getValue();
    }

    /**
     * Delete a role management policy assignment.
     *
     * @param scope The scope of the role management policy assignment to delete.
     * @param roleManagementPolicyAssignmentName The name of format {guid_guid} the role management policy assignment to
     *     delete.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> deleteWithResponseAsync(String scope, String roleManagementPolicyAssignmentName) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (scope == null) {
            return Mono.error(new IllegalArgumentException("Parameter scope is required and cannot be null."));
        }
        if (roleManagementPolicyAssignmentName == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter roleManagementPolicyAssignmentName is required and cannot be null."));
        }
        final String apiVersion = "2020-10-01";
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .delete(
                            this.client.getEndpoint(),
                            scope,
                            roleManagementPolicyAssignmentName,
                            apiVersion,
                            accept,
                            context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Delete a role management policy assignment.
     *
     * @param scope The scope of the role management policy assignment to delete.
     * @param roleManagementPolicyAssignmentName The name of format {guid_guid} the role management policy assignment to
     *     delete.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Void>> deleteWithResponseAsync(
        String scope, String roleManagementPolicyAssignmentName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (scope == null) {
            return Mono.error(new IllegalArgumentException("Parameter scope is required and cannot be null."));
        }
        if (roleManagementPolicyAssignmentName == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter roleManagementPolicyAssignmentName is required and cannot be null."));
        }
        final String apiVersion = "2020-10-01";
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .delete(this.client.getEndpoint(), scope, roleManagementPolicyAssignmentName, apiVersion, accept, context);
    }

    /**
     * Delete a role management policy assignment.
     *
     * @param scope The scope of the role management policy assignment to delete.
     * @param roleManagementPolicyAssignmentName The name of format {guid_guid} the role management policy assignment to
     *     delete.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> deleteAsync(String scope, String roleManagementPolicyAssignmentName) {
        return deleteWithResponseAsync(scope, roleManagementPolicyAssignmentName).flatMap(ignored -> Mono.empty());
    }

    /**
     * Delete a role management policy assignment.
     *
     * @param scope The scope of the role management policy assignment to delete.
     * @param roleManagementPolicyAssignmentName The name of format {guid_guid} the role management policy assignment to
     *     delete.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> deleteWithResponse(String scope, String roleManagementPolicyAssignmentName, Context context) {
        return deleteWithResponseAsync(scope, roleManagementPolicyAssignmentName, context).block();
    }

    /**
     * Delete a role management policy assignment.
     *
     * @param scope The scope of the role management policy assignment to delete.
     * @param roleManagementPolicyAssignmentName The name of format {guid_guid} the role management policy assignment to
     *     delete.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void delete(String scope, String roleManagementPolicyAssignmentName) {
        deleteWithResponse(scope, roleManagementPolicyAssignmentName, Context.NONE);
    }

    /**
     * Gets role management assignment policies for a resource scope.
     *
     * @param scope The scope of the role management policy.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return role management assignment policies for a resource scope along with {@link PagedResponse} on successful
     *     completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<RoleManagementPolicyAssignmentInner>> listForScopeSinglePageAsync(String scope) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (scope == null) {
            return Mono.error(new IllegalArgumentException("Parameter scope is required and cannot be null."));
        }
        final String apiVersion = "2020-10-01";
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.listForScope(this.client.getEndpoint(), scope, apiVersion, accept, context))
            .<PagedResponse<RoleManagementPolicyAssignmentInner>>map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Gets role management assignment policies for a resource scope.
     *
     * @param scope The scope of the role management policy.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return role management assignment policies for a resource scope along with {@link PagedResponse} on successful
     *     completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<RoleManagementPolicyAssignmentInner>> listForScopeSinglePageAsync(
        String scope, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (scope == null) {
            return Mono.error(new IllegalArgumentException("Parameter scope is required and cannot be null."));
        }
        final String apiVersion = "2020-10-01";
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .listForScope(this.client.getEndpoint(), scope, apiVersion, accept, context)
            .map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null));
    }

    /**
     * Gets role management assignment policies for a resource scope.
     *
     * @param scope The scope of the role management policy.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return role management assignment policies for a resource scope as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<RoleManagementPolicyAssignmentInner> listForScopeAsync(String scope) {
        return new PagedFlux<>(
            () -> listForScopeSinglePageAsync(scope), nextLink -> listForScopeNextSinglePageAsync(nextLink));
    }

    /**
     * Gets role management assignment policies for a resource scope.
     *
     * @param scope The scope of the role management policy.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return role management assignment policies for a resource scope as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<RoleManagementPolicyAssignmentInner> listForScopeAsync(String scope, Context context) {
        return new PagedFlux<>(
            () -> listForScopeSinglePageAsync(scope, context),
            nextLink -> listForScopeNextSinglePageAsync(nextLink, context));
    }

    /**
     * Gets role management assignment policies for a resource scope.
     *
     * @param scope The scope of the role management policy.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return role management assignment policies for a resource scope as paginated response with {@link
     *     PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<RoleManagementPolicyAssignmentInner> listForScope(String scope) {
        return new PagedIterable<>(listForScopeAsync(scope));
    }

    /**
     * Gets role management assignment policies for a resource scope.
     *
     * @param scope The scope of the role management policy.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return role management assignment policies for a resource scope as paginated response with {@link
     *     PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<RoleManagementPolicyAssignmentInner> listForScope(String scope, Context context) {
        return new PagedIterable<>(listForScopeAsync(scope, context));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The URL to get the next list of items
     *     <p>The nextLink parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return role management policy assignment list operation result along with {@link PagedResponse} on successful
     *     completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<RoleManagementPolicyAssignmentInner>> listForScopeNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.listForScopeNext(nextLink, this.client.getEndpoint(), accept, context))
            .<PagedResponse<RoleManagementPolicyAssignmentInner>>map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The URL to get the next list of items
     *     <p>The nextLink parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return role management policy assignment list operation result along with {@link PagedResponse} on successful
     *     completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<RoleManagementPolicyAssignmentInner>> listForScopeNextSinglePageAsync(
        String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .listForScopeNext(nextLink, this.client.getEndpoint(), accept, context)
            .map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null));
    }
}
