// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/**
 * channel.
 */
@Fluent
public final class MicrosoftGraphChannel extends MicrosoftGraphEntity {
    /*
     * Optional textual description for the channel.
     */
    private String description;

    /*
     * Channel name as it will appear to the user in Microsoft Teams.
     */
    private String displayName;

    /*
     * The email address for sending messages to the channel. Read-only.
     */
    private String email;

    /*
     * Indicates whether the channel should be marked 'recommended' for all members of the team to show in their channel
     * list. Can only be set programmatically with Create team. Default: false. NOTE: All recommended channels will
     * automatically show in channels list for EDU and FLW users.
     */
    private Boolean isFavoriteByDefault;

    /*
     * channelMembershipType
     */
    private MicrosoftGraphChannelMembershipType membershipType;

    /*
     * A hyperlink that will go to the channel in Microsoft Teams. This is the URL that you get when you right-click a
     * channel in Microsoft Teams and select Get link to channel. This URL should be treated as an opaque blob, and not
     * parsed. Read-only.
     */
    private String webUrl;

    /*
     * driveItem
     */
    private MicrosoftGraphDriveItem filesFolder;

    /*
     * A collection of membership records associated with the channel.
     */
    private List<MicrosoftGraphConversationMember> members;

    /*
     * A collection of all the messages in the channel. A navigation property. Nullable.
     */
    private List<MicrosoftGraphChatMessage> messages;

    /*
     * A collection of all the tabs in the channel. A navigation property.
     */
    private List<MicrosoftGraphTeamsTab> tabs;

    /*
     * channel
     */
    private Map<String, Object> additionalProperties;

    /**
     * Creates an instance of MicrosoftGraphChannel class.
     */
    public MicrosoftGraphChannel() {
    }

    /**
     * Get the description property: Optional textual description for the channel.
     * 
     * @return the description value.
     */
    public String description() {
        return this.description;
    }

    /**
     * Set the description property: Optional textual description for the channel.
     * 
     * @param description the description value to set.
     * @return the MicrosoftGraphChannel object itself.
     */
    public MicrosoftGraphChannel withDescription(String description) {
        this.description = description;
        return this;
    }

    /**
     * Get the displayName property: Channel name as it will appear to the user in Microsoft Teams.
     * 
     * @return the displayName value.
     */
    public String displayName() {
        return this.displayName;
    }

    /**
     * Set the displayName property: Channel name as it will appear to the user in Microsoft Teams.
     * 
     * @param displayName the displayName value to set.
     * @return the MicrosoftGraphChannel object itself.
     */
    public MicrosoftGraphChannel withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    /**
     * Get the email property: The email address for sending messages to the channel. Read-only.
     * 
     * @return the email value.
     */
    public String email() {
        return this.email;
    }

    /**
     * Set the email property: The email address for sending messages to the channel. Read-only.
     * 
     * @param email the email value to set.
     * @return the MicrosoftGraphChannel object itself.
     */
    public MicrosoftGraphChannel withEmail(String email) {
        this.email = email;
        return this;
    }

    /**
     * Get the isFavoriteByDefault property: Indicates whether the channel should be marked 'recommended' for all
     * members of the team to show in their channel list. Can only be set programmatically with Create team. Default:
     * false. NOTE: All recommended channels will automatically show in channels list for EDU and FLW users.
     * 
     * @return the isFavoriteByDefault value.
     */
    public Boolean isFavoriteByDefault() {
        return this.isFavoriteByDefault;
    }

    /**
     * Set the isFavoriteByDefault property: Indicates whether the channel should be marked 'recommended' for all
     * members of the team to show in their channel list. Can only be set programmatically with Create team. Default:
     * false. NOTE: All recommended channels will automatically show in channels list for EDU and FLW users.
     * 
     * @param isFavoriteByDefault the isFavoriteByDefault value to set.
     * @return the MicrosoftGraphChannel object itself.
     */
    public MicrosoftGraphChannel withIsFavoriteByDefault(Boolean isFavoriteByDefault) {
        this.isFavoriteByDefault = isFavoriteByDefault;
        return this;
    }

    /**
     * Get the membershipType property: channelMembershipType.
     * 
     * @return the membershipType value.
     */
    public MicrosoftGraphChannelMembershipType membershipType() {
        return this.membershipType;
    }

    /**
     * Set the membershipType property: channelMembershipType.
     * 
     * @param membershipType the membershipType value to set.
     * @return the MicrosoftGraphChannel object itself.
     */
    public MicrosoftGraphChannel withMembershipType(MicrosoftGraphChannelMembershipType membershipType) {
        this.membershipType = membershipType;
        return this;
    }

    /**
     * Get the webUrl property: A hyperlink that will go to the channel in Microsoft Teams. This is the URL that you get
     * when you right-click a channel in Microsoft Teams and select Get link to channel. This URL should be treated as
     * an opaque blob, and not parsed. Read-only.
     * 
     * @return the webUrl value.
     */
    public String webUrl() {
        return this.webUrl;
    }

    /**
     * Set the webUrl property: A hyperlink that will go to the channel in Microsoft Teams. This is the URL that you get
     * when you right-click a channel in Microsoft Teams and select Get link to channel. This URL should be treated as
     * an opaque blob, and not parsed. Read-only.
     * 
     * @param webUrl the webUrl value to set.
     * @return the MicrosoftGraphChannel object itself.
     */
    public MicrosoftGraphChannel withWebUrl(String webUrl) {
        this.webUrl = webUrl;
        return this;
    }

    /**
     * Get the filesFolder property: driveItem.
     * 
     * @return the filesFolder value.
     */
    public MicrosoftGraphDriveItem filesFolder() {
        return this.filesFolder;
    }

    /**
     * Set the filesFolder property: driveItem.
     * 
     * @param filesFolder the filesFolder value to set.
     * @return the MicrosoftGraphChannel object itself.
     */
    public MicrosoftGraphChannel withFilesFolder(MicrosoftGraphDriveItem filesFolder) {
        this.filesFolder = filesFolder;
        return this;
    }

    /**
     * Get the members property: A collection of membership records associated with the channel.
     * 
     * @return the members value.
     */
    public List<MicrosoftGraphConversationMember> members() {
        return this.members;
    }

    /**
     * Set the members property: A collection of membership records associated with the channel.
     * 
     * @param members the members value to set.
     * @return the MicrosoftGraphChannel object itself.
     */
    public MicrosoftGraphChannel withMembers(List<MicrosoftGraphConversationMember> members) {
        this.members = members;
        return this;
    }

    /**
     * Get the messages property: A collection of all the messages in the channel. A navigation property. Nullable.
     * 
     * @return the messages value.
     */
    public List<MicrosoftGraphChatMessage> messages() {
        return this.messages;
    }

    /**
     * Set the messages property: A collection of all the messages in the channel. A navigation property. Nullable.
     * 
     * @param messages the messages value to set.
     * @return the MicrosoftGraphChannel object itself.
     */
    public MicrosoftGraphChannel withMessages(List<MicrosoftGraphChatMessage> messages) {
        this.messages = messages;
        return this;
    }

    /**
     * Get the tabs property: A collection of all the tabs in the channel. A navigation property.
     * 
     * @return the tabs value.
     */
    public List<MicrosoftGraphTeamsTab> tabs() {
        return this.tabs;
    }

    /**
     * Set the tabs property: A collection of all the tabs in the channel. A navigation property.
     * 
     * @param tabs the tabs value to set.
     * @return the MicrosoftGraphChannel object itself.
     */
    public MicrosoftGraphChannel withTabs(List<MicrosoftGraphTeamsTab> tabs) {
        this.tabs = tabs;
        return this;
    }

    /**
     * Get the additionalProperties property: channel.
     * 
     * @return the additionalProperties value.
     */
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: channel.
     * 
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphChannel object itself.
     */
    public MicrosoftGraphChannel withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public MicrosoftGraphChannel withId(String id) {
        super.withId(id);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (filesFolder() != null) {
            filesFolder().validate();
        }
        if (members() != null) {
            members().forEach(e -> e.validate());
        }
        if (messages() != null) {
            messages().forEach(e -> e.validate());
        }
        if (tabs() != null) {
            tabs().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", id());
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeStringField("displayName", this.displayName);
        jsonWriter.writeStringField("email", this.email);
        jsonWriter.writeBooleanField("isFavoriteByDefault", this.isFavoriteByDefault);
        jsonWriter.writeStringField("membershipType",
            this.membershipType == null ? null : this.membershipType.toString());
        jsonWriter.writeStringField("webUrl", this.webUrl);
        jsonWriter.writeJsonField("filesFolder", this.filesFolder);
        jsonWriter.writeArrayField("members", this.members, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("messages", this.messages, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("tabs", this.tabs, (writer, element) -> writer.writeJson(element));
        if (additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MicrosoftGraphChannel from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MicrosoftGraphChannel if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the MicrosoftGraphChannel.
     */
    public static MicrosoftGraphChannel fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MicrosoftGraphChannel deserializedMicrosoftGraphChannel = new MicrosoftGraphChannel();
            Map<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedMicrosoftGraphChannel.withId(reader.getString());
                } else if ("description".equals(fieldName)) {
                    deserializedMicrosoftGraphChannel.description = reader.getString();
                } else if ("displayName".equals(fieldName)) {
                    deserializedMicrosoftGraphChannel.displayName = reader.getString();
                } else if ("email".equals(fieldName)) {
                    deserializedMicrosoftGraphChannel.email = reader.getString();
                } else if ("isFavoriteByDefault".equals(fieldName)) {
                    deserializedMicrosoftGraphChannel.isFavoriteByDefault = reader.getNullable(JsonReader::getBoolean);
                } else if ("membershipType".equals(fieldName)) {
                    deserializedMicrosoftGraphChannel.membershipType
                        = MicrosoftGraphChannelMembershipType.fromString(reader.getString());
                } else if ("webUrl".equals(fieldName)) {
                    deserializedMicrosoftGraphChannel.webUrl = reader.getString();
                } else if ("filesFolder".equals(fieldName)) {
                    deserializedMicrosoftGraphChannel.filesFolder = MicrosoftGraphDriveItem.fromJson(reader);
                } else if ("members".equals(fieldName)) {
                    List<MicrosoftGraphConversationMember> members
                        = reader.readArray(reader1 -> MicrosoftGraphConversationMember.fromJson(reader1));
                    deserializedMicrosoftGraphChannel.members = members;
                } else if ("messages".equals(fieldName)) {
                    List<MicrosoftGraphChatMessage> messages
                        = reader.readArray(reader1 -> MicrosoftGraphChatMessage.fromJson(reader1));
                    deserializedMicrosoftGraphChannel.messages = messages;
                } else if ("tabs".equals(fieldName)) {
                    List<MicrosoftGraphTeamsTab> tabs
                        = reader.readArray(reader1 -> MicrosoftGraphTeamsTab.fromJson(reader1));
                    deserializedMicrosoftGraphChannel.tabs = tabs;
                } else {
                    if (additionalProperties == null) {
                        additionalProperties = new LinkedHashMap<>();
                    }

                    additionalProperties.put(fieldName, reader.readUntyped());
                }
            }
            deserializedMicrosoftGraphChannel.additionalProperties = additionalProperties;

            return deserializedMicrosoftGraphChannel;
        });
    }
}
