// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/**
 * conversation.
 */
@Fluent
public final class MicrosoftGraphConversation extends MicrosoftGraphEntity {
    /*
     * Indicates whether any of the posts within this Conversation has at least one attachment.
     */
    private Boolean hasAttachments;

    /*
     * The Timestamp type represents date and time information using ISO 8601 format and is always in UTC time. For
     * example, midnight UTC on Jan 1, 2014 would look like this: '2014-01-01T00:00:00Z'
     */
    private OffsetDateTime lastDeliveredDateTime;

    /*
     * A short summary from the body of the latest post in this converstaion.
     */
    private String preview;

    /*
     * The topic of the conversation. This property can be set when the conversation is created, but it cannot be
     * updated.
     */
    private String topic;

    /*
     * All the users that sent a message to this Conversation.
     */
    private List<String> uniqueSenders;

    /*
     * A collection of all the conversation threads in the conversation. A navigation property. Read-only. Nullable.
     */
    private List<MicrosoftGraphConversationThread> threads;

    /*
     * conversation
     */
    private Map<String, Object> additionalProperties;

    /**
     * Creates an instance of MicrosoftGraphConversation class.
     */
    public MicrosoftGraphConversation() {
    }

    /**
     * Get the hasAttachments property: Indicates whether any of the posts within this Conversation has at least one
     * attachment.
     * 
     * @return the hasAttachments value.
     */
    public Boolean hasAttachments() {
        return this.hasAttachments;
    }

    /**
     * Set the hasAttachments property: Indicates whether any of the posts within this Conversation has at least one
     * attachment.
     * 
     * @param hasAttachments the hasAttachments value to set.
     * @return the MicrosoftGraphConversation object itself.
     */
    public MicrosoftGraphConversation withHasAttachments(Boolean hasAttachments) {
        this.hasAttachments = hasAttachments;
        return this;
    }

    /**
     * Get the lastDeliveredDateTime property: The Timestamp type represents date and time information using ISO 8601
     * format and is always in UTC time. For example, midnight UTC on Jan 1, 2014 would look like this:
     * '2014-01-01T00:00:00Z'.
     * 
     * @return the lastDeliveredDateTime value.
     */
    public OffsetDateTime lastDeliveredDateTime() {
        return this.lastDeliveredDateTime;
    }

    /**
     * Set the lastDeliveredDateTime property: The Timestamp type represents date and time information using ISO 8601
     * format and is always in UTC time. For example, midnight UTC on Jan 1, 2014 would look like this:
     * '2014-01-01T00:00:00Z'.
     * 
     * @param lastDeliveredDateTime the lastDeliveredDateTime value to set.
     * @return the MicrosoftGraphConversation object itself.
     */
    public MicrosoftGraphConversation withLastDeliveredDateTime(OffsetDateTime lastDeliveredDateTime) {
        this.lastDeliveredDateTime = lastDeliveredDateTime;
        return this;
    }

    /**
     * Get the preview property: A short summary from the body of the latest post in this converstaion.
     * 
     * @return the preview value.
     */
    public String preview() {
        return this.preview;
    }

    /**
     * Set the preview property: A short summary from the body of the latest post in this converstaion.
     * 
     * @param preview the preview value to set.
     * @return the MicrosoftGraphConversation object itself.
     */
    public MicrosoftGraphConversation withPreview(String preview) {
        this.preview = preview;
        return this;
    }

    /**
     * Get the topic property: The topic of the conversation. This property can be set when the conversation is created,
     * but it cannot be updated.
     * 
     * @return the topic value.
     */
    public String topic() {
        return this.topic;
    }

    /**
     * Set the topic property: The topic of the conversation. This property can be set when the conversation is created,
     * but it cannot be updated.
     * 
     * @param topic the topic value to set.
     * @return the MicrosoftGraphConversation object itself.
     */
    public MicrosoftGraphConversation withTopic(String topic) {
        this.topic = topic;
        return this;
    }

    /**
     * Get the uniqueSenders property: All the users that sent a message to this Conversation.
     * 
     * @return the uniqueSenders value.
     */
    public List<String> uniqueSenders() {
        return this.uniqueSenders;
    }

    /**
     * Set the uniqueSenders property: All the users that sent a message to this Conversation.
     * 
     * @param uniqueSenders the uniqueSenders value to set.
     * @return the MicrosoftGraphConversation object itself.
     */
    public MicrosoftGraphConversation withUniqueSenders(List<String> uniqueSenders) {
        this.uniqueSenders = uniqueSenders;
        return this;
    }

    /**
     * Get the threads property: A collection of all the conversation threads in the conversation. A navigation
     * property. Read-only. Nullable.
     * 
     * @return the threads value.
     */
    public List<MicrosoftGraphConversationThread> threads() {
        return this.threads;
    }

    /**
     * Set the threads property: A collection of all the conversation threads in the conversation. A navigation
     * property. Read-only. Nullable.
     * 
     * @param threads the threads value to set.
     * @return the MicrosoftGraphConversation object itself.
     */
    public MicrosoftGraphConversation withThreads(List<MicrosoftGraphConversationThread> threads) {
        this.threads = threads;
        return this;
    }

    /**
     * Get the additionalProperties property: conversation.
     * 
     * @return the additionalProperties value.
     */
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: conversation.
     * 
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphConversation object itself.
     */
    public MicrosoftGraphConversation withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public MicrosoftGraphConversation withId(String id) {
        super.withId(id);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (threads() != null) {
            threads().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", id());
        jsonWriter.writeBooleanField("hasAttachments", this.hasAttachments);
        jsonWriter.writeStringField("lastDeliveredDateTime",
            this.lastDeliveredDateTime == null
                ? null
                : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.lastDeliveredDateTime));
        jsonWriter.writeStringField("preview", this.preview);
        jsonWriter.writeStringField("topic", this.topic);
        jsonWriter.writeArrayField("uniqueSenders", this.uniqueSenders,
            (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("threads", this.threads, (writer, element) -> writer.writeJson(element));
        if (additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MicrosoftGraphConversation from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MicrosoftGraphConversation if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the MicrosoftGraphConversation.
     */
    public static MicrosoftGraphConversation fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MicrosoftGraphConversation deserializedMicrosoftGraphConversation = new MicrosoftGraphConversation();
            Map<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedMicrosoftGraphConversation.withId(reader.getString());
                } else if ("hasAttachments".equals(fieldName)) {
                    deserializedMicrosoftGraphConversation.hasAttachments = reader.getNullable(JsonReader::getBoolean);
                } else if ("lastDeliveredDateTime".equals(fieldName)) {
                    deserializedMicrosoftGraphConversation.lastDeliveredDateTime = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("preview".equals(fieldName)) {
                    deserializedMicrosoftGraphConversation.preview = reader.getString();
                } else if ("topic".equals(fieldName)) {
                    deserializedMicrosoftGraphConversation.topic = reader.getString();
                } else if ("uniqueSenders".equals(fieldName)) {
                    List<String> uniqueSenders = reader.readArray(reader1 -> reader1.getString());
                    deserializedMicrosoftGraphConversation.uniqueSenders = uniqueSenders;
                } else if ("threads".equals(fieldName)) {
                    List<MicrosoftGraphConversationThread> threads
                        = reader.readArray(reader1 -> MicrosoftGraphConversationThread.fromJson(reader1));
                    deserializedMicrosoftGraphConversation.threads = threads;
                } else {
                    if (additionalProperties == null) {
                        additionalProperties = new LinkedHashMap<>();
                    }

                    additionalProperties.put(fieldName, reader.readUntyped());
                }
            }
            deserializedMicrosoftGraphConversation.additionalProperties = additionalProperties;

            return deserializedMicrosoftGraphConversation;
        });
    }
}
