// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

/**
 * insightIdentity.
 */
@Fluent
public final class MicrosoftGraphInsightIdentity implements JsonSerializable<MicrosoftGraphInsightIdentity> {
    /*
     * The email address of the user who shared the item.
     */
    private String address;

    /*
     * The display name of the user who shared the item.
     */
    private String displayName;

    /*
     * The id of the user who shared the item.
     */
    private String id;

    /*
     * insightIdentity
     */
    private Map<String, Object> additionalProperties;

    /**
     * Creates an instance of MicrosoftGraphInsightIdentity class.
     */
    public MicrosoftGraphInsightIdentity() {
    }

    /**
     * Get the address property: The email address of the user who shared the item.
     * 
     * @return the address value.
     */
    public String address() {
        return this.address;
    }

    /**
     * Set the address property: The email address of the user who shared the item.
     * 
     * @param address the address value to set.
     * @return the MicrosoftGraphInsightIdentity object itself.
     */
    public MicrosoftGraphInsightIdentity withAddress(String address) {
        this.address = address;
        return this;
    }

    /**
     * Get the displayName property: The display name of the user who shared the item.
     * 
     * @return the displayName value.
     */
    public String displayName() {
        return this.displayName;
    }

    /**
     * Set the displayName property: The display name of the user who shared the item.
     * 
     * @param displayName the displayName value to set.
     * @return the MicrosoftGraphInsightIdentity object itself.
     */
    public MicrosoftGraphInsightIdentity withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    /**
     * Get the id property: The id of the user who shared the item.
     * 
     * @return the id value.
     */
    public String id() {
        return this.id;
    }

    /**
     * Set the id property: The id of the user who shared the item.
     * 
     * @param id the id value to set.
     * @return the MicrosoftGraphInsightIdentity object itself.
     */
    public MicrosoftGraphInsightIdentity withId(String id) {
        this.id = id;
        return this;
    }

    /**
     * Get the additionalProperties property: insightIdentity.
     * 
     * @return the additionalProperties value.
     */
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: insightIdentity.
     * 
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphInsightIdentity object itself.
     */
    public MicrosoftGraphInsightIdentity withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("address", this.address);
        jsonWriter.writeStringField("displayName", this.displayName);
        jsonWriter.writeStringField("id", this.id);
        if (additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MicrosoftGraphInsightIdentity from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MicrosoftGraphInsightIdentity if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the MicrosoftGraphInsightIdentity.
     */
    public static MicrosoftGraphInsightIdentity fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MicrosoftGraphInsightIdentity deserializedMicrosoftGraphInsightIdentity
                = new MicrosoftGraphInsightIdentity();
            Map<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("address".equals(fieldName)) {
                    deserializedMicrosoftGraphInsightIdentity.address = reader.getString();
                } else if ("displayName".equals(fieldName)) {
                    deserializedMicrosoftGraphInsightIdentity.displayName = reader.getString();
                } else if ("id".equals(fieldName)) {
                    deserializedMicrosoftGraphInsightIdentity.id = reader.getString();
                } else {
                    if (additionalProperties == null) {
                        additionalProperties = new LinkedHashMap<>();
                    }

                    additionalProperties.put(fieldName, reader.readUntyped());
                }
            }
            deserializedMicrosoftGraphInsightIdentity.additionalProperties = additionalProperties;

            return deserializedMicrosoftGraphInsightIdentity;
        });
    }
}
