// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

/**
 * itemReference.
 */
@Fluent
public final class MicrosoftGraphItemReference implements JsonSerializable<MicrosoftGraphItemReference> {
    /*
     * Unique identifier of the drive instance that contains the item. Read-only.
     */
    private String driveId;

    /*
     * Identifies the type of drive. See [drive][] resource for values.
     */
    private String driveType;

    /*
     * Unique identifier of the item in the drive. Read-only.
     */
    private String id;

    /*
     * The name of the item being referenced. Read-only.
     */
    private String name;

    /*
     * Path that can be used to navigate to the item. Read-only.
     */
    private String path;

    /*
     * A unique identifier for a shared resource that can be accessed via the [Shares][] API.
     */
    private String shareId;

    /*
     * sharepointIds
     */
    private MicrosoftGraphSharepointIds sharepointIds;

    /*
     * The siteId property.
     */
    private String siteId;

    /*
     * itemReference
     */
    private Map<String, Object> additionalProperties;

    /**
     * Creates an instance of MicrosoftGraphItemReference class.
     */
    public MicrosoftGraphItemReference() {
    }

    /**
     * Get the driveId property: Unique identifier of the drive instance that contains the item. Read-only.
     * 
     * @return the driveId value.
     */
    public String driveId() {
        return this.driveId;
    }

    /**
     * Set the driveId property: Unique identifier of the drive instance that contains the item. Read-only.
     * 
     * @param driveId the driveId value to set.
     * @return the MicrosoftGraphItemReference object itself.
     */
    public MicrosoftGraphItemReference withDriveId(String driveId) {
        this.driveId = driveId;
        return this;
    }

    /**
     * Get the driveType property: Identifies the type of drive. See [drive][] resource for values.
     * 
     * @return the driveType value.
     */
    public String driveType() {
        return this.driveType;
    }

    /**
     * Set the driveType property: Identifies the type of drive. See [drive][] resource for values.
     * 
     * @param driveType the driveType value to set.
     * @return the MicrosoftGraphItemReference object itself.
     */
    public MicrosoftGraphItemReference withDriveType(String driveType) {
        this.driveType = driveType;
        return this;
    }

    /**
     * Get the id property: Unique identifier of the item in the drive. Read-only.
     * 
     * @return the id value.
     */
    public String id() {
        return this.id;
    }

    /**
     * Set the id property: Unique identifier of the item in the drive. Read-only.
     * 
     * @param id the id value to set.
     * @return the MicrosoftGraphItemReference object itself.
     */
    public MicrosoftGraphItemReference withId(String id) {
        this.id = id;
        return this;
    }

    /**
     * Get the name property: The name of the item being referenced. Read-only.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: The name of the item being referenced. Read-only.
     * 
     * @param name the name value to set.
     * @return the MicrosoftGraphItemReference object itself.
     */
    public MicrosoftGraphItemReference withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the path property: Path that can be used to navigate to the item. Read-only.
     * 
     * @return the path value.
     */
    public String path() {
        return this.path;
    }

    /**
     * Set the path property: Path that can be used to navigate to the item. Read-only.
     * 
     * @param path the path value to set.
     * @return the MicrosoftGraphItemReference object itself.
     */
    public MicrosoftGraphItemReference withPath(String path) {
        this.path = path;
        return this;
    }

    /**
     * Get the shareId property: A unique identifier for a shared resource that can be accessed via the [Shares][] API.
     * 
     * @return the shareId value.
     */
    public String shareId() {
        return this.shareId;
    }

    /**
     * Set the shareId property: A unique identifier for a shared resource that can be accessed via the [Shares][] API.
     * 
     * @param shareId the shareId value to set.
     * @return the MicrosoftGraphItemReference object itself.
     */
    public MicrosoftGraphItemReference withShareId(String shareId) {
        this.shareId = shareId;
        return this;
    }

    /**
     * Get the sharepointIds property: sharepointIds.
     * 
     * @return the sharepointIds value.
     */
    public MicrosoftGraphSharepointIds sharepointIds() {
        return this.sharepointIds;
    }

    /**
     * Set the sharepointIds property: sharepointIds.
     * 
     * @param sharepointIds the sharepointIds value to set.
     * @return the MicrosoftGraphItemReference object itself.
     */
    public MicrosoftGraphItemReference withSharepointIds(MicrosoftGraphSharepointIds sharepointIds) {
        this.sharepointIds = sharepointIds;
        return this;
    }

    /**
     * Get the siteId property: The siteId property.
     * 
     * @return the siteId value.
     */
    public String siteId() {
        return this.siteId;
    }

    /**
     * Set the siteId property: The siteId property.
     * 
     * @param siteId the siteId value to set.
     * @return the MicrosoftGraphItemReference object itself.
     */
    public MicrosoftGraphItemReference withSiteId(String siteId) {
        this.siteId = siteId;
        return this;
    }

    /**
     * Get the additionalProperties property: itemReference.
     * 
     * @return the additionalProperties value.
     */
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: itemReference.
     * 
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphItemReference object itself.
     */
    public MicrosoftGraphItemReference withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (sharepointIds() != null) {
            sharepointIds().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("driveId", this.driveId);
        jsonWriter.writeStringField("driveType", this.driveType);
        jsonWriter.writeStringField("id", this.id);
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("path", this.path);
        jsonWriter.writeStringField("shareId", this.shareId);
        jsonWriter.writeJsonField("sharepointIds", this.sharepointIds);
        jsonWriter.writeStringField("siteId", this.siteId);
        if (additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MicrosoftGraphItemReference from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MicrosoftGraphItemReference if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the MicrosoftGraphItemReference.
     */
    public static MicrosoftGraphItemReference fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MicrosoftGraphItemReference deserializedMicrosoftGraphItemReference = new MicrosoftGraphItemReference();
            Map<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("driveId".equals(fieldName)) {
                    deserializedMicrosoftGraphItemReference.driveId = reader.getString();
                } else if ("driveType".equals(fieldName)) {
                    deserializedMicrosoftGraphItemReference.driveType = reader.getString();
                } else if ("id".equals(fieldName)) {
                    deserializedMicrosoftGraphItemReference.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedMicrosoftGraphItemReference.name = reader.getString();
                } else if ("path".equals(fieldName)) {
                    deserializedMicrosoftGraphItemReference.path = reader.getString();
                } else if ("shareId".equals(fieldName)) {
                    deserializedMicrosoftGraphItemReference.shareId = reader.getString();
                } else if ("sharepointIds".equals(fieldName)) {
                    deserializedMicrosoftGraphItemReference.sharepointIds
                        = MicrosoftGraphSharepointIds.fromJson(reader);
                } else if ("siteId".equals(fieldName)) {
                    deserializedMicrosoftGraphItemReference.siteId = reader.getString();
                } else {
                    if (additionalProperties == null) {
                        additionalProperties = new LinkedHashMap<>();
                    }

                    additionalProperties.put(fieldName, reader.readUntyped());
                }
            }
            deserializedMicrosoftGraphItemReference.additionalProperties = additionalProperties;

            return deserializedMicrosoftGraphItemReference;
        });
    }
}
