// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

/**
 * plannerPlanDetails.
 */
@Fluent
public final class MicrosoftGraphPlannerPlanDetails extends MicrosoftGraphEntity {
    /*
     * plannerCategoryDescriptions
     */
    private MicrosoftGraphPlannerCategoryDescriptions categoryDescriptions;

    /*
     * plannerUserIds
     */
    private Map<String, Object> sharedWith;

    /*
     * plannerPlanDetails
     */
    private Map<String, Object> additionalProperties;

    /**
     * Creates an instance of MicrosoftGraphPlannerPlanDetails class.
     */
    public MicrosoftGraphPlannerPlanDetails() {
    }

    /**
     * Get the categoryDescriptions property: plannerCategoryDescriptions.
     * 
     * @return the categoryDescriptions value.
     */
    public MicrosoftGraphPlannerCategoryDescriptions categoryDescriptions() {
        return this.categoryDescriptions;
    }

    /**
     * Set the categoryDescriptions property: plannerCategoryDescriptions.
     * 
     * @param categoryDescriptions the categoryDescriptions value to set.
     * @return the MicrosoftGraphPlannerPlanDetails object itself.
     */
    public MicrosoftGraphPlannerPlanDetails
        withCategoryDescriptions(MicrosoftGraphPlannerCategoryDescriptions categoryDescriptions) {
        this.categoryDescriptions = categoryDescriptions;
        return this;
    }

    /**
     * Get the sharedWith property: plannerUserIds.
     * 
     * @return the sharedWith value.
     */
    public Map<String, Object> sharedWith() {
        return this.sharedWith;
    }

    /**
     * Set the sharedWith property: plannerUserIds.
     * 
     * @param sharedWith the sharedWith value to set.
     * @return the MicrosoftGraphPlannerPlanDetails object itself.
     */
    public MicrosoftGraphPlannerPlanDetails withSharedWith(Map<String, Object> sharedWith) {
        this.sharedWith = sharedWith;
        return this;
    }

    /**
     * Get the additionalProperties property: plannerPlanDetails.
     * 
     * @return the additionalProperties value.
     */
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: plannerPlanDetails.
     * 
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphPlannerPlanDetails object itself.
     */
    public MicrosoftGraphPlannerPlanDetails withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public MicrosoftGraphPlannerPlanDetails withId(String id) {
        super.withId(id);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (categoryDescriptions() != null) {
            categoryDescriptions().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", id());
        jsonWriter.writeJsonField("categoryDescriptions", this.categoryDescriptions);
        jsonWriter.writeMapField("sharedWith", this.sharedWith, (writer, element) -> writer.writeUntyped(element));
        if (additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MicrosoftGraphPlannerPlanDetails from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MicrosoftGraphPlannerPlanDetails if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the MicrosoftGraphPlannerPlanDetails.
     */
    public static MicrosoftGraphPlannerPlanDetails fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MicrosoftGraphPlannerPlanDetails deserializedMicrosoftGraphPlannerPlanDetails
                = new MicrosoftGraphPlannerPlanDetails();
            Map<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedMicrosoftGraphPlannerPlanDetails.withId(reader.getString());
                } else if ("categoryDescriptions".equals(fieldName)) {
                    deserializedMicrosoftGraphPlannerPlanDetails.categoryDescriptions
                        = MicrosoftGraphPlannerCategoryDescriptions.fromJson(reader);
                } else if ("sharedWith".equals(fieldName)) {
                    Map<String, Object> sharedWith = reader.readMap(reader1 -> reader1.readUntyped());
                    deserializedMicrosoftGraphPlannerPlanDetails.sharedWith = sharedWith;
                } else {
                    if (additionalProperties == null) {
                        additionalProperties = new LinkedHashMap<>();
                    }

                    additionalProperties.put(fieldName, reader.readUntyped());
                }
            }
            deserializedMicrosoftGraphPlannerPlanDetails.additionalProperties = additionalProperties;

            return deserializedMicrosoftGraphPlannerPlanDetails;
        });
    }
}
