// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.LinkedHashMap;
import java.util.Map;

/**
 * remoteItem.
 */
@Fluent
public final class MicrosoftGraphRemoteItem implements JsonSerializable<MicrosoftGraphRemoteItem> {
    /*
     * identitySet
     */
    private MicrosoftGraphIdentitySet createdBy;

    /*
     * Date and time of item creation. Read-only.
     */
    private OffsetDateTime createdDateTime;

    /*
     * file
     */
    private MicrosoftGraphFile file;

    /*
     * fileSystemInfo
     */
    private MicrosoftGraphFileSystemInfo fileSystemInfo;

    /*
     * folder
     */
    private MicrosoftGraphFolder folder;

    /*
     * Unique identifier for the remote item in its drive. Read-only.
     */
    private String id;

    /*
     * image
     */
    private MicrosoftGraphImage image;

    /*
     * identitySet
     */
    private MicrosoftGraphIdentitySet lastModifiedBy;

    /*
     * Date and time the item was last modified. Read-only.
     */
    private OffsetDateTime lastModifiedDateTime;

    /*
     * Optional. Filename of the remote item. Read-only.
     */
    private String name;

    /*
     * package
     */
    private MicrosoftGraphPackage packageProperty;

    /*
     * itemReference
     */
    private MicrosoftGraphItemReference parentReference;

    /*
     * shared
     */
    private MicrosoftGraphShared shared;

    /*
     * sharepointIds
     */
    private MicrosoftGraphSharepointIds sharepointIds;

    /*
     * Size of the remote item. Read-only.
     */
    private Long size;

    /*
     * specialFolder
     */
    private MicrosoftGraphSpecialFolder specialFolder;

    /*
     * video
     */
    private MicrosoftGraphVideo video;

    /*
     * DAV compatible URL for the item.
     */
    private String webDavUrl;

    /*
     * URL that displays the resource in the browser. Read-only.
     */
    private String webUrl;

    /*
     * remoteItem
     */
    private Map<String, Object> additionalProperties;

    /**
     * Creates an instance of MicrosoftGraphRemoteItem class.
     */
    public MicrosoftGraphRemoteItem() {
    }

    /**
     * Get the createdBy property: identitySet.
     * 
     * @return the createdBy value.
     */
    public MicrosoftGraphIdentitySet createdBy() {
        return this.createdBy;
    }

    /**
     * Set the createdBy property: identitySet.
     * 
     * @param createdBy the createdBy value to set.
     * @return the MicrosoftGraphRemoteItem object itself.
     */
    public MicrosoftGraphRemoteItem withCreatedBy(MicrosoftGraphIdentitySet createdBy) {
        this.createdBy = createdBy;
        return this;
    }

    /**
     * Get the createdDateTime property: Date and time of item creation. Read-only.
     * 
     * @return the createdDateTime value.
     */
    public OffsetDateTime createdDateTime() {
        return this.createdDateTime;
    }

    /**
     * Set the createdDateTime property: Date and time of item creation. Read-only.
     * 
     * @param createdDateTime the createdDateTime value to set.
     * @return the MicrosoftGraphRemoteItem object itself.
     */
    public MicrosoftGraphRemoteItem withCreatedDateTime(OffsetDateTime createdDateTime) {
        this.createdDateTime = createdDateTime;
        return this;
    }

    /**
     * Get the file property: file.
     * 
     * @return the file value.
     */
    public MicrosoftGraphFile file() {
        return this.file;
    }

    /**
     * Set the file property: file.
     * 
     * @param file the file value to set.
     * @return the MicrosoftGraphRemoteItem object itself.
     */
    public MicrosoftGraphRemoteItem withFile(MicrosoftGraphFile file) {
        this.file = file;
        return this;
    }

    /**
     * Get the fileSystemInfo property: fileSystemInfo.
     * 
     * @return the fileSystemInfo value.
     */
    public MicrosoftGraphFileSystemInfo fileSystemInfo() {
        return this.fileSystemInfo;
    }

    /**
     * Set the fileSystemInfo property: fileSystemInfo.
     * 
     * @param fileSystemInfo the fileSystemInfo value to set.
     * @return the MicrosoftGraphRemoteItem object itself.
     */
    public MicrosoftGraphRemoteItem withFileSystemInfo(MicrosoftGraphFileSystemInfo fileSystemInfo) {
        this.fileSystemInfo = fileSystemInfo;
        return this;
    }

    /**
     * Get the folder property: folder.
     * 
     * @return the folder value.
     */
    public MicrosoftGraphFolder folder() {
        return this.folder;
    }

    /**
     * Set the folder property: folder.
     * 
     * @param folder the folder value to set.
     * @return the MicrosoftGraphRemoteItem object itself.
     */
    public MicrosoftGraphRemoteItem withFolder(MicrosoftGraphFolder folder) {
        this.folder = folder;
        return this;
    }

    /**
     * Get the id property: Unique identifier for the remote item in its drive. Read-only.
     * 
     * @return the id value.
     */
    public String id() {
        return this.id;
    }

    /**
     * Set the id property: Unique identifier for the remote item in its drive. Read-only.
     * 
     * @param id the id value to set.
     * @return the MicrosoftGraphRemoteItem object itself.
     */
    public MicrosoftGraphRemoteItem withId(String id) {
        this.id = id;
        return this;
    }

    /**
     * Get the image property: image.
     * 
     * @return the image value.
     */
    public MicrosoftGraphImage image() {
        return this.image;
    }

    /**
     * Set the image property: image.
     * 
     * @param image the image value to set.
     * @return the MicrosoftGraphRemoteItem object itself.
     */
    public MicrosoftGraphRemoteItem withImage(MicrosoftGraphImage image) {
        this.image = image;
        return this;
    }

    /**
     * Get the lastModifiedBy property: identitySet.
     * 
     * @return the lastModifiedBy value.
     */
    public MicrosoftGraphIdentitySet lastModifiedBy() {
        return this.lastModifiedBy;
    }

    /**
     * Set the lastModifiedBy property: identitySet.
     * 
     * @param lastModifiedBy the lastModifiedBy value to set.
     * @return the MicrosoftGraphRemoteItem object itself.
     */
    public MicrosoftGraphRemoteItem withLastModifiedBy(MicrosoftGraphIdentitySet lastModifiedBy) {
        this.lastModifiedBy = lastModifiedBy;
        return this;
    }

    /**
     * Get the lastModifiedDateTime property: Date and time the item was last modified. Read-only.
     * 
     * @return the lastModifiedDateTime value.
     */
    public OffsetDateTime lastModifiedDateTime() {
        return this.lastModifiedDateTime;
    }

    /**
     * Set the lastModifiedDateTime property: Date and time the item was last modified. Read-only.
     * 
     * @param lastModifiedDateTime the lastModifiedDateTime value to set.
     * @return the MicrosoftGraphRemoteItem object itself.
     */
    public MicrosoftGraphRemoteItem withLastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
        this.lastModifiedDateTime = lastModifiedDateTime;
        return this;
    }

    /**
     * Get the name property: Optional. Filename of the remote item. Read-only.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: Optional. Filename of the remote item. Read-only.
     * 
     * @param name the name value to set.
     * @return the MicrosoftGraphRemoteItem object itself.
     */
    public MicrosoftGraphRemoteItem withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the packageProperty property: package.
     * 
     * @return the packageProperty value.
     */
    public MicrosoftGraphPackage packageProperty() {
        return this.packageProperty;
    }

    /**
     * Set the packageProperty property: package.
     * 
     * @param packageProperty the packageProperty value to set.
     * @return the MicrosoftGraphRemoteItem object itself.
     */
    public MicrosoftGraphRemoteItem withPackageProperty(MicrosoftGraphPackage packageProperty) {
        this.packageProperty = packageProperty;
        return this;
    }

    /**
     * Get the parentReference property: itemReference.
     * 
     * @return the parentReference value.
     */
    public MicrosoftGraphItemReference parentReference() {
        return this.parentReference;
    }

    /**
     * Set the parentReference property: itemReference.
     * 
     * @param parentReference the parentReference value to set.
     * @return the MicrosoftGraphRemoteItem object itself.
     */
    public MicrosoftGraphRemoteItem withParentReference(MicrosoftGraphItemReference parentReference) {
        this.parentReference = parentReference;
        return this;
    }

    /**
     * Get the shared property: shared.
     * 
     * @return the shared value.
     */
    public MicrosoftGraphShared shared() {
        return this.shared;
    }

    /**
     * Set the shared property: shared.
     * 
     * @param shared the shared value to set.
     * @return the MicrosoftGraphRemoteItem object itself.
     */
    public MicrosoftGraphRemoteItem withShared(MicrosoftGraphShared shared) {
        this.shared = shared;
        return this;
    }

    /**
     * Get the sharepointIds property: sharepointIds.
     * 
     * @return the sharepointIds value.
     */
    public MicrosoftGraphSharepointIds sharepointIds() {
        return this.sharepointIds;
    }

    /**
     * Set the sharepointIds property: sharepointIds.
     * 
     * @param sharepointIds the sharepointIds value to set.
     * @return the MicrosoftGraphRemoteItem object itself.
     */
    public MicrosoftGraphRemoteItem withSharepointIds(MicrosoftGraphSharepointIds sharepointIds) {
        this.sharepointIds = sharepointIds;
        return this;
    }

    /**
     * Get the size property: Size of the remote item. Read-only.
     * 
     * @return the size value.
     */
    public Long size() {
        return this.size;
    }

    /**
     * Set the size property: Size of the remote item. Read-only.
     * 
     * @param size the size value to set.
     * @return the MicrosoftGraphRemoteItem object itself.
     */
    public MicrosoftGraphRemoteItem withSize(Long size) {
        this.size = size;
        return this;
    }

    /**
     * Get the specialFolder property: specialFolder.
     * 
     * @return the specialFolder value.
     */
    public MicrosoftGraphSpecialFolder specialFolder() {
        return this.specialFolder;
    }

    /**
     * Set the specialFolder property: specialFolder.
     * 
     * @param specialFolder the specialFolder value to set.
     * @return the MicrosoftGraphRemoteItem object itself.
     */
    public MicrosoftGraphRemoteItem withSpecialFolder(MicrosoftGraphSpecialFolder specialFolder) {
        this.specialFolder = specialFolder;
        return this;
    }

    /**
     * Get the video property: video.
     * 
     * @return the video value.
     */
    public MicrosoftGraphVideo video() {
        return this.video;
    }

    /**
     * Set the video property: video.
     * 
     * @param video the video value to set.
     * @return the MicrosoftGraphRemoteItem object itself.
     */
    public MicrosoftGraphRemoteItem withVideo(MicrosoftGraphVideo video) {
        this.video = video;
        return this;
    }

    /**
     * Get the webDavUrl property: DAV compatible URL for the item.
     * 
     * @return the webDavUrl value.
     */
    public String webDavUrl() {
        return this.webDavUrl;
    }

    /**
     * Set the webDavUrl property: DAV compatible URL for the item.
     * 
     * @param webDavUrl the webDavUrl value to set.
     * @return the MicrosoftGraphRemoteItem object itself.
     */
    public MicrosoftGraphRemoteItem withWebDavUrl(String webDavUrl) {
        this.webDavUrl = webDavUrl;
        return this;
    }

    /**
     * Get the webUrl property: URL that displays the resource in the browser. Read-only.
     * 
     * @return the webUrl value.
     */
    public String webUrl() {
        return this.webUrl;
    }

    /**
     * Set the webUrl property: URL that displays the resource in the browser. Read-only.
     * 
     * @param webUrl the webUrl value to set.
     * @return the MicrosoftGraphRemoteItem object itself.
     */
    public MicrosoftGraphRemoteItem withWebUrl(String webUrl) {
        this.webUrl = webUrl;
        return this;
    }

    /**
     * Get the additionalProperties property: remoteItem.
     * 
     * @return the additionalProperties value.
     */
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: remoteItem.
     * 
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphRemoteItem object itself.
     */
    public MicrosoftGraphRemoteItem withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (createdBy() != null) {
            createdBy().validate();
        }
        if (file() != null) {
            file().validate();
        }
        if (fileSystemInfo() != null) {
            fileSystemInfo().validate();
        }
        if (folder() != null) {
            folder().validate();
        }
        if (image() != null) {
            image().validate();
        }
        if (lastModifiedBy() != null) {
            lastModifiedBy().validate();
        }
        if (packageProperty() != null) {
            packageProperty().validate();
        }
        if (parentReference() != null) {
            parentReference().validate();
        }
        if (shared() != null) {
            shared().validate();
        }
        if (sharepointIds() != null) {
            sharepointIds().validate();
        }
        if (specialFolder() != null) {
            specialFolder().validate();
        }
        if (video() != null) {
            video().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("createdBy", this.createdBy);
        jsonWriter.writeStringField("createdDateTime",
            this.createdDateTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.createdDateTime));
        jsonWriter.writeJsonField("file", this.file);
        jsonWriter.writeJsonField("fileSystemInfo", this.fileSystemInfo);
        jsonWriter.writeJsonField("folder", this.folder);
        jsonWriter.writeStringField("id", this.id);
        jsonWriter.writeJsonField("image", this.image);
        jsonWriter.writeJsonField("lastModifiedBy", this.lastModifiedBy);
        jsonWriter.writeStringField("lastModifiedDateTime",
            this.lastModifiedDateTime == null
                ? null
                : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.lastModifiedDateTime));
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeJsonField("package", this.packageProperty);
        jsonWriter.writeJsonField("parentReference", this.parentReference);
        jsonWriter.writeJsonField("shared", this.shared);
        jsonWriter.writeJsonField("sharepointIds", this.sharepointIds);
        jsonWriter.writeNumberField("size", this.size);
        jsonWriter.writeJsonField("specialFolder", this.specialFolder);
        jsonWriter.writeJsonField("video", this.video);
        jsonWriter.writeStringField("webDavUrl", this.webDavUrl);
        jsonWriter.writeStringField("webUrl", this.webUrl);
        if (additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MicrosoftGraphRemoteItem from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MicrosoftGraphRemoteItem if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the MicrosoftGraphRemoteItem.
     */
    public static MicrosoftGraphRemoteItem fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MicrosoftGraphRemoteItem deserializedMicrosoftGraphRemoteItem = new MicrosoftGraphRemoteItem();
            Map<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("createdBy".equals(fieldName)) {
                    deserializedMicrosoftGraphRemoteItem.createdBy = MicrosoftGraphIdentitySet.fromJson(reader);
                } else if ("createdDateTime".equals(fieldName)) {
                    deserializedMicrosoftGraphRemoteItem.createdDateTime = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("file".equals(fieldName)) {
                    deserializedMicrosoftGraphRemoteItem.file = MicrosoftGraphFile.fromJson(reader);
                } else if ("fileSystemInfo".equals(fieldName)) {
                    deserializedMicrosoftGraphRemoteItem.fileSystemInfo = MicrosoftGraphFileSystemInfo.fromJson(reader);
                } else if ("folder".equals(fieldName)) {
                    deserializedMicrosoftGraphRemoteItem.folder = MicrosoftGraphFolder.fromJson(reader);
                } else if ("id".equals(fieldName)) {
                    deserializedMicrosoftGraphRemoteItem.id = reader.getString();
                } else if ("image".equals(fieldName)) {
                    deserializedMicrosoftGraphRemoteItem.image = MicrosoftGraphImage.fromJson(reader);
                } else if ("lastModifiedBy".equals(fieldName)) {
                    deserializedMicrosoftGraphRemoteItem.lastModifiedBy = MicrosoftGraphIdentitySet.fromJson(reader);
                } else if ("lastModifiedDateTime".equals(fieldName)) {
                    deserializedMicrosoftGraphRemoteItem.lastModifiedDateTime = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("name".equals(fieldName)) {
                    deserializedMicrosoftGraphRemoteItem.name = reader.getString();
                } else if ("package".equals(fieldName)) {
                    deserializedMicrosoftGraphRemoteItem.packageProperty = MicrosoftGraphPackage.fromJson(reader);
                } else if ("parentReference".equals(fieldName)) {
                    deserializedMicrosoftGraphRemoteItem.parentReference = MicrosoftGraphItemReference.fromJson(reader);
                } else if ("shared".equals(fieldName)) {
                    deserializedMicrosoftGraphRemoteItem.shared = MicrosoftGraphShared.fromJson(reader);
                } else if ("sharepointIds".equals(fieldName)) {
                    deserializedMicrosoftGraphRemoteItem.sharepointIds = MicrosoftGraphSharepointIds.fromJson(reader);
                } else if ("size".equals(fieldName)) {
                    deserializedMicrosoftGraphRemoteItem.size = reader.getNullable(JsonReader::getLong);
                } else if ("specialFolder".equals(fieldName)) {
                    deserializedMicrosoftGraphRemoteItem.specialFolder = MicrosoftGraphSpecialFolder.fromJson(reader);
                } else if ("video".equals(fieldName)) {
                    deserializedMicrosoftGraphRemoteItem.video = MicrosoftGraphVideo.fromJson(reader);
                } else if ("webDavUrl".equals(fieldName)) {
                    deserializedMicrosoftGraphRemoteItem.webDavUrl = reader.getString();
                } else if ("webUrl".equals(fieldName)) {
                    deserializedMicrosoftGraphRemoteItem.webUrl = reader.getString();
                } else {
                    if (additionalProperties == null) {
                        additionalProperties = new LinkedHashMap<>();
                    }

                    additionalProperties.put(fieldName, reader.readUntyped());
                }
            }
            deserializedMicrosoftGraphRemoteItem.additionalProperties = additionalProperties;

            return deserializedMicrosoftGraphRemoteItem;
        });
    }
}
