// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The name of the entity last modified it.
 */
@Fluent
public final class Principal implements JsonSerializable<Principal> {
    /*
     * The id of the principal made changes
     */
    private String id;

    /*
     * The name of the principal made changes
     */
    private String displayName;

    /*
     * Type of principal such as user , group etc
     */
    private String type;

    /*
     * Email of principal
     */
    private String email;

    /**
     * Creates an instance of Principal class.
     */
    public Principal() {
    }

    /**
     * Get the id property: The id of the principal made changes.
     * 
     * @return the id value.
     */
    public String id() {
        return this.id;
    }

    /**
     * Set the id property: The id of the principal made changes.
     * 
     * @param id the id value to set.
     * @return the Principal object itself.
     */
    public Principal withId(String id) {
        this.id = id;
        return this;
    }

    /**
     * Get the displayName property: The name of the principal made changes.
     * 
     * @return the displayName value.
     */
    public String displayName() {
        return this.displayName;
    }

    /**
     * Set the displayName property: The name of the principal made changes.
     * 
     * @param displayName the displayName value to set.
     * @return the Principal object itself.
     */
    public Principal withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    /**
     * Get the type property: Type of principal such as user , group etc.
     * 
     * @return the type value.
     */
    public String type() {
        return this.type;
    }

    /**
     * Set the type property: Type of principal such as user , group etc.
     * 
     * @param type the type value to set.
     * @return the Principal object itself.
     */
    public Principal withType(String type) {
        this.type = type;
        return this;
    }

    /**
     * Get the email property: Email of principal.
     * 
     * @return the email value.
     */
    public String email() {
        return this.email;
    }

    /**
     * Set the email property: Email of principal.
     * 
     * @param email the email value to set.
     * @return the Principal object itself.
     */
    public Principal withEmail(String email) {
        this.email = email;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id);
        jsonWriter.writeStringField("displayName", this.displayName);
        jsonWriter.writeStringField("type", this.type);
        jsonWriter.writeStringField("email", this.email);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of Principal from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of Principal if the JsonReader was pointing to an instance of it, or null if it was pointing
     * to JSON null.
     * @throws IOException If an error occurs while reading the Principal.
     */
    public static Principal fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            Principal deserializedPrincipal = new Principal();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedPrincipal.id = reader.getString();
                } else if ("displayName".equals(fieldName)) {
                    deserializedPrincipal.displayName = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedPrincipal.type = reader.getString();
                } else if ("email".equals(fieldName)) {
                    deserializedPrincipal.email = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedPrincipal;
        });
    }
}
