/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphEntity;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphPost;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphRecipient;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class MicrosoftGraphConversationThread
extends MicrosoftGraphEntity {
    private List<MicrosoftGraphRecipient> ccRecipients;
    private Boolean hasAttachments;
    private Boolean isLocked;
    private OffsetDateTime lastDeliveredDateTime;
    private String preview;
    private String topic;
    private List<MicrosoftGraphRecipient> toRecipients;
    private List<String> uniqueSenders;
    private List<MicrosoftGraphPost> posts;
    private Map<String, Object> additionalProperties;

    public List<MicrosoftGraphRecipient> ccRecipients() {
        return this.ccRecipients;
    }

    public MicrosoftGraphConversationThread withCcRecipients(List<MicrosoftGraphRecipient> ccRecipients) {
        this.ccRecipients = ccRecipients;
        return this;
    }

    public Boolean hasAttachments() {
        return this.hasAttachments;
    }

    public MicrosoftGraphConversationThread withHasAttachments(Boolean hasAttachments) {
        this.hasAttachments = hasAttachments;
        return this;
    }

    public Boolean isLocked() {
        return this.isLocked;
    }

    public MicrosoftGraphConversationThread withIsLocked(Boolean isLocked) {
        this.isLocked = isLocked;
        return this;
    }

    public OffsetDateTime lastDeliveredDateTime() {
        return this.lastDeliveredDateTime;
    }

    public MicrosoftGraphConversationThread withLastDeliveredDateTime(OffsetDateTime lastDeliveredDateTime) {
        this.lastDeliveredDateTime = lastDeliveredDateTime;
        return this;
    }

    public String preview() {
        return this.preview;
    }

    public MicrosoftGraphConversationThread withPreview(String preview) {
        this.preview = preview;
        return this;
    }

    public String topic() {
        return this.topic;
    }

    public MicrosoftGraphConversationThread withTopic(String topic) {
        this.topic = topic;
        return this;
    }

    public List<MicrosoftGraphRecipient> toRecipients() {
        return this.toRecipients;
    }

    public MicrosoftGraphConversationThread withToRecipients(List<MicrosoftGraphRecipient> toRecipients) {
        this.toRecipients = toRecipients;
        return this;
    }

    public List<String> uniqueSenders() {
        return this.uniqueSenders;
    }

    public MicrosoftGraphConversationThread withUniqueSenders(List<String> uniqueSenders) {
        this.uniqueSenders = uniqueSenders;
        return this;
    }

    public List<MicrosoftGraphPost> posts() {
        return this.posts;
    }

    public MicrosoftGraphConversationThread withPosts(List<MicrosoftGraphPost> posts) {
        this.posts = posts;
        return this;
    }

    @Override
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public MicrosoftGraphConversationThread withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @Override
    public MicrosoftGraphConversationThread withId(String id) {
        super.withId(id);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.ccRecipients() != null) {
            this.ccRecipients().forEach(e -> e.validate());
        }
        if (this.toRecipients() != null) {
            this.toRecipients().forEach(e -> e.validate());
        }
        if (this.posts() != null) {
            this.posts().forEach(e -> e.validate());
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id());
        jsonWriter.writeArrayField("ccRecipients", this.ccRecipients, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeBooleanField("hasAttachments", this.hasAttachments);
        jsonWriter.writeBooleanField("isLocked", this.isLocked);
        jsonWriter.writeStringField("lastDeliveredDateTime", this.lastDeliveredDateTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.lastDeliveredDateTime));
        jsonWriter.writeStringField("preview", this.preview);
        jsonWriter.writeStringField("topic", this.topic);
        jsonWriter.writeArrayField("toRecipients", this.toRecipients, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("uniqueSenders", this.uniqueSenders, (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("posts", this.posts, (writer, element) -> writer.writeJson((JsonSerializable)element));
        if (this.additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static MicrosoftGraphConversationThread fromJson(JsonReader jsonReader) throws IOException {
        return (MicrosoftGraphConversationThread)jsonReader.readObject(reader -> {
            MicrosoftGraphConversationThread deserializedMicrosoftGraphConversationThread = new MicrosoftGraphConversationThread();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedMicrosoftGraphConversationThread.withId(reader.getString());
                    continue;
                }
                if ("ccRecipients".equals(fieldName)) {
                    List ccRecipients;
                    deserializedMicrosoftGraphConversationThread.ccRecipients = ccRecipients = reader.readArray(reader1 -> MicrosoftGraphRecipient.fromJson(reader1));
                    continue;
                }
                if ("hasAttachments".equals(fieldName)) {
                    deserializedMicrosoftGraphConversationThread.hasAttachments = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("isLocked".equals(fieldName)) {
                    deserializedMicrosoftGraphConversationThread.isLocked = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("lastDeliveredDateTime".equals(fieldName)) {
                    deserializedMicrosoftGraphConversationThread.lastDeliveredDateTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("preview".equals(fieldName)) {
                    deserializedMicrosoftGraphConversationThread.preview = reader.getString();
                    continue;
                }
                if ("topic".equals(fieldName)) {
                    deserializedMicrosoftGraphConversationThread.topic = reader.getString();
                    continue;
                }
                if ("toRecipients".equals(fieldName)) {
                    List toRecipients;
                    deserializedMicrosoftGraphConversationThread.toRecipients = toRecipients = reader.readArray(reader1 -> MicrosoftGraphRecipient.fromJson(reader1));
                    continue;
                }
                if ("uniqueSenders".equals(fieldName)) {
                    List uniqueSenders;
                    deserializedMicrosoftGraphConversationThread.uniqueSenders = uniqueSenders = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("posts".equals(fieldName)) {
                    List posts;
                    deserializedMicrosoftGraphConversationThread.posts = posts = reader.readArray(reader1 -> MicrosoftGraphPost.fromJson(reader1));
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedMicrosoftGraphConversationThread.additionalProperties = additionalProperties;
            return deserializedMicrosoftGraphConversationThread;
        });
    }
}

