// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/**
 * Collection of links of directoryObject.
 */
@Fluent
public final class CollectionOfLinksOfDirectoryObject implements JsonSerializable<CollectionOfLinksOfDirectoryObject> {
    /*
     * The value property.
     */
    private List<String> value;

    /*
     * The @odata.nextLink property.
     */
    private String odataNextLink;

    /*
     * Collection of links of directoryObject
     */
    private Map<String, Object> additionalProperties;

    /**
     * Creates an instance of CollectionOfLinksOfDirectoryObject class.
     */
    public CollectionOfLinksOfDirectoryObject() {
    }

    /**
     * Get the value property: The value property.
     * 
     * @return the value value.
     */
    public List<String> value() {
        return this.value;
    }

    /**
     * Set the value property: The value property.
     * 
     * @param value the value value to set.
     * @return the CollectionOfLinksOfDirectoryObject object itself.
     */
    public CollectionOfLinksOfDirectoryObject withValue(List<String> value) {
        this.value = value;
        return this;
    }

    /**
     * Get the odataNextLink property: The &#064;odata.nextLink property.
     * 
     * @return the odataNextLink value.
     */
    public String odataNextLink() {
        return this.odataNextLink;
    }

    /**
     * Set the odataNextLink property: The &#064;odata.nextLink property.
     * 
     * @param odataNextLink the odataNextLink value to set.
     * @return the CollectionOfLinksOfDirectoryObject object itself.
     */
    public CollectionOfLinksOfDirectoryObject withOdataNextLink(String odataNextLink) {
        this.odataNextLink = odataNextLink;
        return this;
    }

    /**
     * Get the additionalProperties property: Collection of links of directoryObject.
     * 
     * @return the additionalProperties value.
     */
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: Collection of links of directoryObject.
     * 
     * @param additionalProperties the additionalProperties value to set.
     * @return the CollectionOfLinksOfDirectoryObject object itself.
     */
    public CollectionOfLinksOfDirectoryObject withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("@odata.nextLink", this.odataNextLink);
        if (additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of CollectionOfLinksOfDirectoryObject from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of CollectionOfLinksOfDirectoryObject if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the CollectionOfLinksOfDirectoryObject.
     */
    public static CollectionOfLinksOfDirectoryObject fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            CollectionOfLinksOfDirectoryObject deserializedCollectionOfLinksOfDirectoryObject
                = new CollectionOfLinksOfDirectoryObject();
            Map<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    List<String> value = reader.readArray(reader1 -> reader1.getString());
                    deserializedCollectionOfLinksOfDirectoryObject.value = value;
                } else if ("@odata.nextLink".equals(fieldName)) {
                    deserializedCollectionOfLinksOfDirectoryObject.odataNextLink = reader.getString();
                } else {
                    if (additionalProperties == null) {
                        additionalProperties = new LinkedHashMap<>();
                    }

                    additionalProperties.put(fieldName, reader.readUntyped());
                }
            }
            deserializedCollectionOfLinksOfDirectoryObject.additionalProperties = additionalProperties;

            return deserializedCollectionOfLinksOfDirectoryObject;
        });
    }
}
